/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.AbstractRange;
import gololang.Range;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class CharRange
extends AbstractRange<Character> {
    CharRange(char from, char to) {
        super(Character.valueOf(from), Character.valueOf(to));
    }

    CharRange(char to) {
        super(Character.valueOf(to));
    }

    @Override
    Character defaultValue() {
        return Character.valueOf('A');
    }

    @Override
    public Range<Character> reversed() {
        return new CharRange(((Character)this.to()).charValue(), ((Character)this.from()).charValue()).decrementBy(this.increment());
    }

    @Override
    public int size() {
        if (((Character)this.to()).equals(this.from())) {
            return 0;
        }
        int s = (((Character)this.to()).charValue() - ((Character)this.from()).charValue()) / this.increment();
        if (s < 0) {
            return 0;
        }
        if (s == 0) {
            return 1;
        }
        return s;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Character)) {
            return false;
        }
        Character obj = (Character)o;
        return this.encloses(obj) && (obj.charValue() - ((Character)this.from()).charValue()) % this.increment() == 0;
    }

    @Override
    public Range<Character> tail() {
        if (this.isEmpty()) {
            return this;
        }
        return new CharRange((char)(((Character)this.from()).charValue() + this.increment()), ((Character)this.to()).charValue()).incrementBy(this.increment());
    }

    @Override
    public Iterator<Character> iterator() {
        return new AbstractRange.RangeIterator<Character>(){
            private boolean started = false;
            private char current = ((Character)CharRange.this.from()).charValue();
            private final char to = ((Character)CharRange.this.to()).charValue();

            @Override
            public boolean hasNext() {
                return Character.compare(this.to, this.current) * CharRange.this.cmp() > 0;
            }

            @Override
            public Character next() {
                Character value = Character.valueOf(this.current);
                if (this.started && !this.hasNext()) {
                    throw new NoSuchElementException("iteration has finished");
                }
                this.started = true;
                this.current = (char)(this.current + CharRange.this.increment());
                return value;
            }
        };
    }
}

