/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Messages;
import gololang.Tuple;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.eclipse.golo.runtime.ArrayHelper;
import org.eclipse.golo.runtime.MethodFinder;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.PrimitiveArrayIterator;

class ArrayMethodFinder
extends MethodFinder {
    ArrayMethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        super(invocation, lookup);
    }

    private void checkArity(int value) {
        if (this.invocation.arity() != value + 1) {
            throw new UnsupportedOperationException(Messages.message("array_method_bad_arity", this.invocation.name(), value));
        }
    }

    @Override
    public MethodHandle find() {
        try {
            return this.invocation.coerce(this.resolve());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private MethodHandle resolve() throws NoSuchMethodException, IllegalAccessException {
        switch (this.invocation.name()) {
            case "get": {
                this.checkArity(1);
                return MethodHandles.arrayElementGetter(this.invocation.receiverClass());
            }
            case "set": {
                this.checkArity(2);
                return MethodHandles.arrayElementSetter(this.invocation.receiverClass());
            }
            case "size": 
            case "length": {
                this.checkArity(0);
                return this.lookup.findStatic(Array.class, "getLength", MethodType.methodType(Integer.TYPE, Object.class));
            }
            case "iterator": {
                this.checkArity(0);
                return this.lookup.findConstructor(PrimitiveArrayIterator.class, MethodType.methodType(Void.TYPE, Object[].class));
            }
            case "toString": {
                this.checkArity(0);
                return this.lookup.findStatic(Arrays.class, "toString", MethodType.methodType(String.class, Object[].class));
            }
            case "asList": {
                this.checkArity(0);
                return this.lookup.findStatic(Arrays.class, "asList", MethodType.methodType(List.class, Object[].class));
            }
            case "toArray": {
                this.checkArity(0);
                return MethodHandles.identity(this.invocation.receiverClass());
            }
            case "destruct": {
                this.checkArity(0);
                return this.lookup.findStatic(Tuple.class, "fromArray", MethodType.methodType(Tuple.class, Object[].class));
            }
            case "equals": {
                this.checkArity(1);
                return this.lookup.findStatic(Arrays.class, "equals", MethodType.methodType(Boolean.TYPE, Object[].class, Object[].class));
            }
            case "getClass": {
                this.checkArity(0);
                return MethodHandles.dropArguments(MethodHandles.constant(Class.class, this.invocation.receiverClass()), 0, new Class[]{this.invocation.receiverClass()});
            }
            case "head": {
                this.checkArity(0);
                return this.lookup.findStatic(ArrayHelper.class, "head", MethodType.methodType(Object.class, Object[].class));
            }
            case "tail": {
                this.checkArity(0);
                return this.lookup.findStatic(ArrayHelper.class, "tail", MethodType.methodType(Object[].class, Object[].class));
            }
            case "isEmpty": {
                this.checkArity(0);
                return this.lookup.findStatic(ArrayHelper.class, "isEmpty", MethodType.methodType(Boolean.TYPE, Object[].class));
            }
        }
        throw new UnsupportedOperationException(Messages.message("array_method_not_supported", this.invocation.name()));
    }
}

