/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.AbstractGoloIrVisitor;
import org.eclipse.golo.compiler.ir.BinaryOperation;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.BlockContainer;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.CaseStatement;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.CollectionComprehension;
import org.eclipse.golo.compiler.ir.CollectionLiteral;
import org.eclipse.golo.compiler.ir.ConditionalBranching;
import org.eclipse.golo.compiler.ir.ConstantStatement;
import org.eclipse.golo.compiler.ir.DestructuringAssignment;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.ForEachLoopStatement;
import org.eclipse.golo.compiler.ir.FunctionContainer;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloAssignment;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.LoopStatement;
import org.eclipse.golo.compiler.ir.MatchExpression;
import org.eclipse.golo.compiler.ir.MethodInvocation;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.ir.Struct;
import org.eclipse.golo.compiler.ir.SymbolGenerator;
import org.eclipse.golo.compiler.ir.UnaryOperation;
import org.eclipse.golo.compiler.ir.WhenClause;
import org.eclipse.golo.compiler.parser.GoloParser;

class SugarExpansionVisitor
extends AbstractGoloIrVisitor {
    private final SymbolGenerator symbols = new SymbolGenerator("sugar");
    private final List<GoloFunction> functionsToAdd = new LinkedList<GoloFunction>();
    private GoloModule module;

    SugarExpansionVisitor() {
    }

    @Override
    public void visitModule(GoloModule module) {
        this.module = module;
        module.walk(this);
        for (GoloFunction f : this.functionsToAdd) {
            module.addFunction(f);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closure) {
        this.functionsToAdd.add(closure.getTarget().name(this.symbols.next("closure")));
        this.visitExpression(closure);
    }

    @Override
    public void visitFunction(GoloFunction function) {
        function.insertMissingReturnStatement();
        if (!this.expressionToBlock(function)) {
            function.walk(this);
            if (function.hasDecorators() && function.getParentNode().isPresent()) {
                FunctionContainer parent = (FunctionContainer)((Object)function.getParentNode().get());
                GoloFunction decorator = function.createDecorator();
                parent.addFunction(decorator);
                decorator.accept(this);
            }
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        LinkedList<WhenClause<Block>> clauses = new LinkedList<WhenClause<Block>>(caseStatement.getClauses());
        WhenClause lastClause = (WhenClause)clauses.removeLast();
        ConditionalBranching branch = Builders.branch().condition(lastClause.condition()).whenTrue(lastClause.action()).whenFalse(caseStatement.getOtherwise());
        while (!clauses.isEmpty()) {
            lastClause = (WhenClause)clauses.removeLast();
            branch = Builders.branch().condition(lastClause.condition()).whenTrue(lastClause.action()).elseBranch(branch);
        }
        caseStatement.replaceInParentBy(branch);
        branch.accept(this);
    }

    @Override
    public void visitMatchExpression(MatchExpression matchExpression) {
        LocalReference tempVar = Builders.localRef(this.symbols.next("match")).variable().synthetic();
        CaseStatement caseStatement = Builders.cases().ofAST(matchExpression.getASTNode()).otherwise(Builders.block(Builders.assign(matchExpression.getOtherwise()).to(tempVar)));
        for (WhenClause<ExpressionStatement> c : matchExpression.getClauses()) {
            caseStatement.when(c.condition()).then(Builders.block(Builders.assign(c.action()).to(tempVar)));
        }
        Block block = Builders.block();
        for (GoloAssignment a : matchExpression.declarations()) {
            block.add(a);
        }
        matchExpression.clearDeclarations();
        block.add(Builders.define(tempVar).as(Builders.constant(null)));
        block.add(caseStatement);
        block.add(tempVar.lookup());
        matchExpression.replaceInParentBy(block);
        block.accept(this);
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collection) {
        if (!this.expressionToBlock(collection)) {
            collection.walk(this);
            FunctionInvocation construct = Builders.call("gololang.Predefined." + collection.getType().toString()).withArgs(collection.getExpressions().toArray());
            collection.replaceInParentBy(construct);
            ((GoloElement)construct).accept(this);
        }
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        constantStatement.walk(this);
        Object value = constantStatement.getValue();
        if (value instanceof GoloParser.FunctionRef) {
            GoloParser.FunctionRef ref = (GoloParser.FunctionRef)value;
            FunctionInvocation fun = Builders.call("gololang.Predefined.fun").constant().withArgs(Builders.constant(ref.name), Builders.classRef(ref.module == null ? this.module.getPackageAndClass() : ref.module), Builders.constant(ref.arity), Builders.constant(ref.varargs));
            constantStatement.replaceInParentBy(fun);
            ((GoloElement)fun).accept(this);
            return;
        }
    }

    @Override
    public void visitCollectionComprehension(CollectionComprehension collection) {
        CollectionLiteral.Type tempColType = collection.getMutableType();
        LocalReference tempVar = Builders.localRef(this.symbols.next("comprehension")).variable().synthetic();
        Block mainBlock = Builders.block();
        for (GoloAssignment a : collection.declarations()) {
            mainBlock.add(a);
        }
        collection.clearDeclarations();
        mainBlock.add(Builders.define(tempVar).as(Builders.collection(tempColType, new Object[0])));
        Block innerBlock = mainBlock;
        for (Block loop : collection.getLoopBlocks()) {
            innerBlock.addStatement(loop);
            GoloStatement loopStatement = loop.getStatements().get(0);
            innerBlock = ((BlockContainer)((Object)loopStatement)).getBlock();
        }
        innerBlock.addStatement(Builders.invoke("add").withArgs(collection.getExpression()).on(tempVar.lookup()));
        if (collection.getType() == CollectionLiteral.Type.array || collection.getType() == CollectionLiteral.Type.tuple) {
            mainBlock.addStatement(Builders.assign(Builders.invoke("toArray").on(tempVar.lookup())).to(tempVar));
        }
        if (collection.getType() == CollectionLiteral.Type.tuple) {
            mainBlock.addStatement(Builders.assign(Builders.call("Tuple.fromArray").withArgs(tempVar.lookup())).to(tempVar));
        }
        mainBlock.addStatement(tempVar.lookup());
        collection.replaceInParentBy(mainBlock);
        mainBlock.accept(this);
    }

    @Override
    public void visitForEachLoopStatement(ForEachLoopStatement foreachStatement) {
        LocalReference iterVar = Builders.localRef(this.symbols.next("forEachIterator")).variable().synthetic();
        Block loopInnerBlock = foreachStatement.hasWhenClause() ? Builders.block().add(Builders.branch().condition(foreachStatement.getWhenClause()).whenTrue(foreachStatement.getBlock())) : foreachStatement.getBlock();
        if (foreachStatement.isDestructuring()) {
            loopInnerBlock.prependStatement(Builders.destruct().declaring().varargs(foreachStatement.isVarargs()).to(foreachStatement.getReferences()).as(Builders.invoke("next").on(iterVar.lookup())));
        } else {
            loopInnerBlock.prependStatement(Builders.define(foreachStatement.getLocalReference()).as(Builders.invoke("next").on(iterVar.lookup())));
        }
        LoopStatement newLoop = Builders.loop().init(Builders.define(iterVar).as(Builders.invoke("iterator").on(foreachStatement.getIterable()))).condition(Builders.invoke("hasNext").on(iterVar.lookup())).block(loopInnerBlock);
        foreachStatement.replaceInParentBy(newLoop);
        newLoop.accept(this);
    }

    @Override
    public void visitDestructuringAssignment(DestructuringAssignment assignment) {
        LocalReference tmpRef = Builders.localRef(this.symbols.next("destruct")).synthetic();
        Block block = Builders.block().add(Builders.define(tmpRef).as(Builders.invoke("destruct").on(assignment.getExpressionStatement())));
        int last = assignment.getReferencesCount() - 1;
        int idx = 0;
        for (LocalReference ref : assignment.getReferences()) {
            block.add(Builders.assignment().declaring(assignment.isDeclaring()).to(ref).as(Builders.invoke(assignment.isVarargs() && idx == last ? "subTuple" : "get").withArgs(Builders.constant(idx)).on(tmpRef.lookup())));
            ++idx;
        }
        assignment.replaceInParentBy(block);
        block.accept(this);
    }

    @Override
    public void visitStruct(Struct struct) {
        this.module.addFunctions(struct.createFactories());
    }

    @Override
    public void visitBinaryOperation(BinaryOperation op) {
        this.visitExpression(op);
    }

    @Override
    public void visitUnaryOperation(UnaryOperation op) {
        this.visitExpression(op);
    }

    @Override
    public void visitBlock(Block block) {
        this.visitExpression(block);
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup ref) {
        this.visitExpression(ref);
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation fun) {
        this.visitExpression(fun);
    }

    @Override
    public void visitMethodInvocation(MethodInvocation invoke) {
        this.visitExpression(invoke);
    }

    private void visitExpression(ExpressionStatement expr) {
        if (!this.expressionToBlock(expr)) {
            expr.walk(this);
        }
    }

    private boolean expressionToBlock(ExpressionStatement expr) {
        if (!expr.hasLocalDeclarations()) {
            return false;
        }
        Block b = Builders.block(expr.declarations());
        expr.replaceInParentBy(b);
        expr.clearDeclarations();
        LocalReference r = Builders.localRef(this.symbols.next("localdec")).synthetic();
        b.add(Builders.define(r).as(expr));
        b.add(r.lookup());
        b.accept(this);
        return true;
    }
}

