/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import gololang.Messages;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.AbstractInvocation;
import org.eclipse.golo.compiler.ir.Alternatives;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.BinaryOperation;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.CollectionComprehension;
import org.eclipse.golo.compiler.ir.CollectionLiteral;
import org.eclipse.golo.compiler.ir.ConditionalBranching;
import org.eclipse.golo.compiler.ir.ConstantStatement;
import org.eclipse.golo.compiler.ir.Decorator;
import org.eclipse.golo.compiler.ir.DestructuringAssignment;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.ForEachLoopStatement;
import org.eclipse.golo.compiler.ir.FunctionContainer;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.LoopBreakFlowStatement;
import org.eclipse.golo.compiler.ir.LoopStatement;
import org.eclipse.golo.compiler.ir.MethodInvocation;
import org.eclipse.golo.compiler.ir.NamedArgument;
import org.eclipse.golo.compiler.ir.NamedAugmentation;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.Struct;
import org.eclipse.golo.compiler.ir.TryCatchFinally;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.ir.UnionValue;
import org.eclipse.golo.compiler.parser.ASTAdditiveExpression;
import org.eclipse.golo.compiler.parser.ASTAndExpression;
import org.eclipse.golo.compiler.parser.ASTAnonymousFunctionInvocation;
import org.eclipse.golo.compiler.parser.ASTArgument;
import org.eclipse.golo.compiler.parser.ASTAssignment;
import org.eclipse.golo.compiler.parser.ASTAugmentDeclaration;
import org.eclipse.golo.compiler.parser.ASTBlock;
import org.eclipse.golo.compiler.parser.ASTBreak;
import org.eclipse.golo.compiler.parser.ASTCase;
import org.eclipse.golo.compiler.parser.ASTCollectionLiteral;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;
import org.eclipse.golo.compiler.parser.ASTConditionalBranching;
import org.eclipse.golo.compiler.parser.ASTContinue;
import org.eclipse.golo.compiler.parser.ASTDecoratorDeclaration;
import org.eclipse.golo.compiler.parser.ASTDestructuringAssignment;
import org.eclipse.golo.compiler.parser.ASTEqualityExpression;
import org.eclipse.golo.compiler.parser.ASTExpressionStatement;
import org.eclipse.golo.compiler.parser.ASTForEachLoop;
import org.eclipse.golo.compiler.parser.ASTForLoop;
import org.eclipse.golo.compiler.parser.ASTFunction;
import org.eclipse.golo.compiler.parser.ASTFunctionDeclaration;
import org.eclipse.golo.compiler.parser.ASTFunctionInvocation;
import org.eclipse.golo.compiler.parser.ASTImportDeclaration;
import org.eclipse.golo.compiler.parser.ASTInvocationExpression;
import org.eclipse.golo.compiler.parser.ASTLetOrVar;
import org.eclipse.golo.compiler.parser.ASTLiteral;
import org.eclipse.golo.compiler.parser.ASTLocalDeclaration;
import org.eclipse.golo.compiler.parser.ASTMatch;
import org.eclipse.golo.compiler.parser.ASTMemberDeclaration;
import org.eclipse.golo.compiler.parser.ASTMethodInvocation;
import org.eclipse.golo.compiler.parser.ASTModuleDeclaration;
import org.eclipse.golo.compiler.parser.ASTMultiplicativeExpression;
import org.eclipse.golo.compiler.parser.ASTNamedAugmentationDeclaration;
import org.eclipse.golo.compiler.parser.ASTOrExpression;
import org.eclipse.golo.compiler.parser.ASTOrIfNullExpression;
import org.eclipse.golo.compiler.parser.ASTReference;
import org.eclipse.golo.compiler.parser.ASTRelationalExpression;
import org.eclipse.golo.compiler.parser.ASTReturn;
import org.eclipse.golo.compiler.parser.ASTStructDeclaration;
import org.eclipse.golo.compiler.parser.ASTThrow;
import org.eclipse.golo.compiler.parser.ASTToplevelDeclaration;
import org.eclipse.golo.compiler.parser.ASTTryCatchFinally;
import org.eclipse.golo.compiler.parser.ASTUnaryExpression;
import org.eclipse.golo.compiler.parser.ASTUnionDeclaration;
import org.eclipse.golo.compiler.parser.ASTUnionValue;
import org.eclipse.golo.compiler.parser.ASTWhileLoop;
import org.eclipse.golo.compiler.parser.ASTerror;
import org.eclipse.golo.compiler.parser.GoloASTNode;
import org.eclipse.golo.compiler.parser.GoloParserVisitor;
import org.eclipse.golo.compiler.parser.Node;
import org.eclipse.golo.compiler.parser.SimpleNode;
import org.eclipse.golo.runtime.OperatorType;

public class ParseTreeToGoloIrVisitor
implements GoloParserVisitor {
    @Override
    public Object visit(ASTerror node, Object data) {
        return null;
    }

    public GoloModule transform(ASTCompilationUnit compilationUnit, GoloCompilationException.Builder builder) {
        Context context = new Context();
        context.setExceptionBuilder(builder);
        this.visit(compilationUnit, (Object)context);
        return context.module.sourceFile(compilationUnit.getFilename());
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw new IllegalStateException("visit(SimpleNode) shall never be invoked: " + node.getClass());
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTModuleDeclaration node, Object data) {
        Context context = (Context)data;
        context.createModule(node.getName()).ofAST(node);
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        Context context = (Context)data;
        PackageAndClass name = node.isRelative() ? context.module.getPackageAndClass().createSiblingClass(node.getName()) : PackageAndClass.fromString(node.getName());
        if (node.getMultiple().isEmpty()) {
            context.module.addImport(Builders.moduleImport(name).ofAST(node));
        } else {
            for (String sub : node.getMultiple()) {
                context.module.addImport(Builders.moduleImport(name.createSubPackage(sub)).ofAST(node));
            }
        }
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTToplevelDeclaration node, Object data) {
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTMemberDeclaration node, Object data) {
        Context context = (Context)data;
        context.push(Builders.member(node.getName()).ofAST(node));
        return context;
    }

    @Override
    public Object visit(ASTStructDeclaration node, Object data) {
        Context context = (Context)data;
        if (!context.checkExistingSubtype(node, node.getName())) {
            Struct theStruct = Builders.structure(node.getName()).ofAST(node);
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, context);
                theStruct.withMember(context.pop());
            }
            context.module.addStruct(theStruct);
        }
        return context;
    }

    @Override
    public Object visit(ASTUnionDeclaration node, Object data) {
        Context context = (Context)data;
        if (!context.checkExistingSubtype(node, node.getName())) {
            context.push(Builders.union(node.getName()).ofAST(node));
            node.childrenAccept(this, data);
            context.module.addUnion((Union)context.pop());
        }
        return data;
    }

    @Override
    public Object visit(ASTUnionValue node, Object data) {
        Context context = (Context)data;
        Union currentUnion = (Union)context.peek();
        UnionValue value = currentUnion.createValue(node.getName()).ofAST(node);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            value.withMember(context.pop());
        }
        if (!currentUnion.addValue(value)) {
            context.errorMessage(GoloCompilationException.Problem.Type.AMBIGUOUS_DECLARATION, node, Messages.message("ambiguous_unionvalue_declaration", node.getName()));
        }
        return data;
    }

    @Override
    public Object visit(ASTAugmentDeclaration node, Object data) {
        Context context = (Context)data;
        context.enterAugmentation(node);
        node.childrenAccept(this, data);
        context.leaveAugmentation();
        return data;
    }

    @Override
    public Object visit(ASTDecoratorDeclaration node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(Builders.decorator(context.pop()).constant(node.isConstant()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTNamedAugmentationDeclaration node, Object data) {
        Context context = (Context)data;
        context.enterNamedAugmentation(node);
        node.childrenAccept(this, data);
        context.leaveNamedAugmentation();
        return data;
    }

    @Override
    public Object visit(ASTFunctionDeclaration node, Object data) {
        Context context = (Context)data;
        GoloFunction function = Builders.functionDeclaration().ofAST(node).name(node.getName()).local(node.isLocal()).inAugment(node.isAugmentation()).decorator(node.isDecorator());
        while (context.peek() instanceof Decorator) {
            function.decoratedWith(context.pop());
        }
        context.push(function);
        node.childrenAccept(this, data);
        context.pop();
        return data;
    }

    @Override
    public Object visit(ASTContinue node, Object data) {
        Context context = (Context)data;
        LoopBreakFlowStatement statement = LoopBreakFlowStatement.newContinue();
        node.setIrElement(statement);
        context.push(statement);
        return data;
    }

    @Override
    public Object visit(ASTBreak node, Object data) {
        Context context = (Context)data;
        LoopBreakFlowStatement statement = LoopBreakFlowStatement.newBreak();
        node.setIrElement(statement);
        context.push(statement);
        return data;
    }

    @Override
    public Object visit(ASTFunction node, Object data) {
        Context context = (Context)data;
        GoloFunction function = context.getOrCreateFunction().ofAST(node).varargs(node.isVarargs()).withParameters(node.getParameters());
        if (node.isCompactForm()) {
            Node astChild = node.jjtGetChild(0);
            ASTReturn astReturn = new ASTReturn(0);
            astReturn.jjtAddChild(astChild, 0);
            ASTBlock astBlock = new ASTBlock(0);
            astBlock.jjtAddChild(astReturn, 0);
            astBlock.jjtAccept(this, data);
        } else {
            node.childrenAccept(this, data);
        }
        if (function.isSynthetic()) {
            context.pop();
            context.push(function.asClosureReference());
        } else {
            context.addFunction(function);
            context.pop();
        }
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(Builders.not((ExpressionStatement)context.pop()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        Context context = (Context)data;
        ConstantStatement constantStatement = Builders.constant(node.getLiteralValue());
        context.push(constantStatement);
        node.setIrElement(constantStatement);
        return data;
    }

    @Override
    public Object visit(ASTCollectionLiteral node, Object data) {
        if (node.isComprehension()) {
            return this.createCollectionComprehension(node, (Context)data);
        }
        return this.createCollectionLiteral(node, (Context)data);
    }

    private Object createCollectionLiteral(ASTCollectionLiteral node, Context context) {
        CollectionLiteral collection = Builders.collection(node.getType(), new Object[0]).ofAST(node);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            collection.add(context.pop());
        }
        context.push(collection);
        return context;
    }

    private Object createCollectionComprehension(ASTCollectionLiteral node, Context context) {
        CollectionComprehension col = Builders.collectionComprehension(node.getType()).ofAST(node);
        node.jjtGetChild(0).jjtAccept(this, context);
        col.expression(context.pop());
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, context);
            col.loop(context.pop());
        }
        context.push(col);
        return context;
    }

    @Override
    public Object visit(ASTReference node, Object data) {
        ((Context)data).push(Builders.refLookup(node.getName()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTLetOrVar node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        AssignmentStatement assignmentStatement = Builders.define(context.getOrCreateReference(node)).as(context.pop()).ofAST(node);
        if (node.isModuleState()) {
            context.module.addModuleStateInitializer(assignmentStatement);
        } else {
            context.push(assignmentStatement);
        }
        return data;
    }

    @Override
    public Object visit(ASTAssignment node, Object data) {
        Context context = (Context)data;
        LocalReference reference = context.getReference(node.getName(), node);
        node.childrenAccept(this, data);
        if (reference == null) {
            context.errorMessage(GoloCompilationException.Problem.Type.UNDECLARED_REFERENCE, node, Messages.message("undeclared_reference_assignment", node.getName()));
        } else {
            AssignmentStatement assignmentStatement = Builders.assign(context.pop()).to(reference).ofAST(node);
            context.push(assignmentStatement);
        }
        return data;
    }

    @Override
    public Object visit(ASTDestructuringAssignment node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(0).jjtAccept(this, data);
        DestructuringAssignment builder = Builders.destruct().ofAST(node).declaring(node.getType() != null).varargs(node.isVarargs()).as(context.pop());
        for (String name : node.getNames()) {
            LocalReference val = context.getOrCreateReference(node, name);
            if (val == null) continue;
            builder.to(val);
        }
        context.push(builder);
        return data;
    }

    @Override
    public Object visit(ASTReturn node, Object data) {
        Context context = (Context)data;
        if (node.jjtGetNumChildren() > 0) {
            node.childrenAccept(this, data);
        } else {
            context.push(Builders.constant(null));
        }
        context.push(Builders.returns(context.pop()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTArgument node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(node.isNamed() ? Builders.namedArgument(node.getName()).value(context.pop()) : (ExpressionStatement)context.pop());
        return data;
    }

    @Override
    public Object visit(ASTThrow node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        context.push(Builders.raise(context.pop()).ofAST(node));
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        Context context = (Context)data;
        Block block = context.enterScope();
        node.setIrElement(block);
        if (context.peek() instanceof GoloFunction) {
            GoloFunction function = (GoloFunction)context.peek();
            function.block(block);
            if (function.isSynthetic()) {
                context.pop();
            }
        }
        context.push(block);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            GoloASTNode child = (GoloASTNode)node.jjtGetChild(i);
            child.jjtAccept(this, data);
            GoloStatement statement = (GoloStatement)context.pop();
            block.addStatement(statement);
        }
        context.leaveScope();
        return data;
    }

    @Override
    public Object visit(ASTFunctionInvocation node, Object data) {
        Context context = (Context)data;
        context.push(this.visitAbstractInvocation(data, node, Builders.call(node.getName()).constant(node.isConstant())));
        return data;
    }

    @Override
    public Object visit(ASTMethodInvocation node, Object data) {
        Context context = (Context)data;
        context.push(this.visitAbstractInvocation(data, node, Builders.invoke(node.getName())));
        return data;
    }

    @Override
    public Object visit(ASTAnonymousFunctionInvocation node, Object data) {
        Context context = (Context)data;
        ExpressionStatement result = this.visitAbstractInvocation(data, node, Builders.functionInvocation().constant(node.isConstant()));
        if (node.isOnExpression()) {
            context.push(Builders.anonCall(context.pop(), result));
        } else {
            context.push(result);
        }
        return data;
    }

    private void checkNamedArgument(Context context, GoloASTNode node, AbstractInvocation invocation, ExpressionStatement statement) {
        if (statement instanceof NamedArgument) {
            if (!invocation.namedArgumentsComplete()) {
                context.errorMessage(GoloCompilationException.Problem.Type.INCOMPLETE_NAMED_ARGUMENTS_USAGE, node, Messages.message("incomplete_named_arguments_usage", invocation.getClass(), invocation.getName()));
            }
            invocation.withNamedArguments();
        }
    }

    private ExpressionStatement visitAbstractInvocation(Object data, GoloASTNode node, AbstractInvocation invocation) {
        GoloASTNode argumentNode;
        Context context = (Context)data;
        invocation.ofAST(node);
        int i = 0;
        int numChildren = node.jjtGetNumChildren();
        for (i = 0; i < numChildren && !((argumentNode = (GoloASTNode)node.jjtGetChild(i)) instanceof ASTAnonymousFunctionInvocation); ++i) {
            argumentNode.jjtAccept(this, context);
            ExpressionStatement statement = (ExpressionStatement)context.pop();
            this.checkNamedArgument(context, node, invocation, statement);
            invocation.withArgs(statement);
        }
        ExpressionStatement result = invocation;
        if (i < numChildren) {
            while (i < numChildren) {
                node.jjtGetChild(i).jjtAccept(this, context);
                result = Builders.anonCall(result, context.pop());
                ++i;
            }
        }
        return result;
    }

    @Override
    public Object visit(ASTConditionalBranching node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(1).jjtAccept(this, data);
        node.jjtGetChild(0).jjtAccept(this, data);
        ConditionalBranching conditionalBranching = Builders.branch().ofAST(node).condition(context.pop()).whenTrue(context.pop());
        if (node.jjtGetNumChildren() > 2) {
            node.jjtGetChild(2).jjtAccept(this, data);
            conditionalBranching.otherwise(context.pop());
        }
        context.push(conditionalBranching);
        return data;
    }

    private Object visitAlternatives(Object data, GoloASTNode node, Alternatives<?> alternatives) {
        Context context = (Context)data;
        int lastWhen = node.jjtGetNumChildren() - 1;
        for (int i = 0; i < lastWhen; i += 2) {
            node.jjtGetChild(i).jjtAccept(this, data);
            alternatives.when(context.pop());
            node.jjtGetChild(i + 1).jjtAccept(this, data);
            alternatives.then(context.pop());
        }
        node.jjtGetChild(lastWhen).jjtAccept(this, data);
        alternatives.otherwise(context.pop());
        context.push(alternatives);
        return data;
    }

    @Override
    public Object visit(ASTCase node, Object data) {
        return this.visitAlternatives(data, node, Builders.cases().ofAST(node));
    }

    @Override
    public Object visit(ASTMatch node, Object data) {
        return this.visitAlternatives(data, node, Builders.match().ofAST(node));
    }

    @Override
    public Object visit(ASTWhileLoop node, Object data) {
        Context context = (Context)data;
        node.jjtGetChild(1).jjtAccept(this, data);
        node.jjtGetChild(0).jjtAccept(this, data);
        context.push(Builders.whileLoop(context.pop()).ofAST(node).block((Block)context.pop()));
        return data;
    }

    @Override
    public Object visit(ASTForLoop node, Object data) {
        Context context = (Context)data;
        Block block = context.enterScope();
        node.jjtGetChild(0).jjtAccept(this, data);
        node.jjtGetChild(1).jjtAccept(this, data);
        node.jjtGetChild(2).jjtAccept(this, data);
        LoopStatement loopStatement = Builders.loop().ofAST(node).post(context.pop()).condition(context.pop()).init(context.pop());
        if (node.jjtGetNumChildren() == 4) {
            node.jjtGetChild(3).jjtAccept(this, data);
            loopStatement.block((Block)context.pop());
        }
        context.push(block.add(loopStatement));
        context.leaveScope();
        return data;
    }

    @Override
    public Object visit(ASTForEachLoop node, Object data) {
        Context context = (Context)data;
        Block block = context.enterScope();
        node.jjtGetChild(0).jjtAccept(this, data);
        ForEachLoopStatement foreach = Builders.foreach().ofAST(node).varargs(node.isVarargs()).on(context.pop());
        if (node.getElementIdentifier() != null) {
            foreach.var(node.getElementIdentifier());
        } else {
            for (String name : node.getNames()) {
                foreach.var(name);
            }
        }
        int numChildren = node.jjtGetNumChildren();
        if (numChildren > 2) {
            node.jjtGetChild(2).jjtAccept(this, data);
            node.jjtGetChild(1).jjtAccept(this, data);
            foreach.when(context.pop()).block(context.pop());
        } else if (numChildren == 2) {
            node.jjtGetChild(1).jjtAccept(this, data);
            Object child = context.pop();
            if (child instanceof Block) {
                foreach.block(child);
            } else if (child instanceof ExpressionStatement) {
                foreach.when(child);
            } else {
                context.errorMessage(GoloCompilationException.Problem.Type.PARSING, node, Messages.message("syntax_foreach"));
            }
        }
        context.push(block.add(foreach));
        context.leaveScope();
        return data;
    }

    @Override
    public Object visit(ASTTryCatchFinally node, Object data) {
        Context context = (Context)data;
        boolean hasCatchBlock = node.getExceptionId() != null;
        TryCatchFinally tryCatchFinally = Builders.tryCatch(node.getExceptionId()).ofAST(node);
        context.enterScope();
        node.jjtGetChild(0).jjtAccept(this, data);
        tryCatchFinally.trying(context.pop());
        context.leaveScope();
        context.enterScope();
        node.jjtGetChild(1).jjtAccept(this, data);
        if (hasCatchBlock) {
            tryCatchFinally.catching(context.pop());
        } else {
            tryCatchFinally.finalizing(context.pop());
        }
        context.leaveScope();
        if (hasCatchBlock && node.jjtGetNumChildren() > 2) {
            context.enterScope();
            node.jjtGetChild(2).jjtAccept(this, data);
            tryCatchFinally.finalizing(context.pop());
            context.leaveScope();
        }
        context.push(tryCatchFinally);
        return data;
    }

    @Override
    public Object visit(ASTExpressionStatement node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTInvocationExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        BinaryOperation current = null;
        ExpressionStatement right = null;
        List<String> operators = node.getOperators();
        Collections.reverse(operators);
        for (String symbol : operators) {
            OperatorType operator = OperatorType.fromString(symbol);
            if (right == null) {
                right = (ExpressionStatement)context.pop();
                if (operator == OperatorType.ELVIS_METHOD_CALL) {
                    ((MethodInvocation)right).setNullSafeGuarded(true);
                }
            } else if (operator == OperatorType.ELVIS_METHOD_CALL) {
                BinaryOperation rOp = (BinaryOperation)right;
                ((MethodInvocation)rOp.getLeftExpression()).setNullSafeGuarded(true);
            }
            ExpressionStatement left = (ExpressionStatement)context.pop();
            current = Builders.binaryOperation(operator, left, right);
            right = current;
        }
        context.push(current);
        node.setIrElement(current);
        return data;
    }

    private BinaryOperation assembleBinaryOperation(List<ExpressionStatement> statements, List<OperatorType> operators) {
        BinaryOperation current = null;
        int i = 2;
        for (OperatorType operator : operators) {
            if (current == null) {
                current = Builders.binaryOperation(operator, statements.get(0), statements.get(1));
                continue;
            }
            current = Builders.binaryOperation(operator, current, statements.get(i));
            ++i;
        }
        return current;
    }

    private List<ExpressionStatement> operatorStatements(Context context, int operatorsCount) {
        LinkedList<ExpressionStatement> statements = new LinkedList<ExpressionStatement>();
        for (int i = 0; i < operatorsCount + 1; ++i) {
            statements.addFirst((ExpressionStatement)context.pop());
        }
        return statements;
    }

    @Override
    public Object visit(ASTMultiplicativeExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<OperatorType> operators = node.getOperators().stream().map(OperatorType::fromString).collect(Collectors.toList());
        List<ExpressionStatement> statements = this.operatorStatements(context, operators.size());
        BinaryOperation operation = this.assembleBinaryOperation(statements, operators);
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTAdditiveExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<OperatorType> operators = node.getOperators().stream().map(OperatorType::fromString).collect(Collectors.toList());
        List<ExpressionStatement> statements = this.operatorStatements(context, operators.size());
        BinaryOperation operation = this.assembleBinaryOperation(statements, operators);
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTRelationalExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        BinaryOperation operation = Builders.binaryOperation(node.getOperator()).right(context.pop()).left(context.pop());
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTEqualityExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, data);
        BinaryOperation operation = Builders.binaryOperation(node.getOperator()).right(context.pop()).left(context.pop());
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTAndExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<ExpressionStatement> statements = this.operatorStatements(context, node.count());
        BinaryOperation operation = this.assembleBinaryOperation(statements, Collections.nCopies(node.count(), OperatorType.AND));
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTOrExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<ExpressionStatement> statements = this.operatorStatements(context, node.count());
        BinaryOperation operation = this.assembleBinaryOperation(statements, Collections.nCopies(node.count(), OperatorType.OR));
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTOrIfNullExpression node, Object data) {
        Context context = (Context)data;
        node.childrenAccept(this, context);
        List<ExpressionStatement> statements = this.operatorStatements(context, node.count());
        BinaryOperation operation = this.assembleBinaryOperation(statements, Collections.nCopies(node.count(), OperatorType.ORIFNULL));
        context.push(operation);
        node.setIrElement(operation);
        return data;
    }

    @Override
    public Object visit(ASTLocalDeclaration node, Object data) {
        Context context = (Context)data;
        ExpressionStatement expr = (ExpressionStatement)context.peek();
        boolean oldState = context.inLocalDeclaration;
        context.inLocalDeclaration = true;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
            try {
                expr.with(context.pop());
                continue;
            }
            catch (UnsupportedOperationException ex) {
                context.errorMessage(GoloCompilationException.Problem.Type.PARSING, node, ex.getMessage());
            }
        }
        context.inLocalDeclaration = oldState;
        return data;
    }

    private static final class Context {
        public GoloModule module;
        private Deque<FunctionContainer> functionContainersStack = new LinkedList<FunctionContainer>();
        private Deque<Object> objectStack = new LinkedList<Object>();
        private Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();
        public boolean inLocalDeclaration = false;
        private GoloCompilationException.Builder exceptionBuilder;

        private Context() {
        }

        public void push(Object object) {
            this.objectStack.push(object);
        }

        public Object peek() {
            return this.objectStack.peek();
        }

        public Object pop() {
            return this.objectStack.pop();
        }

        public Block enterScope() {
            ReferenceTable blockReferenceTable = this.referenceTableStack.peek().fork();
            this.referenceTableStack.push(blockReferenceTable);
            return Builders.block().ref(blockReferenceTable);
        }

        public void leaveScope() {
            this.referenceTableStack.pop();
        }

        public GoloModule createModule(String name) {
            ReferenceTable global = new ReferenceTable();
            this.referenceTableStack.push(global);
            this.module = new GoloModule(PackageAndClass.fromString(name), global);
            this.functionContainersStack.push(this.module);
            return this.module;
        }

        public void enterAugmentation(ASTAugmentDeclaration node) {
            this.functionContainersStack.push(this.module.addAugmentation(Builders.augment(node.getTarget()).with(node.getAugmentationNames()).ofAST(node)));
        }

        public void leaveAugmentation() {
            this.functionContainersStack.pop();
        }

        public void enterNamedAugmentation(ASTNamedAugmentationDeclaration node) {
            NamedAugmentation namedAugmentation = Builders.augmentation(node.getName()).ofAST(node);
            this.functionContainersStack.push(namedAugmentation);
            this.module.addNamedAugmentation(namedAugmentation);
        }

        public void leaveNamedAugmentation() {
            this.functionContainersStack.pop();
        }

        public void addFunction(GoloFunction function) {
            FunctionContainer container = this.functionContainersStack.peek();
            if (container.getFunctions().contains(function)) {
                GoloFunction firstDeclaration = null;
                for (GoloFunction f : container.getFunctions()) {
                    if (!function.equals(f)) continue;
                    firstDeclaration = f;
                }
                this.errorMessage(GoloCompilationException.Problem.Type.AMBIGUOUS_DECLARATION, function.getASTNode(), Messages.message("ambiguous_function_declaration", function.getName(), firstDeclaration == null ? "unknown" : firstDeclaration.getASTNode().getPositionInSourceCode()));
            }
            container.addFunction(function);
        }

        public boolean checkExistingSubtype(GoloASTNode node, String name) {
            GoloElement existing = this.module.getSubtypeByName(name);
            if (existing != null) {
                this.errorMessage(GoloCompilationException.Problem.Type.AMBIGUOUS_DECLARATION, node, Messages.message("ambiguous_type_declaration", name, existing.getASTNode().getPositionInSourceCode()));
                return true;
            }
            return false;
        }

        public GoloFunction getOrCreateFunction() {
            if (!(this.objectStack.peek() instanceof GoloFunction)) {
                this.objectStack.push(Builders.functionDeclaration().synthetic().local().asClosure());
            }
            return (GoloFunction)this.objectStack.peek();
        }

        private LocalReference.Kind referenceKindOf(ASTLetOrVar.Type type, boolean moduleState) {
            if (moduleState) {
                return type == ASTLetOrVar.Type.LET ? LocalReference.Kind.MODULE_CONSTANT : LocalReference.Kind.MODULE_VARIABLE;
            }
            return type == ASTLetOrVar.Type.LET ? LocalReference.Kind.CONSTANT : LocalReference.Kind.VARIABLE;
        }

        public LocalReference getOrCreateReference(ASTLetOrVar node) {
            return this.getOrCreateReference(node.getType(), node.getName(), node.isModuleState(), node);
        }

        public LocalReference getOrCreateReference(ASTDestructuringAssignment node, String name) {
            return this.getOrCreateReference(node.getType(), name, false, node);
        }

        public LocalReference getReference(String name, GoloASTNode node) {
            if (this.inLocalDeclaration) {
                return this.getOrCreateReference(ASTLetOrVar.Type.LET, name, false, node);
            }
            return this.referenceTableStack.peek().get(name);
        }

        private LocalReference getOrCreateReference(ASTLetOrVar.Type type, String name, boolean module, GoloASTNode node) {
            if (type != null) {
                LocalReference val = Builders.localRef(name).kind(this.referenceKindOf(type, module)).ofAST(node);
                if (!this.inLocalDeclaration) {
                    this.referenceTableStack.peek().add(val);
                }
                return val;
            }
            return this.getReference(name, node);
        }

        public void setExceptionBuilder(GoloCompilationException.Builder builder) {
            this.exceptionBuilder = builder;
        }

        private GoloCompilationException.Builder getOrCreateExceptionBuilder() {
            if (this.exceptionBuilder == null) {
                this.exceptionBuilder = new GoloCompilationException.Builder(this.module.getPackageAndClass().toString());
            }
            return this.exceptionBuilder;
        }

        public void errorMessage(GoloCompilationException.Problem.Type type, GoloASTNode node, String message) {
            String errorMessage = message + ' ' + Messages.message("source_position", node.getPositionInSourceCode().getLine(), node.getPositionInSourceCode().getColumn());
            this.getOrCreateExceptionBuilder().report(type, node, errorMessage);
        }
    }
}

