/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import gololang.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.golo.cli.command.ClasspathOption;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloClassLoader;
import org.eclipse.golo.compiler.GoloCompilationException;

@Parameters(commandNames={"shebang"}, resourceBundle="commands", commandDescriptionKey="golo")
public class ShebangCommand
implements CliCommand {
    @Parameter(descriptionKey="arguments", required=true)
    List<String> arguments = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        Path script = Paths.get(this.arguments.get(0), new String[0]);
        while (Files.isSymbolicLink(script)) {
            script = Files.readSymbolicLink(script);
        }
        Path basedir = ShebangCommand.dirName(script);
        GoloClassLoader loader = ClasspathOption.initGoloClassLoader(this.classpath(basedir));
        try {
            this.loadOtherGoloFiles(loader, basedir, script);
            this.callRun(this.loadGoloFile(loader, script), this.arguments.toArray(new String[this.arguments.size()]));
        }
        catch (GoloCompilationException e) {
            this.handleCompilationException(e);
        }
    }

    private static Path dirName(Path file) {
        if (!file.isAbsolute()) {
            return file.toAbsolutePath().getParent();
        }
        return file.getParent();
    }

    private static boolean sameFile(Path path1, Path path2) {
        return path1.toAbsolutePath().compareTo(path2.toAbsolutePath()) == 0;
    }

    private List<String> classpath(Path basedir) throws IOException {
        PathMatcher jarFiles = FileSystems.getDefault().getPathMatcher("glob:**/*.jar");
        return Files.walk(basedir, new FileVisitOption[0]).filter(path -> jarFiles.matches((Path)path)).map(path -> path.toAbsolutePath().toString()).collect(Collectors.toList());
    }

    private void loadOtherGoloFiles(GoloClassLoader loader, Path basedir, Path script) throws IOException {
        PathMatcher goloFiles = FileSystems.getDefault().getPathMatcher("glob:**/*.golo");
        Files.walk(basedir, new FileVisitOption[0]).filter(path -> goloFiles.matches((Path)path) && !ShebangCommand.sameFile(path, script)).forEach(path -> this.loadGoloFile(loader, (Path)path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> loadGoloFile(GoloClassLoader loader, Path path) {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            Path filename = path.getFileName();
            if (filename != null) {
                Class<?> clazz = loader.load(filename.toString(), is);
                return clazz;
            }
            throw new RuntimeException(Messages.message("not_regular_file", path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

