/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import gololang.Messages;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.golo.cli.command.Profile;
import org.eclipse.golo.cli.command.ProjectInitializer;
import org.eclipse.golo.cli.command.VCS;
import org.eclipse.golo.cli.command.spi.CliCommand;

@Parameters(commandNames={"new"}, resourceBundle="commands", commandDescriptionKey="new")
public class InitCommand
implements CliCommand {
    @Parameter(names={"--path"}, descriptionKey="new.path")
    String path = ".";
    @Parameter(names={"--type"}, descriptionKey="new.type", validateWith=ProjectTypeValidator.class)
    String type = System.getProperty("golo.new.type", "simple");
    @Parameter(names={"--vcs"}, descriptionKey="new.vcs", validateWith=VcsValidator.class)
    String vcs = System.getProperty("golo.new.vcs", "none");
    @Parameter(names={"--profile"}, descriptionKey="new.profile", validateWith=ProfileValidator.class)
    String profile = System.getProperty("golo.new.profile", "app");
    @Parameter(descriptionKey="new.names")
    List<String> names = new LinkedList<String>();
    private static final Map<String, Profile> PROFILES = new LinkedHashMap<String, Profile>();
    private static final Map<String, VCS> VERSION_SYSTEMS;
    private static final Map<String, Supplier<ProjectInitializer>> TYPES;

    @Override
    public void execute() throws Throwable {
        if (this.names.isEmpty()) {
            this.names.add("Golo");
        }
        ProjectInitializer init = TYPES.get(this.type).get();
        init.setRootPath(this.path);
        init.setVCS(VERSION_SYSTEMS.get(this.vcs));
        init.setProfile(PROFILES.get(this.profile));
        for (String name : this.names) {
            try {
                Messages.info(Messages.message("project_generation", this.type, name));
                init.init(name);
            }
            catch (Exception e) {
                this.handleThrowable(e, false, false);
            }
        }
    }

    static {
        PROFILES.put("app", new Profile().defaultFileName("main.golo").label("application").runnable());
        PROFILES.put("lib", new Profile().defaultFileName("lib.golo").label("library").directories(Paths.get("samples", new String[0])));
        VERSION_SYSTEMS = new LinkedHashMap<String, VCS>();
        VERSION_SYSTEMS.put("none", null);
        VERSION_SYSTEMS.put("git", new VCS().command("git", "init").ignoreFilename(".gitignore").ignore("*.class"));
        VERSION_SYSTEMS.put("hg", new VCS().command("hg", "init").ignoreFilename(".hgignore").ignore("syntax: glob", "*.class"));
        TYPES = new LinkedHashMap<String, Supplier<ProjectInitializer>>();
        TYPES.put("simple", () -> new ProjectInitializer().directories(Paths.get("imports", new String[0]), Paths.get("jars", new String[0])).runCommand("golo golo --files *.golo"));
        TYPES.put("gradle", () -> new ProjectInitializer().manager("gradle").projectFileName("build.gradle").sourcesDir(Paths.get("src", "main", "golo")).directories(Paths.get("src", "main", "resources"), Paths.get("src", "test", "golo")).withFile(Paths.get("README.md", new String[0]), "README.md").ignore("build/", ".gradle/").runCommand("gradle -q run"));
        TYPES.put("maven", () -> new ProjectInitializer().manager("maven").projectFileName("pom.xml").sourcesDir(Paths.get("src", "main", "golo")).directories(Paths.get("src", "main", "resources"), Paths.get("src", "test", "golo")).withFile(Paths.get("README.md", new String[0]), "README.md").ignore("target/").runCommand("mvn -q package && mvn -q exec:java"));
    }

    public static class ProfileValidator
    implements IParameterValidator {
        public static final String DEFAULT = "app";

        public void validate(String name, String value) {
            if (!PROFILES.containsKey(value)) {
                throw new ParameterException(Messages.message("profile_type_error", PROFILES.keySet().toString()));
            }
        }
    }

    public static class VcsValidator
    implements IParameterValidator {
        public static final String DEFAULT = "none";

        public void validate(String name, String value) {
            if (!VERSION_SYSTEMS.containsKey(value)) {
                throw new ParameterException(Messages.message("vcs_type_error", VERSION_SYSTEMS.keySet().toString()));
            }
        }
    }

    public static class ProjectTypeValidator
    implements IParameterValidator {
        public static final String DEFAULT = "simple";

        public void validate(String name, String value) {
            if (!TYPES.containsKey(value)) {
                throw new ParameterException(Messages.message("project_type_error", TYPES.keySet().toString()));
            }
        }
    }
}

