/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Messages;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.eclipse.golo.runtime.Module;
import org.eclipse.golo.runtime.Warnings;

public final class ClassReferenceSupport {
    private ClassReferenceSupport() {
        throw new UnsupportedOperationException("Don't instantiate invokedynamic bootstrap class");
    }

    public static CallSite bootstrap(MethodHandles.Lookup caller, String name, MethodType type) throws ClassNotFoundException {
        String className = name.replaceAll("#", "\\.");
        Class<?> callerClass = caller.lookupClass();
        ClassLoader classLoader = callerClass.getClassLoader();
        Class<?> classRef = ClassReferenceSupport.tryLoadingFromPrimitiveType(className);
        if (classRef != null) {
            return ClassReferenceSupport.createCallSite(classRef);
        }
        classRef = ClassReferenceSupport.tryLoadingFromName(className, classLoader, callerClass.getName());
        if (classRef != null) {
            return ClassReferenceSupport.createCallSite(classRef);
        }
        classRef = ClassReferenceSupport.tryLoadingFromImports(className, callerClass, classLoader);
        if (classRef != null) {
            return ClassReferenceSupport.createCallSite(classRef);
        }
        throw new ClassNotFoundException(Messages.message("class_not_resolved", className));
    }

    private static Class<?> tryLoadingFromName(String name, ClassLoader classLoader, String callerName) {
        try {
            return Class.forName(name, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            Warnings.unavailableClass(name, callerName);
            return null;
        }
    }

    private static Class<?> tryLoadingFromImports(String className, Class<?> callerClass, ClassLoader classLoader) {
        for (String importedClassName : Module.imports(callerClass)) {
            Class<?> classRef = ClassReferenceSupport.tryLoadingFromName(importedClassName + "." + className, classLoader, callerClass.getName());
            if (classRef != null) {
                return classRef;
            }
            if (!importedClassName.endsWith(className) || (classRef = ClassReferenceSupport.tryLoadingFromName(importedClassName, classLoader, callerClass.getName())) == null) continue;
            return classRef;
        }
        return null;
    }

    private static Class<?> tryLoadingFromPrimitiveType(String name) {
        switch (name) {
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    private static CallSite createCallSite(Class<?> classRef) {
        return new ConstantCallSite(MethodHandles.constant(Class.class, classRef));
    }
}

