/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.TypeWithMembers;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class UnionValue
extends TypeWithMembers {
    UnionValue(Union union, String name) {
        super(name);
        this.setParentNode(union);
    }

    @Override
    public UnionValue ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    @Override
    public PackageAndClass getPackageAndClass() {
        return this.getUnion().getPackageAndClass().createInnerClass(this.getName());
    }

    public Union getUnion() {
        return (Union)this.getParentNode().get();
    }

    @Override
    protected String getFactoryDelegateName() {
        return this.getUnion().getPackageAndClass().toString() + "." + this.getName();
    }

    @Override
    protected void setParentNode(GoloElement parent) {
        if (!(parent instanceof Union)) {
            throw new IllegalArgumentException("UnionValue can only be defined in a Union");
        }
        super.setParentNode(parent);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnionValue(this);
    }
}

