/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Objects;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.Scope;

public final class ReturnStatement
extends GoloStatement
implements Scope {
    private GoloStatement expressionStatement;
    private boolean returningVoid;
    private boolean synthetic;

    ReturnStatement(ExpressionStatement expression) {
        this.setExpressionStatement(expression);
        this.returningVoid = false;
        this.synthetic = false;
    }

    public GoloStatement getExpressionStatement() {
        return this.expressionStatement;
    }

    private void setExpressionStatement(GoloStatement stat) {
        this.expressionStatement = stat;
        this.makeParentOf(stat);
    }

    public boolean isReturningVoid() {
        return this.returningVoid;
    }

    public void returningVoid() {
        this.returningVoid = true;
    }

    public ReturnStatement synthetic() {
        this.synthetic = true;
        return this;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public String toString() {
        return "return " + (this.returningVoid || this.expressionStatement == null ? "" : this.expressionStatement.toString());
    }

    @Override
    public void relink(ReferenceTable table) {
        if (this.expressionStatement instanceof Scope) {
            ((Scope)((Object)this.expressionStatement)).relink(table);
        }
    }

    @Override
    public void relinkTopLevel(ReferenceTable table) {
        if (this.expressionStatement instanceof Scope) {
            ((Scope)((Object)this.expressionStatement)).relinkTopLevel(table);
        }
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitReturnStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expressionStatement.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!Objects.equals(original, this.expressionStatement) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement((ExpressionStatement)newElement);
    }
}

