/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import gololang.Messages;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.golo.cli.command.spi.CliCommand;

public final class Main {
    private Main() {
    }

    public static void main(String ... args) throws Throwable {
        block6: {
            GlobalArguments global = new GlobalArguments();
            JCommander cmd = new JCommander((Object)global);
            cmd.setProgramName("golo");
            ServiceLoader<CliCommand> commands = ServiceLoader.load(CliCommand.class);
            for (CliCommand command : commands) {
                cmd.addCommand((Object)command);
            }
            UsageFormatValidator.commandNames = cmd.getCommands().keySet();
            try {
                cmd.parse(args);
                if (global.usageCommand != null) {
                    cmd.usage(global.usageCommand);
                    break block6;
                }
                if (global.help || cmd.getParsedCommand() == null) {
                    cmd.usage();
                    break block6;
                }
                String parsedCommand = cmd.getParsedCommand();
                JCommander parsedJCommander = (JCommander)cmd.getCommands().get(parsedCommand);
                Object commandObject = parsedJCommander.getObjects().get(0);
                if (commandObject instanceof CliCommand) {
                    ((CliCommand)commandObject).execute();
                    break block6;
                }
                throw new AssertionError((Object)"WTF?");
            }
            catch (ParameterException exception) {
                System.err.println(exception.getMessage());
                System.out.println();
                if (cmd.getParsedCommand() == null) break block6;
                cmd.usage(cmd.getParsedCommand());
            }
        }
    }

    public static class UsageFormatValidator
    implements IParameterValidator {
        static Set<String> commandNames;

        public void validate(String name, String value) throws ParameterException {
            if (!commandNames.contains(value)) {
                throw new ParameterException(Messages.message("command_error", commandNames));
            }
        }
    }

    @Parameters(resourceBundle="commands")
    static class GlobalArguments {
        @Parameter(names={"--help"}, descriptionKey="help", help=true)
        boolean help;
        @Parameter(names={"--usage"}, descriptionKey="usage", validateWith=UsageFormatValidator.class)
        String usageCommand;

        GlobalArguments() {
        }
    }
}

