/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark.cmd;

import com.github.rjeschke.txtmark.cmd.CmdArgument;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

final class CmdLineParser {
    static final HashMap<Class<?>, Type> TYPE_MAP = new HashMap();
    static final Class<?>[] TYPE_CLASS_LIST = Colls.objArray(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, List.class, Boolean.class, Boolean.TYPE);
    static final Type[] TYPE_TYPE_LIST = Colls.objArray(Type.STRING, Type.BYTE, Type.BYTE, Type.SHORT, Type.SHORT, Type.INT, Type.INT, Type.LONG, Type.LONG, Type.FLOAT, Type.FLOAT, Type.DOUBLE, Type.DOUBLE, Type.LIST, Type.BOOL, Type.BOOL);
    static final HashSet<String> BOOL_TRUE = new HashSet<String>(Colls.list("on", "true", "yes"));
    static final HashSet<String> BOOL_FALSE = new HashSet<String>(Colls.list("off", "false", "no"));

    private CmdLineParser() {
    }

    static Type getTypeFor(Class<?> clazz) {
        Type type = TYPE_MAP.get(clazz);
        if (type != null) {
            return type;
        }
        if (Classes.implementsInterface(clazz, List.class)) {
            return Type.LIST;
        }
        return Type.UNSUPPORTED;
    }

    static String defaultToString(Object value, Type type, Arg arg) {
        if (value == null || arg.isSwitch || arg.catchAll || !arg.printDefault) {
            return null;
        }
        if (type == Type.LIST) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            Once<String> once = Once.of("", Character.toString(arg.itemSep));
            for (Object o : list) {
                sb.append(once.get());
                sb.append(o.toString());
            }
            return sb.toString();
        }
        return value.toString();
    }

    private static void parseArgs(Object[] objs, List<Arg> allArgs, HashMap<String, Arg> shortArgs, HashMap<String, Arg> longArgs) throws IOException {
        for (Object obj : objs) {
            Field[] fields;
            Class<?> cl = obj.getClass();
            for (Field f : fields = cl.getDeclaredFields()) {
                if (!f.isAnnotationPresent(CmdArgument.class)) continue;
                Arg arg = new Arg(f.getAnnotation(CmdArgument.class), obj, f);
                if (arg.type == Type.UNSUPPORTED) {
                    throw new IOException("Unsupported parameter type: " + f.getType().getCanonicalName() + " for: " + arg);
                }
                if (arg.listType == Type.UNSUPPORTED || arg.listType == Type.LIST) {
                    throw new IOException("Unsupported list type: " + f.getType().getCanonicalName() + " for: " + arg);
                }
                if (Strings.isEmpty(arg.s) && Strings.isEmpty(arg.l)) {
                    throw new IOException("Missing parameter name");
                }
                if (!Strings.isEmpty(arg.s)) {
                    if (shortArgs.containsKey(arg.s)) {
                        throw new IOException("Duplicate short argument: -" + arg.s);
                    }
                    shortArgs.put(arg.s, arg);
                }
                if (!Strings.isEmpty(arg.l)) {
                    if (longArgs.containsKey(arg.l)) {
                        throw new IOException("Duplicate long argument: --" + arg.l);
                    }
                    longArgs.put(arg.l, arg);
                }
                if (arg.isCatchAll() && arg.type != Type.LIST) {
                    throw new IOException("Parameter '" + arg + "' requires a List field.");
                }
                if (arg.isSwitch && arg.type != Type.BOOL) {
                    throw new IOException("Parameter '" + arg + "' requires a Boolean/boolean field.");
                }
                allArgs.add(arg);
            }
        }
    }

    public static String generateHelp(int columnWidth, boolean sort, Object ... objs) throws IOException {
        List<Object> allArgs = Colls.list(new Object[0]);
        HashMap<String, Arg> shortArgs = new HashMap<String, Arg>();
        HashMap<String, Arg> longArgs = new HashMap<String, Arg>();
        CmdLineParser.parseArgs(objs, allArgs, shortArgs, longArgs);
        int minArgLen = 0;
        for (Arg arg : allArgs) {
            int n = arg.toString().length();
            if (!arg.isSwitch) {
                ++n;
                n += arg.getResolvedType().toString().length();
                if (arg.isCatchAll()) {
                    ++n;
                } else if (arg.isList()) {
                    n += 6;
                }
            }
            minArgLen = Math.max(minArgLen, n);
        }
        minArgLen += 2;
        if (sort) {
            Collections.sort(allArgs);
        }
        StringBuilder sb = new StringBuilder();
        for (Arg arg : allArgs) {
            StringBuilder line = new StringBuilder();
            line.append(' ');
            line.append(arg);
            if (!arg.isSwitch) {
                line.append(' ');
                line.append(arg.getResolvedType().toString().toLowerCase());
                if (arg.isCatchAll()) {
                    line.append('s');
                } else if (arg.isList()) {
                    line.append('[');
                    line.append(arg.itemSep);
                    line.append("...]");
                }
            }
            while (line.length() < minArgLen) {
                line.append(' ');
            }
            line.append(':');
            StringBuilder desc = new StringBuilder(arg.desc.trim());
            String defVal = CmdLineParser.defaultToString(arg.safeFieldGet(), arg.type, arg);
            if (defVal != null) {
                desc.append(" Default is: '");
                desc.append(defVal);
                desc.append("'.");
            }
            List<String> toks = Strings.split(desc.toString(), ' ');
            for (String s : toks) {
                if (line.length() + s.length() + 1 > columnWidth) {
                    sb.append((CharSequence)line);
                    sb.append('\n');
                    line.setLength(0);
                    while (line.length() <= minArgLen) {
                        line.append(' ');
                    }
                    line.append(' ');
                }
                line.append(' ');
                line.append(s);
            }
            if (line.length() <= minArgLen) continue;
            sb.append((CharSequence)line);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static List<String> parse(String[] args, Object ... objs) throws IOException {
        List<Object> ret = Colls.list(new Object[0]);
        List<Object> allArgs = Colls.list(new Object[0]);
        HashMap<String, Arg> shortArgs = new HashMap<String, Arg>();
        HashMap<String, Arg> longArgs = new HashMap<String, Arg>();
        CmdLineParser.parseArgs(objs, allArgs, shortArgs, longArgs);
        for (int i = 0; i < args.length; ++i) {
            Arg a;
            String string = args[i];
            if (string.startsWith("--")) {
                a = longArgs.get(string.substring(2));
                if (a == null) {
                    throw new IOException("Unknown switch: " + string);
                }
            } else if (string.startsWith("-")) {
                a = shortArgs.get(string.substring(1));
                if (a == null) {
                    throw new IOException("Unknown switch: " + string);
                }
            } else {
                a = null;
                ret.add(string);
            }
            if (a == null) continue;
            if (a.isSwitch) {
                a.setField("true");
            } else {
                if (i + 1 >= args.length) {
                    System.out.println("Missing parameter for: " + string);
                }
                if (a.isCatchAll()) {
                    List<Object> ca = Colls.list(new Object[0]);
                    ++i;
                    while (i < args.length) {
                        ca.add(args[i]);
                        ++i;
                    }
                    a.setCatchAll(ca);
                } else {
                    a.setField(args[++i]);
                }
            }
            a.setPresent();
        }
        for (Arg arg : allArgs) {
            if (arg.isOk()) continue;
            throw new IOException("Missing mandatory argument: " + arg);
        }
        return ret;
    }

    static {
        for (int i = 0; i < TYPE_CLASS_LIST.length; ++i) {
            TYPE_MAP.put(TYPE_CLASS_LIST[i], TYPE_TYPE_LIST[i]);
        }
    }

    private static final class Strings {
        private Strings() {
        }

        public static final boolean isEmpty(String str) {
            return str == null || str.isEmpty();
        }

        public static final List<String> split(String str, char ch) {
            List<Object> ret = Colls.list(new Object[0]);
            if (str != null) {
                int e;
                int s = 0;
                for (e = 0; e < str.length(); ++e) {
                    if (str.charAt(e) != ch) continue;
                    ret.add(str.substring(s, e));
                    s = e + 1;
                }
                ret.add(str.substring(s, e));
            }
            return ret;
        }
    }

    private static final class Classes {
        private Classes() {
        }

        static final boolean implementsInterface(Class<?> clazz, Class<?> interfce) {
            for (Class<?> c : clazz.getInterfaces()) {
                if (!c.equals(interfce)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Colls {
        private Colls() {
        }

        static final <T> T[] objArray(T ... ts) {
            return ts;
        }

        static final <A> List<A> list(A ... coll) {
            ArrayList<A> ret = new ArrayList<A>(coll.length);
            for (int i = 0; i < coll.length; ++i) {
                ret.add(coll[i]);
            }
            return ret;
        }
    }

    private static class Once<T> {
        private final T first;
        private final T next;
        private boolean isFirst = true;

        public Once(T first, T next) {
            this.first = first;
            this.next = next;
        }

        public static <T> Once<T> of(T first, T next) {
            return new Once<T>(first, next);
        }

        public T get() {
            if (this.isFirst) {
                this.isFirst = false;
                return this.first;
            }
            return this.next;
        }
    }

    private static class Arg
    implements Comparable<Arg> {
        final String s;
        final String l;
        final String id;
        final String desc;
        final char itemSep;
        final boolean isSwitch;
        final boolean required;
        final boolean catchAll;
        final boolean printDefault;
        final Type type;
        final Type listType;
        boolean present = false;
        final Object object;
        final Field field;

        public Arg(CmdArgument arg, Object obj, Field field) {
            this.s = arg.s() == '\u0000' ? "" : Character.toString(arg.s());
            this.l = arg.l();
            this.desc = arg.desc();
            this.isSwitch = arg.isSwitch();
            this.required = arg.required();
            this.catchAll = arg.catchAll();
            this.itemSep = arg.listSep();
            this.printDefault = arg.printDefault();
            this.id = this.s + "/" + this.l;
            this.object = obj;
            this.field = field;
            this.type = CmdLineParser.getTypeFor(this.field.getType());
            this.listType = CmdLineParser.getTypeFor(arg.listType());
        }

        public Type getResolvedType() {
            return this.isList() ? this.listType : this.type;
        }

        public boolean isCatchAll() {
            return this.catchAll;
        }

        public boolean isList() {
            return this.type == Type.LIST;
        }

        public void setCatchAll(List<String> list) throws IOException {
            this.setListField(list);
        }

        public void setListField(List<String> list) throws IOException {
            try {
                if (this.listType == Type.STRING) {
                    this.field.set(this.object, list);
                } else {
                    List<Object> temp = Colls.list(new Object[0]);
                    for (String i : list) {
                        temp.add(this.toObject(i, this.listType));
                    }
                    this.field.set(this.object, temp);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Failed to write value", e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Failed to write value", e);
            }
        }

        Object safeFieldGet() {
            try {
                return this.field.get(this.object);
            }
            catch (Exception e) {
                return null;
            }
        }

        private Object toObject(String value, Type type) throws IOException {
            try {
                switch (type) {
                    case STRING: {
                        return value;
                    }
                    case BYTE: {
                        return Byte.parseByte(value);
                    }
                    case SHORT: {
                        return Short.parseShort(value);
                    }
                    case INT: {
                        return Integer.parseInt(value);
                    }
                    case LONG: {
                        return Long.parseLong(value);
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.parseFloat(value));
                    }
                    case DOUBLE: {
                        return Double.parseDouble(value);
                    }
                    case BOOL: {
                        if (BOOL_TRUE.contains(value.toLowerCase())) {
                            return true;
                        }
                        if (BOOL_FALSE.contains(value.toLowerCase())) {
                            return false;
                        }
                        throw new IOException("Illegal bool value for:" + this.toString());
                    }
                }
                throw new IOException("Illegal type: " + type.toString().toLowerCase());
            }
            catch (Throwable t) {
                throw new IOException("Parsing error for: " + this.toString() + "; '" + value + "'", t);
            }
        }

        public void setField(String value) throws IOException {
            try {
                if (this.isList()) {
                    this.setListField(Strings.split(value, this.itemSep));
                } else {
                    this.field.set(this.object, this.toObject(value, this.type));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Failed to write field: " + this.field.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Failed to write field: " + this.field.getName(), e);
            }
        }

        public void setPresent() {
            this.present = true;
        }

        public boolean isOk() {
            return !this.required || this.present;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Arg) {
                return this.id.equals(((Arg)obj).id);
            }
            return false;
        }

        public String toString() {
            if (Strings.isEmpty(this.s)) {
                return "    --" + this.l;
            }
            if (Strings.isEmpty(this.l)) {
                return "-" + this.s;
            }
            return "-" + this.s + ", --" + this.l;
        }

        @Override
        public int compareTo(Arg o) {
            String a = Strings.isEmpty(this.s) ? this.l : this.s;
            String b = Strings.isEmpty(o.s) ? o.l : o.s;
            return a.compareTo(b);
        }
    }

    static enum Type {
        UNSUPPORTED,
        STRING,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        LIST,
        BOOL;

    }
}

