/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime.adapters;

import gololang.FunctionReference;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.golo.runtime.adapters.AdapterDefinitionProblem;

public final class AdapterDefinition {
    private final ClassLoader classLoader;
    private final String name;
    private final String parent;
    private final TreeSet<String> interfaces = new TreeSet();
    private final LinkedHashMap<String, FunctionReference> implementations = new LinkedHashMap();
    private final LinkedHashMap<String, FunctionReference> overrides = new LinkedHashMap();

    public AdapterDefinition(ClassLoader classLoader, String name, String parent) {
        this.classLoader = classLoader;
        this.name = name;
        this.parent = parent;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public Set<String> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    public Map<String, FunctionReference> getImplementations() {
        return Collections.unmodifiableMap(this.implementations);
    }

    public Map<String, FunctionReference> getOverrides() {
        return Collections.unmodifiableMap(this.overrides);
    }

    public AdapterDefinition implementsInterface(String iface) {
        this.interfaces.add(iface);
        return this;
    }

    public AdapterDefinition implementsMethod(String name, FunctionReference target) throws AdapterDefinitionProblem {
        this.checkForImplementation(target);
        this.checkStarImplementationType(name, target);
        this.implementations.put(name, target);
        return this;
    }

    public AdapterDefinition overridesMethod(String name, FunctionReference target) throws AdapterDefinitionProblem {
        this.checkForOverriding(target);
        this.checkStarOverrideType(name, target);
        this.overrides.put(name, target);
        return this;
    }

    public boolean hasStarImplementation() {
        return this.implementations.containsKey("*");
    }

    public boolean hasStarOverride() {
        return this.overrides.containsKey("*");
    }

    public AdapterDefinition validate() throws AdapterDefinitionProblem {
        this.checkSuperTypesExistence();
        this.checkStarConflict();
        this.checkMethodsToBeImplemented();
        this.checkOverridesImplementationsConflict();
        this.checkAllOverridesAndImplementationsExist();
        return this;
    }

    private void checkOverridesImplementationsConflict() {
        for (String key : this.implementations.keySet()) {
            if ("*".equals(key) || !this.overrides.containsKey(key)) continue;
            throw new AdapterDefinitionProblem("Conflict: there is both an implementation and an override for method " + key);
        }
    }

    private void checkStarImplementationType(String name, FunctionReference target) {
        if ("*".equals(name) && !target.type().equals((Object)MethodType.genericMethodType(2))) {
            throw new AdapterDefinitionProblem("A * implementation must be of type (Object methodName, Object args)Object: " + target);
        }
    }

    private void checkStarOverrideType(String name, FunctionReference target) {
        if ("*".equals(name) && !target.type().equals((Object)MethodType.genericMethodType(3))) {
            throw new AdapterDefinitionProblem("A * override must be of type (Object superHandle, Object methodName, Object args)Object: " + target);
        }
    }

    private void checkAllOverridesAndImplementationsExist() {
        try {
            Class<?> parentClass = Class.forName(this.parent, true, this.classLoader);
            HashSet<String> canBeOverridden = new HashSet<String>();
            for (Method method : parentClass.getMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                canBeOverridden.add(method.getName());
            }
            for (Method method : parentClass.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                canBeOverridden.add(method.getName());
            }
            for (Method method : parentClass.getMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                canBeOverridden.add(method.getName());
            }
            for (String key : this.overrides.keySet()) {
                if ("*".equals(key) || canBeOverridden.contains(key)) continue;
                throw new AdapterDefinitionProblem("There is no method named " + key + " to be overridden in " + parentClass);
            }
            for (String iface : this.interfaces) {
                for (Method method : Class.forName(iface, true, this.classLoader).getMethods()) {
                    canBeOverridden.add(method.getName());
                }
            }
            for (String key : this.implementations.keySet()) {
                if ("*".equals(key) || canBeOverridden.contains(key)) continue;
                throw new AdapterDefinitionProblem("There is no method named " + key + " to be implemented in " + parentClass + " or interfaces " + this.interfaces);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AdapterDefinitionProblem(e);
        }
    }

    private Set<Method> abstractMethodsIn(Class<?> klass) {
        LinkedHashSet<Method> abstractMethods = new LinkedHashSet<Method>();
        for (Method method : klass.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            abstractMethods.add(method);
        }
        for (Method method : klass.getDeclaredMethods()) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            abstractMethods.add(method);
        }
        return abstractMethods;
    }

    private void checkMethodsToBeImplemented() {
        try {
            LinkedHashSet<Method> abstractMethods = new LinkedHashSet<Method>();
            abstractMethods.addAll(this.abstractMethodsIn(Class.forName(this.parent, true, this.classLoader)));
            for (String iface : this.interfaces) {
                abstractMethods.addAll(this.abstractMethodsIn(Class.forName(iface, true, this.classLoader)));
            }
            for (Method abstractMethod : abstractMethods) {
                FunctionReference target;
                String name = abstractMethod.getName();
                if (!this.implementations.containsKey(name) && !this.hasStarImplementation()) {
                    throw new AdapterDefinitionProblem("There is no implementation or override for: " + abstractMethod);
                }
                if (this.implementations.containsKey(name) && (this.argsDifferForImplementation(abstractMethod, target = this.implementations.get(name)) || this.varargsMismatch(abstractMethod, target))) {
                    throw new AdapterDefinitionProblem("Types do not match to implement " + abstractMethod + " with " + target);
                }
                if (!this.overrides.containsKey(name) || !this.argsDifferForOverride(abstractMethod, target = this.overrides.get(name)) && !this.varargsMismatch(abstractMethod, target)) continue;
                throw new AdapterDefinitionProblem("Types do not match to implement " + abstractMethod + " with " + target);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AdapterDefinitionProblem(e);
        }
    }

    private boolean varargsMismatch(Method abstractMethod, FunctionReference target) {
        return abstractMethod.isVarArgs() != target.isVarargsCollector();
    }

    private boolean argsDifferForImplementation(Method abstractMethod, FunctionReference target) {
        return target.type().parameterCount() - 1 != abstractMethod.getParameterTypes().length;
    }

    private boolean argsDifferForOverride(Method abstractMethod, FunctionReference target) {
        return target.type().parameterCount() - 2 != abstractMethod.getParameterTypes().length;
    }

    private void checkStarConflict() {
        if (this.hasStarImplementation() && this.hasStarOverride()) {
            throw new AdapterDefinitionProblem("Having both a star implementation and a star override is forbidden.");
        }
    }

    private void checkSuperTypesExistence() {
        try {
            Class<?> parentClass = Class.forName(this.parent, true, this.classLoader);
            if (parentClass.isInterface()) {
                throw new AdapterDefinitionProblem("The parent class cannot be an interface: " + parentClass.getName());
            }
            if (Modifier.isFinal(parentClass.getModifiers())) {
                throw new AdapterDefinitionProblem("The parent class is final: " + parentClass.getName());
            }
            for (String iface : this.interfaces) {
                Class.forName(iface, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AdapterDefinitionProblem(e);
        }
    }

    private void checkForImplementation(FunctionReference target) throws AdapterDefinitionProblem {
        if (target.type().parameterCount() < 1) {
            throw new AdapterDefinitionProblem("An implemented method target must take at least 1 argument (the receiver): " + target);
        }
    }

    private void checkForOverriding(FunctionReference target) throws AdapterDefinitionProblem {
        if (target.type().parameterCount() < 2) {
            throw new AdapterDefinitionProblem("An overriden method target must take at least 2 arguments (the 'super' function reference followed by the receiver): " + target);
        }
    }
}

