/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.eclipse.golo.runtime.DecoratorsHelper;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.NamedArgumentsHelper;
import org.eclipse.golo.runtime.Warnings;

abstract class MethodFinder {
    protected final MethodInvocation invocation;
    protected final MethodHandles.Lookup lookup;
    protected final Class<?> callerClass;

    MethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        this.invocation = invocation;
        this.lookup = lookup;
        this.callerClass = lookup.lookupClass();
    }

    public abstract MethodHandle find();

    protected int[] getArgumentsOrder(Method method, List<String> parameterNames, String[] argumentNames) {
        int[] argumentsOrder = new int[parameterNames.size() + 1];
        argumentsOrder[0] = 0;
        for (int i = 0; i < argumentNames.length; ++i) {
            int actualPosition = parameterNames.indexOf(argumentNames[i]);
            NamedArgumentsHelper.checkArgumentPosition(actualPosition, argumentNames[i], method.getName() + parameterNames);
            argumentsOrder[actualPosition + 1] = i + 1;
        }
        return argumentsOrder;
    }

    public MethodHandle reorderArguments(Method method, MethodHandle handle) {
        String[] argumentNames = this.invocation.argumentNames();
        if (argumentNames.length == 0) {
            return handle;
        }
        if (NamedArgumentsHelper.hasNamedParameters(method).booleanValue()) {
            return MethodHandles.permuteArguments(handle, handle.type(), this.getArgumentsOrder(method, NamedArgumentsHelper.getParameterNames(method), argumentNames));
        }
        Warnings.noParameterNames(method.getName(), argumentNames);
        return handle;
    }

    protected Optional<MethodHandle> toMethodHandle(Method method) {
        MethodHandle target = null;
        if (DecoratorsHelper.isMethodDecorated(method)) {
            target = DecoratorsHelper.getDecoratedMethodHandle(this.lookup, method, this.invocation.arity());
        } else {
            try {
                target = this.lookup.unreflect(method);
            }
            catch (IllegalAccessException e) {
                return Optional.empty();
            }
        }
        return Optional.of(this.invocation.coerce(this.reorderArguments(method, target)));
    }
}

