/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;

public class ClosureReference
extends ExpressionStatement {
    private GoloFunction target;
    private final Set<String> capturedReferenceNames = new LinkedHashSet<String>();

    ClosureReference(GoloFunction target) {
        this.setTarget(target);
    }

    public GoloFunction getTarget() {
        return this.target;
    }

    private void setTarget(GoloFunction target) {
        this.target = target;
        this.makeParentOf(target);
        this.setASTNode(target.getASTNode());
        this.updateCapturedReferenceNames();
    }

    public Set<String> getCapturedReferenceNames() {
        return Collections.unmodifiableSet(this.capturedReferenceNames);
    }

    public void updateCapturedReferenceNames() {
        for (String name : this.target.getSyntheticParameterNames()) {
            this.capturedReferenceNames.add(name);
        }
    }

    public ClosureReference block(Object ... statements) {
        this.target.block(statements);
        return this;
    }

    public ClosureReference returns(Object expression) {
        this.target.returns(expression);
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitClosureReference(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.target.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!(newElement instanceof GoloFunction) || !this.target.equals(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.setTarget((GoloFunction)newElement);
    }
}

