/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.Range;
import gololang.Tuple;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractRange<T extends Comparable<T>>
extends AbstractCollection<T>
implements Range<T> {
    private final T from;
    private final T to;
    private int increment = 1;
    private int cmp = 1;

    public AbstractRange(T from, T to) {
        this.from = from;
        this.to = to;
    }

    public AbstractRange(T to) {
        this.to = to;
        this.from = this.defaultValue();
    }

    T defaultValue() {
        throw new UnsupportedOperationException("no default value define for this range");
    }

    @Override
    public T from() {
        return this.from;
    }

    @Override
    public T to() {
        return this.to;
    }

    @Override
    public int increment() {
        return this.increment;
    }

    protected int cmp() {
        return this.cmp;
    }

    @Override
    public boolean encloses(T v) {
        return (v.compareTo((Object)this.from()) == 0 || v.compareTo((Object)this.from()) * this.cmp() > 0) && this.to().compareTo(v) * this.cmp() > 0;
    }

    @Override
    public Range<T> incrementBy(int value) {
        if (value == 0) {
            throw new IllegalArgumentException("increment for range must not be zero");
        }
        this.increment = value;
        this.cmp = value < 0 ? -1 : 1;
        return this;
    }

    @Override
    public Range<T> decrementBy(int value) {
        return this.incrementBy(-value);
    }

    @Override
    public String toString() {
        if (this.increment != 1) {
            return String.format("range(%s,%s):incrementBy(%s)", this.from, this.to, this.increment);
        }
        return String.format("range(%s,%s)", this.from, this.to);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        Range otherRange = (Range)other;
        return this.from().equals(otherRange.from()) && this.to().equals(otherRange.to()) && this.increment() == otherRange.increment();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new int[]{this.from().hashCode(), this.to().hashCode(), this.increment()});
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            return null;
        }
        return this.from;
    }

    @Override
    public boolean isEmpty() {
        return this.from.compareTo(this.to) >= 0;
    }

    public Tuple destruct() {
        Object[] data = new Object[this.size()];
        int i = 0;
        for (Comparable v : this) {
            data[i] = v;
            ++i;
        }
        return Tuple.fromArray(data);
    }

    static abstract class RangeIterator<T extends Comparable<T>>
    implements Iterator<T> {
        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on a range");
        }
    }
}

