/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloCompilationException;
import org.eclipse.golo.compiler.GoloCompiler;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.IrTreeDumper;
import org.eclipse.golo.compiler.parser.ASTCompilationUnit;

@Parameters(commandNames={"diagnose"}, commandDescription="Diagnosis for the Golo compiler internals")
public class DiagnoseCommand
implements CliCommand {
    @Parameter(names={"--tool"}, description="The diagnosis tool to use: {ast, ir}", validateWith=DiagnoseModeValidator.class)
    String mode = "ir";
    @Parameter(names={"--stage"}, description="The compilation stage to diagnose: {ast, raw, refined}", validateWith=DiagnoseStageValidator.class)
    String stage = "refined";
    @Parameter(description="Golo source files (*.golo and directories)")
    List<String> files = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        if ("ast".equals(this.stage) && !"ast".equals(this.mode)) {
            this.mode = "ast";
        }
        if ("ast".equals(this.mode) && !"ast".equals(this.stage)) {
            this.stage = "ast";
        }
        try {
            switch (this.mode) {
                case "ast": {
                    this.dumpASTs(this.files);
                    break;
                }
                case "ir": {
                    this.dumpIRs(this.files);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"WTF?");
                }
            }
        }
        catch (GoloCompilationException e) {
            this.handleCompilationException(e);
        }
    }

    private void dumpASTs(List<String> files) {
        GoloCompiler compiler = new GoloCompiler();
        for (String file : files) {
            this.dumpAST(file, compiler);
        }
    }

    private void dumpAST(String goloFile, GoloCompiler compiler) {
        block4: {
            File file;
            block3: {
                file = new File(goloFile);
                if (!file.isDirectory()) break block3;
                File[] directoryFiles = file.listFiles();
                if (directoryFiles == null) break block4;
                for (File directoryFile : directoryFiles) {
                    this.dumpAST(directoryFile.getAbsolutePath(), compiler);
                }
                break block4;
            }
            if (!file.getName().endsWith(".golo")) break block4;
            System.out.println(">>> AST for: " + goloFile);
            try {
                ASTCompilationUnit ast = compiler.parse(goloFile);
                ast.dump("% ");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println("[error] " + goloFile + " does not exist or could not be opened.");
            }
        }
    }

    private void dumpIRs(List<String> files) {
        GoloCompiler compiler = new GoloCompiler();
        IrTreeDumper dumper = new IrTreeDumper();
        for (String file : files) {
            this.dumpIR(file, compiler, dumper);
        }
    }

    private void dumpIR(String goloFile, GoloCompiler compiler, IrTreeDumper dumper) {
        File file = new File(goloFile);
        if (file.isDirectory()) {
            File[] directoryFiles = file.listFiles();
            if (directoryFiles != null) {
                for (File directoryFile : directoryFiles) {
                    this.dumpIR(directoryFile.getAbsolutePath(), compiler, dumper);
                }
            }
        } else if (file.getName().endsWith(".golo")) {
            System.out.println(">>> IR for: " + file);
            try {
                GoloModule module = compiler.transform(compiler.parse(goloFile));
                if ("refined".equals(this.stage)) {
                    compiler.refine(module);
                }
                module.accept(dumper);
            }
            catch (IOException e) {
                System.out.println("[error] " + goloFile + " does not exist or could not be opened.");
            }
            System.out.println();
        }
    }

    public static final class DiagnoseStageValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            switch (value) {
                case "ast": 
                case "raw": 
                case "refined": {
                    return;
                }
            }
            throw new ParameterException("Diagnosis stage must be in: {ast, raw, refined}");
        }
    }

    public static final class DiagnoseModeValidator
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            switch (value) {
                case "ast": 
                case "ir": {
                    return;
                }
            }
            throw new ParameterException("Diagnosis tool must be in: {ast, ir}");
        }
    }
}

