/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;

public final class WhenClause<T extends GoloElement>
extends GoloElement {
    private ExpressionStatement condition;
    private T action;

    WhenClause(ExpressionStatement condition, T action) {
        this.condition = condition;
        this.makeParentOf(condition);
        this.setAction(action);
    }

    public ExpressionStatement condition() {
        return this.condition;
    }

    public T action() {
        return this.action;
    }

    public void setAction(T a) {
        this.action = a;
        this.makeParentOf((GoloElement)a);
    }

    public String toString() {
        return String.format("when %s then %s", this.condition, this.action);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (this.condition.equals(original)) {
            if (!(newElement instanceof ExpressionStatement)) {
                throw WhenClause.cantConvert("ExpressionStatement", newElement);
            }
            this.condition = (ExpressionStatement)newElement;
            this.makeParentOf(this.condition);
        } else if (this.action.equals(original)) {
            GoloElement element = newElement;
            this.setAction(element);
        } else {
            throw this.doesNotContain(original);
        }
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitWhenClause(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.condition.accept(visitor);
        ((GoloElement)this.action).accept(visitor);
    }
}

