/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.runtime.OperatorType;

public class UnaryOperation
extends ExpressionStatement {
    private final OperatorType type;
    private ExpressionStatement expressionStatement;

    UnaryOperation(OperatorType type, ExpressionStatement expressionStatement) {
        this.type = type;
        this.setExpressionStatement(expressionStatement);
    }

    public ExpressionStatement getExpressionStatement() {
        return this.expressionStatement;
    }

    private void setExpressionStatement(ExpressionStatement statement) {
        this.expressionStatement = statement;
        this.makeParentOf(statement);
    }

    public OperatorType getType() {
        return this.type;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnaryOperation(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expressionStatement.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.expressionStatement.equals(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement((ExpressionStatement)newElement);
    }
}

