/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public final class SymbolGenerator {
    private static final String FORMAT = "__$$_%s_%d";
    private static final String DEFAULT_NAME = "symbol";
    private final AtomicLong counter = new AtomicLong();
    private final Deque<String> prefixes = new LinkedList<String>();

    public SymbolGenerator(String name) {
        this.prefixes.addLast(name == null ? DEFAULT_NAME : name);
    }

    public SymbolGenerator() {
        this.prefixes.addLast(DEFAULT_NAME);
    }

    private String name(String localName) {
        String name = String.join((CharSequence)"_", this.prefixes);
        if (localName != null && !"".equals(localName)) {
            name = name + "_" + localName;
        }
        return name;
    }

    public String next() {
        return this.next(null);
    }

    public String next(String name) {
        return String.format(FORMAT, this.name(name), this.counter.getAndIncrement());
    }

    public SymbolGenerator exit() {
        if (this.prefixes.size() == 1) {
            return this;
        }
        this.prefixes.removeLast();
        return this;
    }

    public SymbolGenerator enter(String scopeName) {
        this.prefixes.addLast(scopeName);
        return this;
    }
}

