/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloClassLoader;
import org.eclipse.golo.compiler.GoloCompilationException;

@Parameters(commandNames={"golo"}, commandDescription="Dynamically loads and runs from Golo source files")
public class GoloGoloCommand
implements CliCommand {
    @Parameter(names={"--files"}, variableArity=true, description="Golo source files (*.golo and directories). The last one has a main function or use --module", required=true)
    List<String> files = new LinkedList<String>();
    @Parameter(names={"--module"}, description="The Golo module with a main function")
    String module;
    @Parameter(names={"--args"}, variableArity=true, description="Program arguments")
    List<String> arguments = new LinkedList<String>();
    @Parameter(names={"--classpath"}, variableArity=true, description="Classpath elements (.jar and directories)")
    List<String> classpath = new LinkedList<String>();

    @Override
    public void execute() throws Throwable {
        URLClassLoader primaryClassLoader = this.primaryClassLoader(this.classpath);
        GoloClassLoader loader = new GoloClassLoader(primaryClassLoader);
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> lastClass = null;
        for (String goloFile : this.files) {
            lastClass = this.loadGoloFile(goloFile, this.module, loader);
        }
        if (lastClass == null && this.module != null) {
            System.out.println("The module " + this.module + " does not exist in the classpath.");
            return;
        }
        if (lastClass == null) {
            return;
        }
        this.callRun(lastClass, this.arguments.toArray(new String[this.arguments.size()]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> loadGoloFile(String goloFile, String module, GoloClassLoader loader) throws Throwable {
        File file = new File(goloFile);
        if (!file.exists()) {
            System.out.println("Error: " + file.getAbsolutePath() + " does not exist.");
            return null;
        }
        if (file.isDirectory()) {
            File[] directoryFiles = file.listFiles();
            if (directoryFiles == null) return null;
            Class<?> lastClass = null;
            File[] fileArray = directoryFiles;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File directoryFile = fileArray[n2];
                Class<?> loadedClass = this.loadGoloFile(directoryFile.getAbsolutePath(), module, loader);
                if (module == null || loadedClass != null && loadedClass.getCanonicalName().equals(module)) {
                    lastClass = loadedClass;
                }
                ++n2;
            }
            return lastClass;
        }
        if (!file.getName().endsWith(".golo")) return null;
        try (FileInputStream in = new FileInputStream(file);){
            Class<?> loadedClass = loader.load(file.getName(), in);
            if (module != null) {
                if (!loadedClass.getCanonicalName().equals(module)) return null;
            }
            Class<?> clazz = loadedClass;
            return clazz;
        }
        catch (GoloCompilationException e) {
            this.handleCompilationException(e);
        }
        return null;
    }
}

