/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.HashMap;
import java.util.Map;

public class BiIndex<K, V> {
    protected Map<K, V> map = new HashMap();
    protected Map<V, K> inverseMap = new HashMap<V, K>();

    public Map<K, V> map() {
        return Map.copyOf(this.map);
    }

    public Map<V, K> inverseMap() {
        return Map.copyOf(this.inverseMap);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.inverseMap.containsKey(value);
    }

    public V get(Object key) {
        return this.map.get(key);
    }

    public K getKey(Object value) {
        return this.inverseMap.get(value);
    }

    public V put(K key, V value) {
        K existingKey = this.inverseMap.get(value);
        if (existingKey != null && existingKey != key) {
            throw new IllegalArgumentException("Value already present: " + String.valueOf(value));
        }
        V result = this.map.put(key, value);
        this.inverseMap.put(value, key);
        return result;
    }

    public V forcePut(K key, V value) {
        K existingKey = this.inverseMap.remove(value);
        if (existingKey != null) {
            this.map.remove(existingKey);
        }
        return this.put(key, value);
    }

    public void clear() {
        this.map.clear();
        this.inverseMap.clear();
    }

    public V remove(Object key) {
        V value = this.map.remove(key);
        if (value != null) {
            this.inverseMap.remove(value);
        }
        return value;
    }

    public K removeValue(Object value) {
        K key = this.inverseMap.remove(value);
        if (key != null) {
            this.map.remove(key);
        }
        return key;
    }

    public boolean remove(Object key, Object value) {
        V currentValue = this.map.get(key);
        K currentKey = this.inverseMap.get(value);
        if (currentValue.equals(value) && currentKey.equals(key)) {
            this.map.remove(key);
            this.inverseMap.remove(value);
            return true;
        }
        return false;
    }

    public V putIfAbsent(K key, V value) {
        V v = this.get(key);
        if (v == null && !this.inverseMap.containsKey(value)) {
            v = this.put(key, value);
        }
        return v;
    }
}

