/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPort;
import org.eclipse.glsp.server.model.GModelState;

public final class GModelUtil {
    public static Predicate<GModelElement> IS_CONNECTABLE = modelElement -> modelElement instanceof GPort || modelElement instanceof GNode;

    private GModelUtil() {
    }

    public static Function<Integer, String> idAndIndex(String id) {
        return i -> String.valueOf(id) + i;
    }

    public static int generateId(EClass eClass, String id, GModelState modelState) {
        return modelState.getIndex().getCounter(eClass, GModelUtil.idAndIndex(id));
    }

    public static int generateId(GModelElement element, String id, GModelState modelState) {
        int index = GModelUtil.generateId(element.eClass(), id, modelState);
        element.setId(GModelUtil.idAndIndex(id).apply(index));
        return index;
    }

    public static <T> Stream<T> filterByType(List<GModelElement> elements, Class<T> clazz) {
        return elements.stream().filter(clazz::isInstance).map(clazz::cast);
    }
}

