/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.actions.BasicActionHandler;
import org.eclipse.glsp.server.actions.ConfigureServerHandlersAction;
import org.eclipse.glsp.server.actions.InitializeClientSessionAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServerException;

public class InitializeClientSessionActionHandler
extends BasicActionHandler<InitializeClientSessionAction> {
    @Inject
    protected ClientSessionManager clientSessionManager;
    @Inject
    protected Provider<GLSPClient> client;
    @Inject
    protected Provider<ActionRegistry> actionRegistry;
    @Inject
    @Named(value="ClientActionHandler")
    protected Provider<Set<Action>> clientActions;

    @Override
    protected List<Action> executeAction(InitializeClientSessionAction action, GModelState modelState) {
        if (!this.clientSessionManager.createClientSession((GLSPClient)this.client.get(), action.getClientId())) {
            throw new GLSPServerException(String.format("Could not create session for client id '%s'. Another session with the same id already exists", action.getClientId()));
        }
        modelState.setClientId(action.getClientId());
        return this.listOf(this.configureServerHandlers());
    }

    protected Action configureServerHandlers() {
        Set<String> actionKinds = ((ActionRegistry)this.actionRegistry.get()).keys();
        actionKinds.removeAll(((Set)this.clientActions.get()).stream().map(Action::getKind).collect(Collectors.toSet()));
        return new ConfigureServerHandlersAction(actionKinds);
    }
}

