/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gemoc.dsl.debug.ide.adapter.ILocator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.gemoc.dsl.debug.ide";
    private static Activator plugin;
    private static List<ILocator> locators;

    public List<ILocator> retrieveLocators() {
        if (locators == null) {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.gemoc.dsl.debug.locator");
            IExtension[] extensions = ep.getExtensions();
            ArrayList<ILocator> contributors = new ArrayList<ILocator>();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                IConfigurationElement[] ce = ext.getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    try {
                        ILocator locator = (ILocator)ce[j].createExecutableExtension("class");
                        contributors.add(locator);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
            locators = contributors;
        }
        return locators;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void info(String message) {
        this.log(message, 1);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log("[DEBUG] " + message, 1);
        }
    }

    public boolean isDebugEnabled() {
        if (plugin != null) {
            return Platform.inDebugMode();
        }
        return false;
    }

    private void log(String message, int level) {
        this.log((IStatus)new Status(level, PLUGIN_ID, message));
    }

    private void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void warn(String message) {
        this.log(message, 2);
    }

    public void error(Throwable e) {
        this.error("Unexpected Error", e);
    }

    public void error(String message, Throwable e) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
        }
        Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, PLUGIN_ID, message, e);
        this.log((IStatus)status);
    }
}

