/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.WebResource;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.ConcurrentDateFormat;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.apache.tomcat.util.security.MD5Encoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final ConcurrentDateFormat creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
    private final Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private final Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private final Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException e) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        if (this.isSpecialPath(path)) {
            resp.sendError(404);
            return;
        }
        String method = req.getMethod();
        if (this.debug > 0) {
            this.log("[" + method + "] " + path);
        }
        if (method.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    private final boolean isSpecialPath(String path) {
        return !this.allowSpecialPaths && (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF"));
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, WebResource resource) throws IOException {
        return super.checkIfHeaders(request, response, resource);
    }

    @Override
    protected String getRelativePath(HttpServletRequest request) {
        return this.getRelativePath(request, false);
    }

    @Override
    protected String getRelativePath(HttpServletRequest request, boolean allowEmptyPath) {
        String pathInfo = request.getAttribute("javax.servlet.include.request_uri") != null ? (String)request.getAttribute("javax.servlet.include.path_info") : request.getPathInfo();
        StringBuilder result = new StringBuilder();
        if (pathInfo != null) {
            result.append(pathInfo);
        }
        if (result.length() == 0) {
            result.append('/');
        }
        return result.toString();
    }

    @Override
    protected String getPathPrefix(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (request.getServletPath() != null) {
            contextPath = contextPath + request.getServletPath();
        }
        return contextPath;
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1,2");
        StringBuilder methodsAllowed = this.determineMethodsAllowed(req);
        resp.addHeader("Allow", methodsAllowed.toString());
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String parentPath;
        Vector<String> currentLockNullResources;
        int slash;
        WebResource resource;
        if (!this.listings) {
            StringBuilder methodsAllowed = this.determineMethodsAllowed(req);
            resp.addHeader("Allow", methodsAllowed.toString());
            resp.sendError(405);
            return;
        }
        String path = this.getRelativePath(req);
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Vector<String> properties = null;
        int depth = this.maxDepth;
        int type = 1;
        String depthStr = req.getHeader("Depth");
        if (depthStr == null) {
            depth = this.maxDepth;
        } else if (depthStr.equals("0")) {
            depth = 0;
        } else if (depthStr.equals("1")) {
            depth = 1;
        } else if (depthStr.equals("infinity")) {
            depth = this.maxDepth;
        }
        Node propNode = null;
        if (req.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                Element rootElement = document.getDocumentElement();
                NodeList childList = rootElement.getChildNodes();
                block11: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block11;
                        }
                        case 1: {
                            if (currentNode.getNodeName().endsWith("prop")) {
                                type = 0;
                                propNode = currentNode;
                            }
                            if (currentNode.getNodeName().endsWith("propname")) {
                                type = 2;
                            }
                            if (!currentNode.getNodeName().endsWith("allprop")) continue block11;
                            type = 1;
                        }
                    }
                }
            }
            catch (SAXException e) {
                resp.sendError(400);
                return;
            }
            catch (IOException e) {
                resp.sendError(400);
                return;
            }
        }
        if (type == 0) {
            properties = new Vector<String>();
            NodeList childList = propNode.getChildNodes();
            block12: for (int i = 0; i < childList.getLength(); ++i) {
                Node currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block12;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        String propertyName = null;
                        propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                        properties.addElement(propertyName);
                    }
                }
            }
        }
        if (!(resource = this.resources.getResource(path)).exists() && (slash = path.lastIndexOf(47)) != -1 && (currentLockNullResources = this.lockNullResources.get(parentPath = path.substring(0, slash))) != null) {
            Enumeration<String> lockNullResourcesList = currentLockNullResources.elements();
            while (lockNullResourcesList.hasMoreElements()) {
                String lockNullPath = lockNullResourcesList.nextElement();
                if (!lockNullPath.equals(path)) continue;
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                XMLWriter generatedXML = new XMLWriter(resp.getWriter());
                generatedXML.writeXMLHeader();
                generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                generatedXML.writeElement("D", "multistatus", 1);
                generatedXML.sendData();
                return;
            }
        }
        if (!resource.exists()) {
            resp.sendError(404, path);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (depth == 0) {
            this.parseProperties(req, generatedXML, path, type, properties);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(path);
            Stack<String> stackBelow = new Stack<String>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.pop();
                this.parseProperties(req, generatedXML, currentPath, type, properties);
                resource = this.resources.getResource(currentPath);
                if (resource.isDirectory() && depth > 0) {
                    Vector<String> currentLockNullResources2;
                    String[] entries;
                    for (String entry : entries = this.resources.list(currentPath)) {
                        String newPath = currentPath;
                        if (!newPath.endsWith("/")) {
                            newPath = newPath + "/";
                        }
                        newPath = newPath + entry;
                        stackBelow.push(newPath);
                    }
                    String lockPath = currentPath;
                    if (lockPath.endsWith("/")) {
                        lockPath = lockPath.substring(0, lockPath.length() - 1);
                    }
                    if ((currentLockNullResources2 = this.lockNullResources.get(lockPath)) != null) {
                        Enumeration<String> lockNullResourcesList = currentLockNullResources2.elements();
                        while (lockNullResourcesList.hasMoreElements()) {
                            String lockNullPath = lockNullResourcesList.nextElement();
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new Stack();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        resp.sendError(501);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        if (resource.exists()) {
            StringBuilder methodsAllowed = this.determineMethodsAllowed(req);
            resp.addHeader("Allow", methodsAllowed.toString());
            resp.sendError(405);
            return;
        }
        if (req.getContentLengthLong() > 0L) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                resp.sendError(501);
                return;
            }
            catch (SAXException saxe) {
                resp.sendError(415);
                return;
            }
        }
        if (this.resources.mkdir(path)) {
            resp.setStatus(201);
            this.lockNullResources.remove(path);
        } else {
            resp.sendError(409, WebdavStatus.getStatusText(409));
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        this.deleteResource(req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        super.doPut(req, resp);
        String path = this.getRelativePath(req);
        this.lockNullResources.remove(path);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        this.copyResource(req, resp);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        if (this.copyResource(req, resp)) {
            this.deleteResource(path, req, resp, false);
        }
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        LockInfo lock = new LockInfo();
        String depthStr = req.getHeader("Depth");
        lock.depth = depthStr == null ? this.maxDepth : (depthStr.equals("0") ? 0 : this.maxDepth);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(44);
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = Integer.parseInt(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = Integer.parseInt(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockRequestType = false;
        Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (IOException e) {
            lockRequestType = true;
        }
        catch (SAXException e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            Node currentNode;
            int i;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            block21: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block21;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = currentNode;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = currentNode;
                        }
                        if (!nodeName.endsWith("owner")) continue block21;
                        lockOwnerNode = currentNode;
                    }
                }
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                block22: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block22;
                        }
                        case 1: {
                            String tempScope = currentNode.getNodeName();
                            lock.scope = tempScope.indexOf(58) != -1 ? tempScope.substring(tempScope.indexOf(58) + 1) : tempScope;
                        }
                    }
                }
                if (lock.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                block23: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block23;
                        }
                        case 1: {
                            String tempType = currentNode.getNodeName();
                            lock.type = tempType.indexOf(58) != -1 ? tempType.substring(tempType.indexOf(58) + 1) : tempType;
                        }
                    }
                }
                if (lock.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block24: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            continue block24;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter(strWriter, true);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                        }
                    }
                }
                if (lock.owner == null) {
                    resp.setStatus(400);
                }
            } else {
                lock.owner = "";
            }
        }
        lock.path = path = this.getRelativePath(req);
        WebResource resource = this.resources.getResource(path);
        Enumeration<LockInfo> locksList = null;
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock.type + "-" + lock.scope + "-" + req.getUserPrincipal() + "-" + lock.depth + "-" + lock.owner + "-" + lock.tokens + "-" + lock.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String lockToken = MD5Encoder.encode((byte[])ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{lockTokenStr.getBytes(StandardCharsets.ISO_8859_1)}));
            if (resource.isDirectory() && lock.depth == this.maxDepth) {
                Vector<String> lockPaths = new Vector<String>();
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                locksList = this.resourceLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                if (!lockPaths.isEmpty()) {
                    Enumeration lockPathsList = lockPaths.elements();
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    while (lockPathsList.hasMoreElements()) {
                        generatedXML.writeElement("D", "response", 0);
                        generatedXML.writeElement("D", "href", 0);
                        generatedXML.writeText((String)lockPathsList.nextElement());
                        generatedXML.writeElement("D", "href", 1);
                        generatedXML.writeElement("D", "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        generatedXML.writeElement("D", "status", 1);
                        generatedXML.writeElement("D", "response", 1);
                    }
                    generatedXML.writeElement("D", "multistatus", 1);
                    PrintWriter writer = resp.getWriter();
                    ((Writer)writer).write(generatedXML.toString());
                    ((Writer)writer).close();
                    return;
                }
                boolean addLock = true;
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock = locksList.nextElement();
                    if (!currentLock.path.equals(lock.path)) continue;
                    if (currentLock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    if (lock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    currentLock.tokens.addElement(lockToken);
                    lock = currentLock;
                    addLock = false;
                }
                if (addLock) {
                    lock.tokens.addElement(lockToken);
                    this.collectionLocks.addElement(lock);
                }
            } else {
                LockInfo presentLock = this.resourceLocks.get(lock.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock.isExclusive()) {
                        resp.sendError(412);
                        return;
                    }
                    presentLock.tokens.addElement(lockToken);
                    lock = presentLock;
                } else {
                    lock.tokens.addElement(lockToken);
                    this.resourceLocks.put(lock.path, lock);
                    if (!resource.exists()) {
                        int slash = lock.path.lastIndexOf(47);
                        String parentPath = lock.path.substring(0, slash);
                        Vector<String> lockNulls = this.lockNullResources.get(parentPath);
                        if (lockNulls == null) {
                            lockNulls = new Vector();
                            this.lockNullResources.put(parentPath, lockNulls);
                        }
                        lockNulls.addElement(lock.path);
                    }
                    resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
                }
            }
        }
        if (lockRequestType) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            LockInfo toRenew = this.resourceLocks.get(path);
            Enumeration<String> tokenList = null;
            if (toRenew != null) {
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
            Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
            while (collectionLocksList.hasMoreElements()) {
                toRenew = collectionLocksList.nextElement();
                if (!path.equals(toRenew.path)) continue;
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        generatedXML.writeElement("D", "lockdiscovery", 0);
        lock.toXML(generatedXML);
        generatedXML.writeElement("D", "lockdiscovery", 1);
        generatedXML.writeElement("D", "prop", 1);
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null) {
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
            }
            if (lock.tokens.isEmpty()) {
                this.resourceLocks.remove(path);
                this.lockNullResources.remove(path);
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (!path.equals(lock.path)) continue;
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
                break;
            }
            if (!lock.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lock);
            this.lockNullResources.remove(path);
        }
        resp.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path, String ifHeader) {
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null && lock.hasExpired()) {
            this.resourceLocks.remove(path);
        } else if (lock != null) {
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
                break;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (lock.hasExpired()) {
                this.collectionLocks.removeElement(lock);
                continue;
            }
            if (!path.startsWith(lock.path)) continue;
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
                break;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Hashtable<String, Integer> errorList;
        boolean result;
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return false;
        }
        int protocolIndex = (destinationPath = UDecoder.URLDecode((String)destinationPath, (String)"UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf(47, protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(58)) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf(47);
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = RequestUtil.normalize((String)destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        if (this.debug > 0) {
            this.log("Dest path :" + destinationPath);
        }
        if (this.isSpecialPath(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        String path = this.getRelativePath(req);
        if (destinationPath.equals(path)) {
            resp.sendError(403);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        WebResource destination = this.resources.getResource(destinationPath);
        if (overwrite) {
            if (destination.exists()) {
                if (!this.deleteResource(destinationPath, req, resp, true)) {
                    return false;
                }
            } else {
                resp.setStatus(201);
            }
        } else if (destination.exists()) {
            resp.sendError(412);
            return false;
        }
        if (!(result = this.copyResource(errorList = new Hashtable<String, Integer>(), path, destinationPath)) || !errorList.isEmpty()) {
            if (errorList.size() == 1) {
                resp.sendError(errorList.elements().nextElement().intValue());
            } else {
                this.sendReport(req, resp, errorList);
            }
            return false;
        }
        if (destination.exists()) {
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
        this.lockNullResources.remove(destinationPath);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(Hashtable<String, Integer> errorList, String source, String dest) {
        String parent;
        WebResource parentResource23322;
        int lastSlash;
        WebResource sourceResource;
        if (this.debug > 1) {
            this.log("Copy: " + source + " To: " + dest);
        }
        if ((sourceResource = this.resources.getResource(source)).isDirectory()) {
            String[] entries;
            WebResource destResource;
            if (!this.resources.mkdir(dest) && !(destResource = this.resources.getResource(dest)).isDirectory()) {
                errorList.put(dest, 409);
                return false;
            }
            String[] arr$ = entries = this.resources.list(source);
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                String entry = arr$[i$];
                String childDest = dest;
                if (!childDest.equals("/")) {
                    childDest = childDest + "/";
                }
                childDest = childDest + entry;
                String childSrc = source;
                if (!childSrc.equals("/")) {
                    childSrc = childSrc + "/";
                }
                childSrc = childSrc + entry;
                this.copyResource(errorList, childSrc, childDest);
                ++i$;
            }
            return true;
        }
        if (!sourceResource.isFile()) {
            errorList.put(source, 500);
            return false;
        }
        WebResource destResource = this.resources.getResource(dest);
        if (!(destResource.exists() || destResource.getWebappPath().endsWith("/") || (lastSlash = destResource.getWebappPath().lastIndexOf(47)) <= 0 || (parentResource23322 = this.resources.getResource(parent = destResource.getWebappPath().substring(0, lastSlash))).isDirectory())) {
            errorList.put(source, 409);
            return false;
        }
        try (InputStream is = sourceResource.getInputStream();){
            if (this.resources.write(dest, is, false)) return true;
            errorList.put(source, 500);
            boolean parentResource23322 = false;
            return parentResource23322;
        }
        catch (IOException e) {
            this.log(sm.getString("webdavservlet.inputstreamclosefail", new Object[]{source}), e);
            return true;
        }
    }

    private boolean deleteResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = this.getRelativePath(req);
        return this.deleteResource(path, req, resp, true);
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp, boolean setStatus) throws IOException {
        String lockTokenHeader;
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path, ifHeader + lockTokenHeader)) {
            resp.sendError(423);
            return false;
        }
        WebResource resource = this.resources.getResource(path);
        if (!resource.exists()) {
            resp.sendError(404);
            return false;
        }
        if (!resource.isDirectory()) {
            if (!resource.delete()) {
                resp.sendError(500);
                return false;
            }
        } else {
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            this.deleteCollection(req, path, errorList);
            if (!resource.delete()) {
                errorList.put(path, 500);
            }
            if (!errorList.isEmpty()) {
                this.sendReport(req, resp, errorList);
                return false;
            }
        }
        if (setStatus) {
            resp.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest req, String path, Hashtable<String, Integer> errorList) {
        String[] entries;
        String lockTokenHeader;
        if (this.debug > 1) {
            this.log("Delete:" + path);
        }
        if (this.isSpecialPath(path)) {
            errorList.put(path, 403);
            return;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        for (String entry : entries = this.resources.list(path)) {
            String childName = path;
            if (!childName.equals("/")) {
                childName = childName + "/";
            }
            if (this.isLocked(childName = childName + entry, ifHeader + lockTokenHeader)) {
                errorList.put(childName, 423);
                continue;
            }
            WebResource childResource = this.resources.getResource(childName);
            if (childResource.isDirectory()) {
                this.deleteCollection(req, childName, errorList);
            }
            if (childResource.delete() || childResource.isDirectory()) continue;
            errorList.put(childName, 500);
        }
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable<String, Integer> errorList) throws IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        Enumeration<String> pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = pathList.nextElement();
            int errorCode = errorList.get(errorPath);
            generatedXML.writeElement("D", "response", 0);
            generatedXML.writeElement("D", "href", 0);
            String toAppend = errorPath.substring(relativePath.length());
            if (!toAppend.startsWith("/")) {
                toAppend = "/" + toAppend;
            }
            generatedXML.writeText(absoluteUri + toAppend);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
            generatedXML.writeElement("D", "status", 1);
            generatedXML.writeElement("D", "response", 1);
        }
        generatedXML.writeElement("D", "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (this.isSpecialPath(path)) {
            return;
        }
        WebResource resource = this.resources.getResource(path);
        if (!resource.exists()) {
            return;
        }
        String href = req.getContextPath() + req.getServletPath();
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (resource.isDirectory() && !href.endsWith("/")) {
            href = href + "/";
        }
        String rewrittenUrl = this.rewriteUrl(href);
        this.generatePropFindResponse(generatedXML, rewrittenUrl, path, type, propertiesVector, resource.isFile(), false, resource.getCreation(), resource.getLastModified(), resource.getContentLength(), this.getServletContext().getMimeType(resource.getName()), resource.getETag());
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (this.isSpecialPath(path)) {
            return;
        }
        LockInfo lock = this.resourceLocks.get(path);
        if (lock == null) {
            return;
        }
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        String toAppend = path.substring(relativePath.length());
        if (!toAppend.startsWith("/")) {
            toAppend = "/" + toAppend;
        }
        String rewrittenUrl = this.rewriteUrl(RequestUtil.normalize((String)(absoluteUri + toAppend)));
        this.generatePropFindResponse(generatedXML, rewrittenUrl, path, type, propertiesVector, true, true, lock.creationDate.getTime(), lock.creationDate.getTime(), 0L, "", "");
    }

    private void generatePropFindResponse(XMLWriter generatedXML, String rewrittenUrl, String path, int propFindType, Vector<String> propertiesVector, boolean isFile, boolean isLockNull, long created, long lastModified, long contentLength, String contentType, String eTag) {
        generatedXML.writeElement("D", "response", 0);
        String status = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        generatedXML.writeElement("D", "href", 0);
        generatedXML.writeText(rewrittenUrl);
        generatedXML.writeElement("D", "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (propFindType) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(created));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                if (isFile) {
                    generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)lastModified, null));
                    generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                    if (contentType != null) {
                        generatedXML.writeProperty("D", "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty("D", "getetag", eTag);
                    if (isLockNull) {
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "lock-null", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                    } else {
                        generatedXML.writeElement("D", "resourcetype", 2);
                    }
                } else {
                    generatedXML.writeElement("D", "resourcetype", 0);
                    generatedXML.writeElement("D", "collection", 2);
                    generatedXML.writeElement("D", "resourcetype", 1);
                }
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                if (isFile) {
                    generatedXML.writeElement("D", "getcontentlanguage", 2);
                    generatedXML.writeElement("D", "getcontentlength", 2);
                    generatedXML.writeElement("D", "getcontenttype", 2);
                    generatedXML.writeElement("D", "getetag", 2);
                    generatedXML.writeElement("D", "getlastmodified", 2);
                }
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(created));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (isFile) {
                            generatedXML.writeElement("D", "getcontentlanguage", 2);
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontentlength", Long.toString(contentLength));
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getcontenttype", contentType);
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getetag", eTag);
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (isFile) {
                            generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)lastModified, null));
                            continue;
                        }
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (isFile) {
                            if (isLockNull) {
                                generatedXML.writeElement("D", "resourcetype", 0);
                                generatedXML.writeElement("D", "lock-null", 2);
                                generatedXML.writeElement("D", "resourcetype", 1);
                                continue;
                            }
                            generatedXML.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "collection", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement("D", (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String path, XMLWriter generatedXML) {
        LockInfo resourceLock = this.resourceLocks.get(path);
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement("D", "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        while (collectionLocksList.hasMoreElements()) {
            LockInfo currentLock = collectionLocksList.nextElement();
            if (!path.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement("D", "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        return creationDateFormat.format(new Date(creationDate));
    }

    private StringBuilder determineMethodsAllowed(HttpServletRequest req) {
        StringBuilder methodsAllowed = new StringBuilder();
        WebResource resource = this.resources.getResource(this.getRelativePath(req));
        if (!resource.exists()) {
            methodsAllowed.append("OPTIONS, MKCOL, PUT, LOCK");
            return methodsAllowed;
        }
        methodsAllowed.append("OPTIONS, GET, HEAD, POST, DELETE, TRACE");
        methodsAllowed.append(", PROPPATCH, COPY, MOVE, LOCK, UNLOCK");
        if (this.listings) {
            methodsAllowed.append(", PROPFIND");
        }
        if (resource.isFile()) {
            methodsAllowed.append(", PUT");
        }
        return methodsAllowed;
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        public WebdavResolver(ServletContext theContext) {
            this.context = theContext;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.enternalEntityIgnored", new Object[]{publicId, systemId}));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    private class LockInfo {
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector<String> tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        private LockInfo() {
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Type:");
            result.append(this.type);
            result.append("\nScope:");
            result.append(this.scope);
            result.append("\nDepth:");
            result.append(this.depth);
            result.append("\nOwner:");
            result.append(this.owner);
            result.append("\nExpiration:");
            result.append(FastHttpDateFormat.formatDate((long)this.expiresAt, null));
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                result.append("\nToken:");
                result.append(tokensList.nextElement());
            }
            result.append("\n");
            return result.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter generatedXML) {
            generatedXML.writeElement("D", "activelock", 0);
            generatedXML.writeElement("D", "locktype", 0);
            generatedXML.writeElement("D", this.type, 2);
            generatedXML.writeElement("D", "locktype", 1);
            generatedXML.writeElement("D", "lockscope", 0);
            generatedXML.writeElement("D", this.scope, 2);
            generatedXML.writeElement("D", "lockscope", 1);
            generatedXML.writeElement("D", "depth", 0);
            if (this.depth == WebdavServlet.this.maxDepth) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement("D", "depth", 1);
            generatedXML.writeElement("D", "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement("D", "owner", 1);
            generatedXML.writeElement("D", "timeout", 0);
            long timeout = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout);
            generatedXML.writeElement("D", "timeout", 1);
            generatedXML.writeElement("D", "locktoken", 0);
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                generatedXML.writeElement("D", "href", 0);
                generatedXML.writeText("opaquelocktoken:" + tokensList.nextElement());
                generatedXML.writeElement("D", "href", 1);
            }
            generatedXML.writeElement("D", "locktoken", 1);
            generatedXML.writeElement("D", "activelock", 1);
        }
    }
}

