/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.BlockDiagramMessages;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class StyleUtil {
    private static final IColorConstant SHAPE_FOREGOUND = new ColorConstant(0, 0, 0);
    private static final IColorConstant SHAPE_BACKGROUND = new ColorConstant(255, 255, 255);
    private static String DEFAULT_FONT = BlockDiagramMessages.FMCAddFeature_FontType;
    public static final String SHAPE = "Shape";
    public static final String CONNECTION = "Connection";

    public static Style getStyle(Diagram d) {
        return StyleUtil.getStyle(d, SHAPE);
    }

    public static Style getStyle(Diagram d, String styleId) {
        Style style = StyleUtil.findStyle(d, styleId);
        IGaService gaService = Graphiti.getGaService();
        if (style == null) {
            style = gaService.createStyle((StyleContainer)d, styleId);
            if (SHAPE.equals(styleId)) {
                style.setLineWidth(Integer.valueOf(3));
                style.setForeground(gaService.manageColor(d, SHAPE_FOREGOUND));
                style.setBackground(gaService.manageColor(d, SHAPE_BACKGROUND));
                style.setFont(gaService.manageFont(d, DEFAULT_FONT, 10, false, false));
            } else if (CONNECTION.equals(styleId)) {
                style.setFont(gaService.manageFont(d, DEFAULT_FONT, 8, false, false));
            }
        }
        return style;
    }

    public static Style findStyle(Diagram d, String styleId) {
        EList styles = d.getStyles();
        if (styles != null) {
            for (Style style : styles) {
                if (!styleId.equals(style.getId())) continue;
                return style;
            }
        }
        return null;
    }
}

