/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RotatableNode;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class RotateCustomFeature
extends FMCCustomFeature {
    private boolean hasDoneChanges = false;

    public RotateCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider, "Transform");
    }

    public String getName() {
        return "Rotate clockwise";
    }

    public String getImageId() {
        return "org.eclipse.fmc.Rotate_16";
    }

    public String getDescription() {
        return "Rotate the element by 90 degrees clockwise";
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && context.getPictogramElements()[0] instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
            FMCElementAlgorithm ea = FMCElementAlgorithmFactory.getInstance().getShape((PictogramElement)container);
            if (ea instanceof RotatableNode) {
                return true;
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            ContainerShape firstLevelContainer = (ContainerShape)context.getPictogramElements()[0];
            FMCElementAlgorithm ea = FMCElementAlgorithmFactory.getInstance().getShape((PictogramElement)firstLevelContainer);
            GraphicsAlgorithm invisibleGa = firstLevelContainer.getGraphicsAlgorithm();
            if (ea instanceof RotatableNode) {
                ((RotatableNode)((Object)ea)).rotate90Right(invisibleGa);
                this.hasDoneChanges = true;
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

