/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RotatableNode;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class FlipHorizontallyCustomFeature
extends FMCCustomFeature {
    public FlipHorizontallyCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider, "Transform");
    }

    public String getName() {
        return "Flip horizontally";
    }

    public String getImageId() {
        return "org.eclipse.fmc.FlipHorizontally_16";
    }

    public String getDescription() {
        return "Flip element horizontally";
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && context.getPictogramElements()[0] instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
            FMCElementAlgorithm ea = FMCElementAlgorithmFactory.getInstance().getShape((PictogramElement)container);
            if (ea instanceof RotatableNode) {
                return true;
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
            FMCElementAlgorithm ea = FMCElementAlgorithmFactory.getInstance().getShape((PictogramElement)container);
            GraphicsAlgorithm invisibleGa = container.getGraphicsAlgorithm();
            if (ea instanceof RotatableNode) {
                ((RotatableNode)((Object)ea)).flipHorizontally(invisibleGa);
            }
        }
    }
}

