/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class TextAddFeature
extends AbstractAddShapeFeature {
    private final String text;
    private final boolean linked;

    public TextAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
        this.linked = true;
        this.text = "A Text";
    }

    public TextAddFeature(IFeatureProvider featureProvider, boolean linked) {
        super(featureProvider);
        this.linked = linked;
        this.text = "A Text";
    }

    public TextAddFeature(IFeatureProvider featureProvider, String text) {
        super(featureProvider);
        this.linked = true;
        this.text = text;
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        IPeService pe = Graphiti.getPeService();
        IGaService ga = Graphiti.getGaService();
        Shape s = pe.createShape(context.getTargetContainer(), true);
        MultiText txt = ga.createMultiText((GraphicsAlgorithmContainer)s, this.text);
        txt.setForeground(this.manageColor(0, 0, 0));
        txt.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        txt.setFont(ga.manageFont(this.getDiagram(), "Arial", 10, false, false));
        ga.setLocationAndSize((GraphicsAlgorithm)txt, context.getX(), context.getY(), 50, 20);
        if (this.linked) {
            this.link((PictogramElement)s, context.getNewObject());
        }
        return s;
    }
}

