/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AbstractRectangleAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.StorageAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class RectangleStorageAlgorithm
extends AbstractRectangleAlgorithm
implements StorageAlgorithm {
    public static final int STORAGE_MINIMUM_WIDTH = 15;
    public static final int STORAGE_MINIMUM_HEIGHT = 15;
    public static final int STORAGE_DEFAULT_WIDTH = 60;
    public static final int STORAGE_DEFAULT_HEIGHT = 40;
    public static final int STORAGE_DEFAULT_LINEWIDTH = 3;

    @Override
    public GraphicsAlgorithm createGraphics(Diagram diagram, GraphicsAlgorithmContainer container, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        int cornerWidth = w < h ? w : h;
        RoundedRectangle rec = this.ga.createRoundedRectangle(container, cornerWidth, cornerWidth);
        this.ga.setLocationAndSize((GraphicsAlgorithm)rec, x, y, w, h);
        rec.setLineWidth(Integer.valueOf(3));
        rec.setTransparency(null);
        rec.setStyle(StyleUtil.getStyle(diagram, "Shape"));
        if (container instanceof GraphicsAlgorithm) {
            ContainerShape containerShape = this.getContainerShape((GraphicsAlgorithm)rec);
            this.pe.createChopboxAnchor((AnchorContainer)containerShape);
            this.createBoxAnchorSet((Shape)containerShape);
        }
        return rec;
    }

    @Override
    public int getMinimumHeight() {
        return 15;
    }

    @Override
    public int getMinimumWidth() {
        return 15;
    }

    @Override
    public int getDefaultHeight() {
        return 40;
    }

    @Override
    public int getDefaultWidth() {
        return 60;
    }

    @Override
    public int getDefaultLineWidth() {
        return 3;
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        ContainerShape container = this.getContainerShape(algorithm);
        this.ga.setLocationAndSize(algorithm, x, y, width, height);
        RoundedRectangle rec = (RoundedRectangle)algorithm;
        int cornerWidth = width < height ? width : height;
        rec.setCornerHeight(cornerWidth);
        rec.setCornerWidth(cornerWidth);
        this.relocateText(algorithm);
        this.createBoxAnchorSet((Shape)container);
    }

    @Override
    protected void addBoxAnchorSet(Shape shape) {
        GraphicsAlgorithm firstLevelRectangle = shape.getGraphicsAlgorithm();
        GraphicsAlgorithm secondLevelRectangle = (GraphicsAlgorithm)firstLevelRectangle.getGraphicsAlgorithmChildren().get(0);
        double offsetMultiInstance = 0.0;
        if (firstLevelRectangle.getWidth() != secondLevelRectangle.getWidth()) {
            FMCUtil.removeObsoleteAnchors(shape);
            offsetMultiInstance = 5.0;
        }
        if (secondLevelRectangle.getWidth() > secondLevelRectangle.getHeight()) {
            int radius = secondLevelRectangle.getHeight() / 2;
            int numOfAnchorsForStraightSections = (secondLevelRectangle.getWidth() - 2 * radius) / 8;
            double relativeOffsetXForA = ((double)radius + offsetMultiInstance) / (double)firstLevelRectangle.getWidth();
            double relativeOffsetXForC = (double)radius / (double)firstLevelRectangle.getWidth();
            double relativeOffsetYForA = 0.0;
            double relativeOffsetYForC = 1.0 - 8.0 / (double)firstLevelRectangle.getHeight();
            double gapForStraightSections = (1.0 - relativeOffsetXForA - relativeOffsetXForC) / (double)numOfAnchorsForStraightSections;
            int i = 0;
            while (i <= numOfAnchorsForStraightSections) {
                this.createBoxAnchor(shape, relativeOffsetXForA + (double)i * gapForStraightSections, relativeOffsetYForA, 8, 8);
                this.createBoxAnchor(shape, relativeOffsetXForC + (double)i * gapForStraightSections, relativeOffsetYForC, 8, 8);
                ++i;
            }
            double relativeOffsetXForB = ((double)firstLevelRectangle.getWidth() - 8.0) / (double)firstLevelRectangle.getWidth();
            double relativeOffsetXForD = 0.0;
            double relativeOffsetYForB = ((double)radius - 4.0) / (double)firstLevelRectangle.getHeight();
            double relativeOffsetYForD = ((double)radius - 4.0 + offsetMultiInstance) / (double)firstLevelRectangle.getHeight();
            this.createBoxAnchor(shape, relativeOffsetXForD, relativeOffsetYForD, 8, 8);
            this.createBoxAnchor(shape, relativeOffsetXForB, relativeOffsetYForB, 8, 8);
        } else {
            int radius = secondLevelRectangle.getWidth() / 2;
            int numOfAnchorsForStraightSections = (secondLevelRectangle.getHeight() - 2 * radius) / 8;
            double relativeOffsetYForB = (double)radius / (double)firstLevelRectangle.getHeight();
            double relativeOffsetYForD = ((double)radius + offsetMultiInstance) / (double)firstLevelRectangle.getHeight();
            double relativeOffsetXForB = 1.0 - 8.0 / (double)firstLevelRectangle.getWidth();
            double relativeOffsetXForD = 0.0;
            double gapForStraightSections = (1.0 - relativeOffsetYForB - relativeOffsetYForD) / (double)numOfAnchorsForStraightSections;
            int i = 0;
            while (i <= numOfAnchorsForStraightSections) {
                this.createBoxAnchor(shape, relativeOffsetXForD, relativeOffsetYForD + (double)i * gapForStraightSections, 8, 8);
                this.createBoxAnchor(shape, relativeOffsetXForB, relativeOffsetYForB + (double)i * gapForStraightSections, 8, 8);
                ++i;
            }
            double relativeOffsetXForA = ((double)radius - 4.0 + offsetMultiInstance) / (double)firstLevelRectangle.getWidth();
            double relativeOffsetXForC = ((double)radius - 4.0) / (double)firstLevelRectangle.getWidth();
            double relativeOffsetYForA = 0.0;
            double relativeOffsetYForC = ((double)firstLevelRectangle.getHeight() - 8.0) / (double)firstLevelRectangle.getHeight();
            this.createBoxAnchor(shape, relativeOffsetXForA, relativeOffsetYForA, 8, 8);
            this.createBoxAnchor(shape, relativeOffsetXForC, relativeOffsetYForC, 8, 8);
        }
    }
}

