/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AbstractLPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.UPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AbstractUPolygonAlgorithm
extends AbstractLPolygonAlgorithm
implements UPolygonAlgorithm {
    @Override
    public List<Point> getInitialPoints(int x, int y, int width, int height) {
        int outerCornerSize = this.hasRoundedCorners() ? 15 : 0;
        int innerCornerSize = this.hasRoundedCorners() ? outerCornerSize * 2 / 3 : 0;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.ga.createPoint(x, y, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x, y + height, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width, y + height, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width, y, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width - 30, y, outerCornerSize, outerCornerSize));
        points.add(this.ga.createPoint(x + width - 30, y + height - 30, innerCornerSize, innerCornerSize));
        points.add(this.ga.createPoint(x + 30, y + height - 30, innerCornerSize, innerCornerSize));
        points.add(this.ga.createPoint(x + 30, y, outerCornerSize, outerCornerSize));
        return points;
    }

    @Override
    public void resizeLeftPart(Polygon polygon, int size) {
        int oldSize = this.getLeftPartSize(polygon);
        int sizeDif = size - oldSize;
        EList points = polygon.getPoints();
        if (sizeDif != 0) {
            switch (this.getAngle((GraphicsAlgorithm)polygon)) {
                case 90: {
                    ((Point)points.get(6)).setY(((Point)points.get(6)).getY() + sizeDif);
                    ((Point)points.get(7)).setY(((Point)points.get(7)).getY() + sizeDif);
                    break;
                }
                case 180: {
                    ((Point)points.get(6)).setX(((Point)points.get(6)).getX() - sizeDif);
                    ((Point)points.get(7)).setX(((Point)points.get(7)).getX() - sizeDif);
                    break;
                }
                case 270: {
                    ((Point)points.get(6)).setY(((Point)points.get(6)).getY() - sizeDif);
                    ((Point)points.get(7)).setY(((Point)points.get(7)).getY() - sizeDif);
                    break;
                }
                default: {
                    ((Point)points.get(6)).setX(((Point)points.get(6)).getX() + sizeDif);
                    ((Point)points.get(7)).setX(((Point)points.get(7)).getX() + sizeDif);
                }
            }
        }
        if (this.hasRoundedCorners()) {
            int leftTopCornerSize = this.getLeftPartTopCornerSize(polygon);
            int leftBottomCornerSize = this.getLeftPartBottomCornerSize(polygon);
            ((Point)points.get(0)).setBefore(leftTopCornerSize);
            ((Point)points.get(0)).setAfter(leftTopCornerSize);
            ((Point)points.get(1)).setBefore(leftBottomCornerSize);
            ((Point)points.get(6)).setAfter(leftBottomCornerSize);
            ((Point)points.get(7)).setBefore(leftTopCornerSize);
            ((Point)points.get(7)).setAfter(leftTopCornerSize);
        }
        this.relocateText((GraphicsAlgorithm)polygon);
        EList graphicsAlgorithmChildren = polygon.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.resizeLeftPart((Polygon)graphicsAlgorithmChildren.get(i), size);
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape((GraphicsAlgorithm)polygon));
            }
            ++i;
        }
    }

    @Override
    public int getLeftPartSize(Polygon polygon) {
        EList points = polygon.getPoints();
        if (this.isFlattened(polygon)) {
            return Math.abs(((Point)points.get(7)).getY() - ((Point)points.get(0)).getY());
        }
        return Math.abs(((Point)points.get(7)).getX() - ((Point)points.get(0)).getX());
    }

    @Override
    public void resizeBottomPart(Polygon polygon, int size) {
        int oldSize = this.getBottomPartSize(polygon);
        int sizeDif = this.isFlipped((GraphicsAlgorithm)polygon) ? oldSize - size : size - oldSize;
        EList points = polygon.getPoints();
        if (sizeDif != 0) {
            switch (this.getAngle((GraphicsAlgorithm)polygon)) {
                case 90: {
                    ((Point)points.get(6)).setX(((Point)points.get(6)).getX() + sizeDif);
                    ((Point)points.get(5)).setX(((Point)points.get(5)).getX() + sizeDif);
                    break;
                }
                case 180: {
                    ((Point)points.get(6)).setY(((Point)points.get(6)).getY() + sizeDif);
                    ((Point)points.get(5)).setY(((Point)points.get(5)).getY() + sizeDif);
                    break;
                }
                case 270: {
                    ((Point)points.get(6)).setX(((Point)points.get(6)).getX() - sizeDif);
                    ((Point)points.get(5)).setX(((Point)points.get(5)).getX() - sizeDif);
                    break;
                }
                default: {
                    ((Point)points.get(6)).setY(((Point)points.get(6)).getY() - sizeDif);
                    ((Point)points.get(5)).setY(((Point)points.get(5)).getY() - sizeDif);
                }
            }
        }
        if (this.hasRoundedCorners()) {
            int bottomLeftCornerSize = this.getBottomPartLeftCornerSize(polygon);
            int bottomRightCornerSize = this.getBottomPartRightCornerSize(polygon);
            ((Point)points.get(1)).setAfter(bottomLeftCornerSize);
            ((Point)points.get(2)).setBefore(bottomRightCornerSize);
            ((Point)points.get(5)).setAfter(bottomRightCornerSize);
            ((Point)points.get(6)).setBefore(bottomLeftCornerSize);
        }
        this.relocateText((GraphicsAlgorithm)polygon);
        EList graphicsAlgorithmChildren = polygon.getGraphicsAlgorithmChildren();
        int i = 0;
        while (i < graphicsAlgorithmChildren.size()) {
            if (graphicsAlgorithmChildren.get(i) instanceof Polygon) {
                this.resizeBottomPart((Polygon)graphicsAlgorithmChildren.get(i), size);
            }
            if (i == graphicsAlgorithmChildren.size() - 1) {
                this.createBoxAnchorSet((Shape)this.getContainerShape((GraphicsAlgorithm)polygon));
            }
            ++i;
        }
    }

    @Override
    public int getLeftPartTopCornerSize(Polygon polygon) {
        return this.getLeftPartSize(polygon) / 2;
    }

    @Override
    public int getLeftPartBottomCornerSize(Polygon polygon) {
        return this.getLeftPartTopCornerSize(polygon);
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        Polygon polygon = (Polygon)algorithm;
        int angle = this.getAngle((GraphicsAlgorithm)polygon);
        int[] resizeX = new int[4];
        int[] resizeY = new int[4];
        if (this.isFlipped((GraphicsAlgorithm)polygon)) {
            switch (angle) {
                case 90: {
                    resizeX[0] = 1;
                    resizeX[1] = 2;
                    resizeX[2] = 5;
                    resizeX[3] = 6;
                    resizeY[0] = 2;
                    resizeY[1] = 3;
                    resizeY[2] = 4;
                    resizeY[3] = 5;
                    break;
                }
                case 180: {
                    resizeX[0] = 0;
                    resizeX[1] = 1;
                    resizeX[2] = 6;
                    resizeX[3] = 7;
                    resizeY[0] = 1;
                    resizeY[1] = 2;
                    resizeY[2] = 5;
                    resizeY[3] = 6;
                    break;
                }
                case 270: {
                    resizeX[0] = 0;
                    resizeX[1] = 3;
                    resizeX[2] = 4;
                    resizeX[3] = 7;
                    resizeY[0] = 0;
                    resizeY[1] = 1;
                    resizeY[2] = 6;
                    resizeY[3] = 7;
                    break;
                }
                default: {
                    resizeX[0] = 2;
                    resizeX[1] = 3;
                    resizeX[2] = 4;
                    resizeX[3] = 5;
                    resizeY[0] = 0;
                    resizeY[1] = 3;
                    resizeY[2] = 4;
                    resizeY[3] = 7;
                    break;
                }
            }
        } else {
            switch (angle) {
                case 90: {
                    resizeX[0] = 0;
                    resizeX[1] = 3;
                    resizeX[2] = 4;
                    resizeX[3] = 7;
                    resizeY[0] = 2;
                    resizeY[1] = 3;
                    resizeY[2] = 4;
                    resizeY[3] = 5;
                    break;
                }
                case 180: {
                    resizeX[0] = 0;
                    resizeX[1] = 1;
                    resizeX[2] = 6;
                    resizeX[3] = 7;
                    resizeY[0] = 0;
                    resizeY[1] = 3;
                    resizeY[2] = 4;
                    resizeY[3] = 7;
                    break;
                }
                case 270: {
                    resizeX[0] = 1;
                    resizeX[1] = 2;
                    resizeX[2] = 5;
                    resizeX[3] = 6;
                    resizeY[0] = 0;
                    resizeY[1] = 1;
                    resizeY[2] = 6;
                    resizeY[3] = 7;
                    break;
                }
                default: {
                    resizeX[0] = 2;
                    resizeX[1] = 3;
                    resizeX[2] = 4;
                    resizeX[3] = 5;
                    resizeY[0] = 1;
                    resizeY[1] = 2;
                    resizeY[2] = 5;
                    resizeY[3] = 6;
                }
            }
        }
        int oldHeight = polygon.getHeight();
        int oldWidth = polygon.getWidth();
        int heightDif = height - oldHeight;
        int widthDif = width - oldWidth;
        EList points = polygon.getPoints();
        int i = 0;
        while (i < resizeX.length) {
            ((Point)points.get(resizeX[i])).setX(((Point)points.get(resizeX[i])).getX() + widthDif);
            ++i;
        }
        i = 0;
        while (i < resizeY.length) {
            ((Point)points.get(resizeY[i])).setY(((Point)points.get(resizeY[i])).getY() + heightDif);
            ++i;
        }
        if (this.hasRoundedCorners()) {
            int leftTopCornerSize = this.getLeftPartTopCornerSize(polygon);
            int leftBottomCornerSize = this.getLeftPartBottomCornerSize(polygon);
            int rightTopCornerSize = this.getRightPartTopCornerSize(polygon);
            int rightBottomCornerSize = this.getRightPartBottomCornerSize(polygon);
            int bottomLeftCornerSize = this.getBottomPartLeftCornerSize(polygon);
            int bottomRightCornerSize = this.getBottomPartRightCornerSize(polygon);
            ((Point)points.get(0)).setBefore(leftTopCornerSize);
            ((Point)points.get(0)).setAfter(leftTopCornerSize);
            ((Point)points.get(1)).setBefore(leftBottomCornerSize);
            ((Point)points.get(1)).setAfter(bottomLeftCornerSize);
            ((Point)points.get(2)).setBefore(bottomRightCornerSize);
            ((Point)points.get(2)).setAfter(rightBottomCornerSize);
            ((Point)points.get(3)).setBefore(rightTopCornerSize);
            ((Point)points.get(3)).setAfter(rightTopCornerSize);
            ((Point)points.get(4)).setBefore(rightTopCornerSize);
            ((Point)points.get(4)).setAfter(rightTopCornerSize);
            ((Point)points.get(5)).setBefore(rightBottomCornerSize);
            ((Point)points.get(5)).setAfter(bottomRightCornerSize);
            ((Point)points.get(6)).setBefore(bottomLeftCornerSize);
            ((Point)points.get(6)).setAfter(leftBottomCornerSize);
            ((Point)points.get(7)).setBefore(leftTopCornerSize);
            ((Point)points.get(7)).setAfter(leftTopCornerSize);
        }
        this.ga.setLocationAndSize((GraphicsAlgorithm)polygon, x, y, width, height);
        this.relocateText((GraphicsAlgorithm)polygon);
        ContainerShape container = this.getContainerShape((GraphicsAlgorithm)polygon);
        this.createBoxAnchorSet((Shape)container);
        this.synchronizeFirstLevelShape(container);
    }

    @Override
    public void relocateText(GraphicsAlgorithm graphicsAlgorithm) {
        Polygon polygon = (Polygon)graphicsAlgorithm;
        MultiText text = this.getText(graphicsAlgorithm);
        if (text != null) {
            int textContainingPartSize;
            int multipleOffset = 0;
            if (this.isMultipleInstances(this.getContainerShape(graphicsAlgorithm))) {
                multipleOffset = 5;
            }
            int angle = this.getAngle(graphicsAlgorithm);
            boolean isOnTop = false;
            switch (angle) {
                case 90: {
                    textContainingPartSize = this.getRightPartSize(polygon);
                    break;
                }
                case 270: {
                    textContainingPartSize = this.getLeftPartSize(polygon);
                    break;
                }
                default: {
                    textContainingPartSize = this.getBottomPartSize(polygon);
                }
            }
            if (this.isFlipped(graphicsAlgorithm) && angle == 0 || !this.isFlipped(graphicsAlgorithm) && angle == 180) {
                isOnTop = true;
            }
            int x = this.textMargin;
            int width = graphicsAlgorithm.getWidth() - 2 * this.textMargin - multipleOffset;
            int y = (isOnTop ? this.textMargin : graphicsAlgorithm.getHeight() - textContainingPartSize + this.textMargin) + multipleOffset;
            int height = textContainingPartSize - 2 * this.textMargin - multipleOffset;
            this.ga.setLocationAndSize((GraphicsAlgorithm)text, x, y, width, height);
        }
    }

    @Override
    protected void addBoxAnchorSet(Shape shape) {
        GraphicsAlgorithm firstLevelPolygon = shape.getGraphicsAlgorithm();
        Polygon secondLevelPolygon = (Polygon)firstLevelPolygon.getGraphicsAlgorithmChildren().get(0);
        int numSides = 8;
        int lineWidth = this.getDefaultLineWidth();
        Point[] point = new Point[numSides];
        int i = 0;
        while (i < point.length) {
            point[i] = (Point)secondLevelPolygon.getPoints().get(i);
            ++i;
        }
        double offsetMultiInstance = 0.0;
        if (firstLevelPolygon.getWidth() != secondLevelPolygon.getWidth()) {
            FMCUtil.removeObsoleteAnchors(shape);
            offsetMultiInstance = 5.0;
        }
        int[] length = new int[numSides];
        length[0] = Math.abs(this.isFlattened(secondLevelPolygon) ? point[2].getX() - point[3].getX() : point[2].getY() - point[3].getY());
        length[1] = Math.abs(this.isFlattened(secondLevelPolygon) ? point[1].getY() - point[2].getY() : point[1].getX() - point[2].getX());
        length[2] = length[0];
        length[3] = this.getRightPartSize(secondLevelPolygon) + lineWidth;
        length[4] = length[2] - this.getBottomPartSize(secondLevelPolygon);
        length[6] = length[4];
        length[7] = this.getLeftPartSize(secondLevelPolygon) + lineWidth;
        length[5] = length[1] - length[7] - length[3];
        int[] anchoredLength = new int[numSides];
        int i2 = 0;
        while (i2 < numSides) {
            anchoredLength[i2] = Math.max(length[i2] - point[i2].getAfter() - point[(i2 + 1) % numSides].getBefore(), 8);
            ++i2;
        }
        int[] numAnchors = new int[numSides];
        double[][] gaps = new double[numSides][2];
        int i3 = 0;
        while (i3 < gaps.length) {
            int j = 0;
            while (j < gaps[i3].length) {
                gaps[i3][j] = 0.0;
                ++j;
            }
            ++i3;
        }
        double[][] offset = new double[numSides][2];
        switch (this.getAngle((GraphicsAlgorithm)secondLevelPolygon)) {
            case 90: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = 0.0;
                    offset[0][0] = offsetMultiInstance;
                    offset[1][1] = 0.0;
                    offset[1][0] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[2][1] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[2][0] = 0.0;
                    offset[3][1] = (double)(length[7] + length[5]) + offsetMultiInstance;
                    offset[3][0] = 0.0;
                    offset[4][1] = length[7] + length[5];
                    offset[4][0] = offsetMultiInstance;
                    offset[5][1] = (double)length[7] + offsetMultiInstance;
                    offset[5][0] = length[4] - lineWidth;
                    offset[6][1] = (double)length[7] + offsetMultiInstance - 8.0;
                    offset[6][0] = 0.0;
                    offset[7][1] = offsetMultiInstance;
                    offset[7][0] = 0.0;
                    if (!(offsetMultiInstance > (double)point[4].getAfter())) break;
                    anchoredLength[4] = anchoredLength[4] - (int)Math.abs(offsetMultiInstance - (double)point[4].getAfter());
                    break;
                }
                offset[0][1] = 0.0;
                offset[0][0] = offsetMultiInstance;
                offset[1][1] = offsetMultiInstance;
                offset[1][0] = 0.0;
                offset[2][1] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[2][0] = 0.0;
                offset[3][1] = length[7] + length[5];
                offset[3][0] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[4][1] = length[7] + length[5];
                offset[4][0] = (double)(length[0] - length[4]) + offsetMultiInstance;
                offset[5][1] = length[7];
                offset[5][0] = (double)(length[0] - length[4]) + offsetMultiInstance - 8.0 + (double)lineWidth;
                offset[6][1] = (double)length[7] + offsetMultiInstance - 8.0;
                offset[6][0] = (double)(length[0] - length[4]) + offsetMultiInstance;
                offset[7][1] = 0.0;
                offset[7][0] = (double)length[0] + offsetMultiInstance - 8.0;
                if (!(offsetMultiInstance > (double)point[6].getAfter())) break;
                anchoredLength[6] = anchoredLength[6] - (int)Math.abs(offsetMultiInstance - (double)point[6].getAfter());
                break;
            }
            case 180: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = 0.0;
                    offset[0][0] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[1][1] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[1][0] = 0.0;
                    offset[2][1] = offsetMultiInstance;
                    offset[2][0] = 0.0;
                    offset[3][1] = 0.0;
                    offset[3][0] = offsetMultiInstance;
                    offset[4][1] = 0.0;
                    offset[4][0] = (double)length[3] + offsetMultiInstance - 8.0;
                    offset[5][1] = length[4] - lineWidth;
                    offset[5][0] = (double)length[3] + offsetMultiInstance;
                    offset[6][1] = offsetMultiInstance;
                    offset[6][0] = length[3] + length[5];
                    offset[7][1] = 0.0;
                    offset[7][0] = (double)(length[3] + length[5]) + offsetMultiInstance;
                    break;
                }
                offset[0][1] = 0.0;
                offset[0][0] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[1][1] = 0.0;
                offset[1][0] = offsetMultiInstance;
                offset[2][1] = offsetMultiInstance;
                offset[2][0] = 0.0;
                offset[3][1] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[3][0] = 0.0;
                offset[4][1] = (double)(length[0] - length[4]) + offsetMultiInstance;
                offset[4][0] = (double)length[3] + offsetMultiInstance - 8.0;
                offset[5][1] = (double)(length[0] - length[4]) + offsetMultiInstance - 8.0 + (double)lineWidth;
                offset[5][0] = (double)length[3] + offsetMultiInstance;
                offset[6][1] = (double)(length[0] - length[4]) + offsetMultiInstance;
                offset[6][0] = length[3] + length[5];
                offset[7][1] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[7][0] = length[3] + length[5];
                if (!(offsetMultiInstance > (double)point[4].getAfter())) break;
                anchoredLength[4] = anchoredLength[4] - (int)Math.abs(offsetMultiInstance - (double)point[4].getAfter());
                break;
            }
            case 270: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[0][0] = 0.0;
                    offset[1][1] = offsetMultiInstance;
                    offset[1][0] = 0.0;
                    offset[2][1] = 0.0;
                    offset[2][0] = offsetMultiInstance;
                    offset[3][1] = 0.0;
                    offset[3][0] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[4][1] = (double)length[3] + offsetMultiInstance - 8.0;
                    offset[4][0] = (double)(length[0] - length[4]) + offsetMultiInstance;
                    offset[5][1] = (double)length[3] + offsetMultiInstance;
                    offset[5][0] = (double)(length[0] - length[4]) + offsetMultiInstance - 8.0 + (double)lineWidth;
                    offset[6][1] = length[3] + length[5];
                    offset[6][0] = (double)(length[0] - length[4]) + offsetMultiInstance;
                    offset[7][1] = length[3] + length[5];
                    offset[7][0] = (double)length[2] + offsetMultiInstance - 8.0;
                    if (offsetMultiInstance > (double)point[4].getAfter()) {
                        anchoredLength[4] = anchoredLength[4] - (int)Math.abs(offsetMultiInstance - (double)point[4].getAfter());
                    }
                    if (!(offsetMultiInstance > (double)point[5].getAfter())) break;
                    anchoredLength[5] = anchoredLength[5] - (int)Math.abs(offsetMultiInstance - (double)point[5].getAfter());
                    break;
                }
                offset[0][1] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[0][0] = 0.0;
                offset[1][1] = 0.0;
                offset[1][0] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[2][1] = 0.0;
                offset[2][0] = offsetMultiInstance;
                offset[3][1] = offsetMultiInstance;
                offset[3][0] = 0.0;
                offset[4][1] = (double)length[3] + offsetMultiInstance - 8.0;
                offset[4][0] = 0.0;
                offset[5][1] = (double)length[3] + offsetMultiInstance;
                offset[5][0] = length[4] - lineWidth;
                offset[6][1] = length[3] + length[5];
                offset[6][0] = offsetMultiInstance;
                offset[7][1] = (double)(length[3] + length[5]) + offsetMultiInstance;
                offset[7][0] = 0.0;
                if (!(offsetMultiInstance > (double)point[6].getAfter())) break;
                anchoredLength[6] = anchoredLength[6] - (int)Math.abs(offsetMultiInstance - (double)point[6].getAfter());
                break;
            }
            default: {
                if (this.isFlipped((GraphicsAlgorithm)secondLevelPolygon)) {
                    offset[0][1] = offsetMultiInstance;
                    offset[0][0] = 0.0;
                    offset[1][1] = 0.0;
                    offset[1][0] = offsetMultiInstance;
                    offset[2][1] = 0.0;
                    offset[2][0] = (double)length[1] + offsetMultiInstance - 8.0;
                    offset[3][1] = (double)length[2] + offsetMultiInstance - 8.0;
                    offset[3][0] = length[7] + length[5];
                    offset[4][1] = (double)(length[0] - length[4]) + offsetMultiInstance;
                    offset[4][0] = length[7] + length[5];
                    offset[5][1] = (double)(length[0] - length[4]) + offsetMultiInstance - 8.0 + (double)lineWidth;
                    offset[5][0] = length[7];
                    offset[6][1] = (double)(length[0] - length[4]) + offsetMultiInstance;
                    offset[6][0] = (double)(length[7] - 8) + offsetMultiInstance;
                    offset[7][1] = (double)length[0] + offsetMultiInstance - 8.0;
                    offset[7][0] = 0.0;
                    if (!(offsetMultiInstance > (double)point[6].getAfter())) break;
                    anchoredLength[6] = anchoredLength[6] - (int)(offsetMultiInstance - (double)point[6].getAfter());
                    break;
                }
                offset[0][1] = offsetMultiInstance;
                offset[0][0] = 0.0;
                offset[1][1] = (double)length[2] + offsetMultiInstance - 8.0;
                offset[1][0] = 0.0;
                offset[2][1] = 0.0;
                offset[2][0] = (double)length[1] + offsetMultiInstance - 8.0;
                offset[3][1] = 0.0;
                offset[3][0] = (double)(length[7] + length[5]) + offsetMultiInstance;
                offset[4][1] = offsetMultiInstance;
                offset[4][0] = length[7] + length[5];
                offset[5][1] = length[4] - lineWidth;
                offset[5][0] = (double)length[7] + offsetMultiInstance;
                offset[6][1] = 0.0;
                offset[6][0] = (double)length[7] + offsetMultiInstance - 8.0;
                offset[7][1] = 0.0;
                offset[7][0] = offsetMultiInstance;
                if (!(offsetMultiInstance > (double)point[5].getAfter())) break;
                anchoredLength[5] = anchoredLength[5] - (int)(offsetMultiInstance - (double)point[5].getAfter());
            }
        }
        int i4 = 0;
        while (i4 < numSides) {
            if (point[i4].getX() == point[(i4 + 1) % numSides].getX()) {
                offset[i4][1] = offset[i4][1] + (point[i4].getY() < point[(i4 + 1) % numSides].getY() ? (point[i4].getAfter() > 0 ? (double)point[i4].getAfter() - 4.0 : 0.0) : (point[(i4 + 1) % numSides].getBefore() > 0 ? (double)point[(i4 + 1) % numSides].getBefore() - 4.0 : 0.0));
            } else {
                offset[i4][0] = offset[i4][0] + (point[i4].getX() < point[(i4 + 1) % numSides].getX() ? (point[i4].getAfter() > 0 ? (double)point[i4].getAfter() - 4.0 : 0.0) : (point[(i4 + 1) % numSides].getBefore() > 0 ? (double)point[(i4 + 1) % numSides].getBefore() - 4.0 : 0.0));
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < numSides) {
            numAnchors[i4] = anchoredLength[i4] / 8;
            ++i4;
        }
        int direction = 0;
        int i5 = 0;
        while (i5 < numSides) {
            direction = this.isFlattened(secondLevelPolygon) ? i5 % 2 : (i5 + 1) % 2;
            gaps[i5][direction] = (double)anchoredLength[i5] / (double)numAnchors[i5];
            ++i5;
        }
        i5 = 0;
        while (i5 < numSides) {
            int j = 0;
            while (j < numAnchors[i5]) {
                this.createBoxAnchor(shape, (offset[i5][0] + (double)j * gaps[i5][0]) / (double)firstLevelPolygon.getWidth(), (offset[i5][1] + (double)j * gaps[i5][1]) / (double)firstLevelPolygon.getHeight(), 8, 8);
                ++j;
            }
            ++i5;
        }
    }
}

