/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.connection;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.fmc.blockdiagram.editor.algorithm.element.FMCElementAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.features.add.CommunicationChannelAddFeature;
import org.eclipse.fmc.blockdiagram.editor.features.add.ConnectionAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.CurvedConnection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class FMCConnectionAlgorithm
implements FMCElementAlgorithm {
    private static final String R_DECO = "R";
    private static final float decoPosX = 0.4f;
    private static final int[] POINTS_REQUEST_ARROW;
    private static final int[] POINTS_RESPONSE_ARROW;
    private FMCTypeChecker helper = FMCTypeCheckerFactory.getInstance();
    public static final int CHANNEL_MIN_SIZE = 16;

    static {
        int[] nArray = new int[8];
        nArray[1] = 24;
        nArray[2] = -15;
        nArray[3] = 18;
        nArray[5] = 12;
        nArray[6] = -3;
        nArray[7] = 18;
        POINTS_REQUEST_ARROW = nArray;
        POINTS_RESPONSE_ARROW = new int[]{10, 24, 25, 18, 10, 12, 13, 18};
    }

    private Set<ConnectionDecorator> getArrowDecorators(Connection con) {
        HashSet<ConnectionDecorator> allArrows = new HashSet<ConnectionDecorator>();
        for (ConnectionDecorator deco : con.getConnectionDecorators()) {
            if (!(deco.getGraphicsAlgorithm() instanceof Polygon)) continue;
            allArrows.add(deco);
        }
        return allArrows;
    }

    private ConnectionDecorator getChannelDecorator(Connection con) {
        for (ConnectionDecorator deco : con.getConnectionDecorators()) {
            if (!(deco.getGraphicsAlgorithm() instanceof Ellipse)) continue;
            return deco;
        }
        return null;
    }

    private ConnectionDecorator getRequestRDecorator(Connection con) {
        for (ConnectionDecorator deco : con.getConnectionDecorators()) {
            if (!(deco.getGraphicsAlgorithm() instanceof AbstractText) || !R_DECO.equals(((AbstractText)deco.getGraphicsAlgorithm()).getValue())) continue;
            return deco;
        }
        return null;
    }

    private boolean equalsPolygon(int[] polyPoints, Polygon poly) {
        int i = 0;
        for (Point p : poly.getPoints()) {
            if (p.getX() != polyPoints[i] || p.getY() != polyPoints[i + 1]) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public void setChannelLocation(Connection con, Diagram diagram, double location) {
        ConnectionDecorator channelDecorator = this.getChannelDecorator(con);
        if (channelDecorator != null) {
            Set<ConnectionDecorator> arrowDecorators = this.getArrowDecorators(con);
            for (ConnectionDecorator arrowDecorator : arrowDecorators) {
                if (arrowDecorator.getLocation() == 1.0 || arrowDecorator.getLocation() == 0.0) continue;
                arrowDecorator.setLocation(location);
            }
            con.getConnectionDecorators().remove((Object)channelDecorator);
            ConnectionDecorator newChannelDecorator = this.createChannelSymbol(con, diagram);
            newChannelDecorator.setLocation(location);
            ConnectionDecorator requestRDecorator = this.getRequestRDecorator(con);
            if (requestRDecorator != null) {
                requestRDecorator.setLocation(location);
            }
        }
    }

    public double getChannelLocation(Connection con) {
        ConnectionDecorator channelDecorator = this.getChannelDecorator(con);
        if (channelDecorator != null) {
            return channelDecorator.getLocation();
        }
        return 0.0;
    }

    public void setRequestDirection(Connection con, RequestDirection direction, Diagram diagram) {
        Set<ConnectionDecorator> arrows = this.getArrowDecorators(con);
        DataflowDirection dfDirection = this.getDirection(con);
        con.getConnectionDecorators().removeAll(arrows);
        con.getConnectionDecorators().remove((Object)this.getRequestRDecorator(con));
        this.createRequestArrow(con, direction, diagram);
        this.createDirectionArrow(con, dfDirection, diagram);
    }

    public RequestDirection getRequestDirection(Connection con) {
        boolean request = false;
        boolean response = false;
        for (ConnectionDecorator deco : con.getConnectionDecorators()) {
            if (!(deco.getGraphicsAlgorithm() instanceof Polygon)) continue;
            if (this.equalsPolygon(POINTS_REQUEST_ARROW, (Polygon)deco.getGraphicsAlgorithm())) {
                request = true;
            }
            if (this.equalsPolygon(POINTS_RESPONSE_ARROW, (Polygon)deco.getGraphicsAlgorithm())) {
                response = true;
            }
            if (!request || !response) continue;
            return RequestDirection.REQUESTRESPONSE;
        }
        if (request) {
            return RequestDirection.REQUEST;
        }
        if (response) {
            return RequestDirection.RESPONSE;
        }
        return RequestDirection.UNSPECIFIED;
    }

    private void createRequestArrow(Connection con, RequestDirection direction, Diagram diagram) {
        IGaService ga = Graphiti.getGaService();
        IPeService pe = Graphiti.getPeService();
        ConnectionDecorator arrow = pe.createConnectionDecorator(con, false, (double)0.4f, true);
        Polygon arrowPoly = null;
        switch (direction) {
            case REQUEST: {
                arrowPoly = ga.createPolygon((GraphicsAlgorithmContainer)arrow, POINTS_REQUEST_ARROW);
                arrowPoly.setBackground(ga.manageColor(diagram, 0, 0, 0));
                break;
            }
            case RESPONSE: {
                arrowPoly = ga.createPolygon((GraphicsAlgorithmContainer)arrow, POINTS_RESPONSE_ARROW);
                arrowPoly.setBackground(ga.manageColor(diagram, 0, 0, 0));
                break;
            }
            case REQUESTRESPONSE: {
                arrowPoly = ga.createPolygon((GraphicsAlgorithmContainer)arrow, POINTS_REQUEST_ARROW);
                arrowPoly.setBackground(ga.manageColor(diagram, 0, 0, 0));
                ConnectionDecorator arrow2 = pe.createConnectionDecorator(con, false, (double)0.4f, true);
                Polygon arrowPoly2 = ga.createPolygon((GraphicsAlgorithmContainer)arrow2, POINTS_RESPONSE_ARROW);
                arrowPoly2.setBackground(ga.manageColor(diagram, 0, 0, 0));
                break;
            }
        }
        if (direction != RequestDirection.UNSPECIFIED) {
            ConnectionDecorator letter = pe.createConnectionDecorator(con, false, (double)0.4f, true);
            letter.setActive(true);
            Text txt = ga.createText((GraphicsAlgorithmContainer)letter, R_DECO);
            txt.setForeground(ga.manageColor(diagram, 0, 0, 0));
            txt.setWidth(10);
            txt.setHeight(10);
            ga.setLocation((GraphicsAlgorithm)txt, -8, -22);
        }
    }

    public void setDirection(Connection con, DataflowDirection direction, Diagram diagram) {
        if (con instanceof CompositeConnection) {
            CompositeConnection composite = (CompositeConnection)con;
            int i = 0;
            for (CurvedConnection child : composite.getChildren()) {
                this.changeDirection((Connection)child, i == 0 ? direction : DataflowDirection.getOpposite((DataflowDirection)direction), diagram);
                ++i;
            }
        } else {
            this.changeDirection(con, direction, diagram);
        }
    }

    private void changeDirection(Connection con, DataflowDirection direction, Diagram diagram) {
        Set<ConnectionDecorator> arrows = this.getArrowDecorators(con);
        RequestDirection requestDirection = this.getRequestDirection(con);
        con.getConnectionDecorators().removeAll(arrows);
        con.getConnectionDecorators().remove((Object)this.getRequestRDecorator(con));
        this.createDirectionArrow(con, direction, diagram);
        this.createRequestArrow(con, requestDirection, diagram);
    }

    public DataflowDirection getDirection(Connection con) {
        Set<ConnectionDecorator> arrows = this.getArrowDecorators(con);
        if (arrows.isEmpty()) {
            return DataflowDirection.UNSPECIFIED;
        }
        for (ConnectionDecorator connectionDecorator : arrows) {
            if (connectionDecorator.getLocation() == 0.0) {
                return DataflowDirection.OTHER;
            }
            if (connectionDecorator.getLocation() != 1.0) continue;
            return DataflowDirection.DEFAULT;
        }
        return DataflowDirection.UNSPECIFIED;
    }

    private void createDirectionArrow(Connection con, DataflowDirection direction, Diagram diagram) {
        boolean defaultDirection;
        boolean bl = defaultDirection = direction == DataflowDirection.DEFAULT;
        if (direction != DataflowDirection.UNSPECIFIED) {
            ConnectionAddFeature.createArrowDecorator(diagram, con, defaultDirection);
        }
        if (direction != DataflowDirection.UNSPECIFIED && this.helper.isCommunicationChannel((PictogramElement)con)) {
            CommunicationChannelAddFeature.createCenterArrow(diagram, con, defaultDirection);
        }
    }

    public ConnectionDecorator createChannelSymbol(Connection con, Diagram diagram) {
        ConnectionDecorator cDecorator = Graphiti.getPeService().createConnectionDecorator(con, false, (double)0.4f, true);
        Ellipse e = Graphiti.getGaService().createEllipse((GraphicsAlgorithmContainer)cDecorator);
        e.setBackground(Graphiti.getGaService().manageColor(diagram, 255, 255, 255));
        e.setForeground(Graphiti.getGaService().manageColor(diagram, 0, 0, 0));
        e.setLineWidth(Integer.valueOf(2));
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)e, -8, 0, 16, 16);
        return cDecorator;
    }
}

