/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.LPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.PolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.UPolygonAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.blockdiagram.editor.model.ShapeStyle;
import org.eclipse.fmc.blockdiagram.editor.property.FMCPropertySection;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ShapePropertySection
extends FMCPropertySection {
    private static final String TOOLTIP_MULTI_INSTANCE = "Switch between multi instances or single instances";
    private static final String TOOLTIP_HUMAN_AGENT = "If an agent shape is selected it allows to switch between human and non-human agents.";
    private static final String TOOLTIP_SHAPE_STYLE = "Selects the style of the shape which can be one of Rectable, L or U.";
    private static final String TOOLTIP_ANGLE = "Rotates the selected element in case of L or U shapes";
    private static final String TOOLTIP_BOTTOM_SIZE = "Sets the size of the bottom part of an L or U shape";
    private static final String TOOLTIP_LEFT_SIZE = "Sets the size of the left part of an L or U shape";
    private static final String TOOLTIP_RIGHT_SIZE = "Sets the size of the right part of an L or U shape";
    private static final String TOOLTIP_ANCHORS_VISIBLE = "Makes all anchors of the selected shape visible/invisible";
    private static final int MAX = 1000000;
    private static final String TOOLTIP_ANCHORS_ENABLED = "Creates/deletes anchors of the selected shape ";
    private FMCNodeAlgorithmFactory factory = FMCNodeAlgorithmFactory.getInstance();
    private Spinner width;
    private Spinner height;
    private Spinner xLocation;
    private Spinner yLocation;
    private Spinner bottomSize;
    private Spinner leftSize;
    private Spinner rightSize;
    private Spinner angleSize;
    private CCombo shapeStyle;
    private Button isHumanAgent;
    private Button isMultiInstance;
    private Button isAnchorsVisible;
    private Button isAnchorsEnabled;
    private PictogramElement previouslySelectedPicto = null;
    private FMCTypeChecker helper = FMCTypeCheckerFactory.getInstance();

    Spinner getWidth() {
        return this.width;
    }

    Spinner getHeight() {
        return this.height;
    }

    Spinner getxLocation() {
        return this.xLocation;
    }

    Spinner getyLocation() {
        return this.yLocation;
    }

    Spinner getBottomSize() {
        return this.bottomSize;
    }

    Spinner getLeftSize() {
        return this.leftSize;
    }

    Spinner getRightSize() {
        return this.rightSize;
    }

    Spinner getAngleSize() {
        return this.angleSize;
    }

    CCombo getShapeStyle() {
        return this.shapeStyle;
    }

    Button getIsHumanAgent() {
        return this.isHumanAgent;
    }

    Button getIsMultiInstance() {
        return this.isMultiInstance;
    }

    Button getIsAnchorsVisible() {
        return this.isAnchorsVisible;
    }

    Button getIsAnchorsEnabled() {
        return this.isAnchorsEnabled;
    }

    private void createShapeProperties(TabbedPropertySheetWidgetFactory fac) {
        this.createWidth(fac);
        this.createHeight(fac);
        this.createXLocation(fac);
        this.createYLocation(fac);
        this.createAngleSize(fac);
        this.createShapeStyle(fac);
        this.createHumanAgent(fac);
        this.createMultiInstance(fac);
        this.createBottomSize(fac);
        this.createRightSize(fac);
        this.createLeftSize(fac);
        this.createAnchorsVisible(fac);
        this.createAnchorsEnabled(fac);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory fac = this.getWidgetFactory();
        this.comp = fac.createComposite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(2, false));
        this.createShapeProperties(fac);
        this.refresh();
    }

    protected void createWidth(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "Width:");
        this.width = new Spinner(this.comp, 2048);
        this.width.setMaximum(1000000);
        this.width.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Shape shape;
                GraphicsAlgorithm graphicsAlgorithm;
                int width = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el != null && el instanceof Shape && width != (graphicsAlgorithm = (shape = (Shape)el).getGraphicsAlgorithm()).getWidth()) {
                    ShapePropertySection.this.getActions().resize(graphicsAlgorithm.getX(), graphicsAlgorithm.getY(), width, graphicsAlgorithm.getHeight(), shape);
                }
            }
        });
    }

    protected void createHeight(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "Height:");
        this.height = new Spinner(this.comp, 2048);
        this.height.setMaximum(1000000);
        this.height.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Shape shape;
                GraphicsAlgorithm graphicsAlgorithm;
                int height = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el != null && el instanceof Shape && height != (graphicsAlgorithm = (shape = (Shape)el).getGraphicsAlgorithm()).getHeight()) {
                    ShapePropertySection.this.getActions().resize(graphicsAlgorithm.getX(), graphicsAlgorithm.getY(), graphicsAlgorithm.getWidth(), height, shape);
                }
            }
        });
    }

    protected void createXLocation(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "Location X:");
        this.xLocation = new Spinner(this.comp, 2048);
        this.xLocation.setMaximum(1000000);
        this.xLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Shape shape;
                GraphicsAlgorithm graphicsAlgorithm;
                int x = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el != null && el instanceof Shape && x != (graphicsAlgorithm = (shape = (Shape)el).getGraphicsAlgorithm()).getX()) {
                    ShapePropertySection.this.getActions().resize(x, graphicsAlgorithm.getY(), graphicsAlgorithm.getWidth(), graphicsAlgorithm.getHeight(), shape);
                }
            }
        });
    }

    protected void createYLocation(TabbedPropertySheetWidgetFactory fac) {
        fac.createLabel(this.comp, "Location Y:");
        this.yLocation = new Spinner(this.comp, 2048);
        this.yLocation.setMaximum(1000000);
        this.yLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Shape shape;
                GraphicsAlgorithm graphicsAlgorithm;
                int y = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el != null && el instanceof Shape && y != (graphicsAlgorithm = (shape = (Shape)el).getGraphicsAlgorithm()).getY()) {
                    ShapePropertySection.this.getActions().resize(graphicsAlgorithm.getX(), y, graphicsAlgorithm.getWidth(), graphicsAlgorithm.getHeight(), shape);
                }
            }
        });
    }

    protected void createAngleSize(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Angle:");
        label.setToolTipText(TOOLTIP_ANGLE);
        this.angleSize = new Spinner(this.comp, 2048);
        this.angleSize.setToolTipText(TOOLTIP_ANGLE);
        this.angleSize.setMaximum(270);
        this.angleSize.setIncrement(90);
        this.angleSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int angle = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el != null) {
                    ShapePropertySection.this.getActions().rotate(angle, el);
                }
            }
        });
    }

    protected void createShapeStyle(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Shapestyle:");
        label.setToolTipText(TOOLTIP_SHAPE_STYLE);
        this.shapeStyle = fac.createCCombo(this.comp, 4);
        this.shapeStyle.setToolTipText(TOOLTIP_SHAPE_STYLE);
        this.shapeStyle.setEditable(false);
        this.shapeStyle.setItems(new String[]{ShapeStyle.RECT.getName(), ShapeStyle.L.getName(), ShapeStyle.U.getName()});
        this.shapeStyle.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = ShapePropertySection.this.shapeStyle.getSelectionIndex();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                ShapePropertySection.this.getActions().changeShapeStyle(el, index);
                if (index > 0 && !ShapePropertySection.this.getIsHumanAgent().isDisposed()) {
                    ShapePropertySection.this.getIsHumanAgent().setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createHumanAgent(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Human Agent:");
        label.setToolTipText(TOOLTIP_HUMAN_AGENT);
        this.isHumanAgent = new Button(this.comp, 32);
        this.isHumanAgent.setToolTipText(TOOLTIP_HUMAN_AGENT);
        this.isHumanAgent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el instanceof ContainerShape) {
                    ShapePropertySection.this.getActions().changeAgentType((ContainerShape)el, ShapePropertySection.this.isHumanAgent.getSelection());
                }
                if (ShapePropertySection.this.isHumanAgent.getSelection()) {
                    ShapePropertySection.this.getShapeStyle().setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createMultiInstance(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Multiple Instances:");
        label.setToolTipText(TOOLTIP_MULTI_INSTANCE);
        this.isMultiInstance = new Button(this.comp, 32);
        this.isMultiInstance.setToolTipText(TOOLTIP_MULTI_INSTANCE);
        this.isMultiInstance.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                if (el instanceof ContainerShape) {
                    ShapePropertySection.this.getActions().changeMultiInstance((ContainerShape)el, ShapePropertySection.this.isMultiInstance.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createBottomSize(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Size (Bottom):");
        label.setToolTipText(TOOLTIP_BOTTOM_SIZE);
        this.bottomSize = new Spinner(this.comp, 2048);
        this.bottomSize.setToolTipText(TOOLTIP_BOTTOM_SIZE);
        this.bottomSize.setMaximum(1000000);
        this.bottomSize.setSelection(30);
        this.bottomSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int size = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                ShapePropertySection.this.getActions().resizeBottomPart(size, el);
            }
        });
    }

    protected void createLeftSize(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Size (Left):");
        label.setToolTipText(TOOLTIP_LEFT_SIZE);
        this.leftSize = new Spinner(this.comp, 2048);
        this.leftSize.setToolTipText(TOOLTIP_LEFT_SIZE);
        this.leftSize.setMaximum(1000000);
        this.leftSize.setSelection(30);
        this.leftSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int size = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                ShapePropertySection.this.getActions().resizeLeftPart(size, el);
            }
        });
    }

    protected void createRightSize(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Size (Right):");
        label.setToolTipText(TOOLTIP_RIGHT_SIZE);
        this.rightSize = new Spinner(this.comp, 2048);
        this.rightSize.setToolTipText(TOOLTIP_RIGHT_SIZE);
        this.rightSize.setSelection(30);
        this.rightSize.setMaximum(1000000);
        this.rightSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int size = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                ShapePropertySection.this.getActions().resizeRightPart(size, el);
            }
        });
    }

    protected void createAnchorsVisible(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Anchors visible:");
        label.setToolTipText(TOOLTIP_ANCHORS_VISIBLE);
        this.isAnchorsVisible = new Button(this.comp, 32);
        this.isAnchorsVisible.setToolTipText(TOOLTIP_ANCHORS_VISIBLE);
        this.isAnchorsVisible.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                ShapePropertySection.this.getActions().visualizeAnchors((Shape)el, ShapePropertySection.this.isAnchorsVisible.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createAnchorsEnabled(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Anchors enabled:");
        label.setToolTipText(TOOLTIP_ANCHORS_ENABLED);
        this.isAnchorsEnabled = new Button(this.comp, 32);
        this.isAnchorsEnabled.setToolTipText(TOOLTIP_ANCHORS_ENABLED);
        this.isAnchorsEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ShapePropertySection.this.getSingleInput();
                boolean created = ShapePropertySection.this.getActions().enableAnchors((Shape)el, ShapePropertySection.this.isAnchorsEnabled.getSelection());
                if (created && ShapePropertySection.this.isAnchorsVisible.getSelection()) {
                    ShapePropertySection.this.getActions().visualizeAnchors((Shape)el, ShapePropertySection.this.isAnchorsVisible.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void refreshFMCNode(ContainerShape shape) {
        this.shapeStyle.setEnabled((this.helper.isAgent(super.getSingleInput()) || this.helper.isStorage(super.getSingleInput())) && !this.helper.isHumanAgent(super.getSingleInput()));
        FMCNodeAlgorithm fmcNodeAlgorithmParent = this.factory.getShape((PictogramElement)shape);
        if (fmcNodeAlgorithmParent != null) {
            this.isAnchorsVisible.setSelection(fmcNodeAlgorithmParent.isBoxAnchorsVisible((Shape)shape));
            this.isAnchorsEnabled.setSelection(fmcNodeAlgorithmParent.hasUnusedAnchors((Shape)shape));
        }
        if (FMCUtil.isMultiShape((PictogramElement)shape)) {
            FMCNodeAlgorithm fmcNodeAlgorithm = this.factory.getShape((PictogramElement)shape);
            if (fmcNodeAlgorithm instanceof LPolygonAlgorithm) {
                Polygon polygon = (Polygon)shape.getGraphicsAlgorithm();
                this.shapeStyle.select(1);
                if (this.isHumanAgent != null) {
                    this.isHumanAgent.setEnabled(false);
                }
                this.angleSize.setEnabled(true);
                this.angleSize.setSelection(((PolygonAlgorithm)((Object)fmcNodeAlgorithm)).getAngle((GraphicsAlgorithm)polygon));
                this.bottomSize.setEnabled(true);
                this.rightSize.setEnabled(true);
                this.rightSize.setMinimum(30);
                this.rightSize.setSelection(((LPolygonAlgorithm)((Object)fmcNodeAlgorithm)).getRightPartSize(polygon));
                this.bottomSize.setSelection(((LPolygonAlgorithm)((Object)fmcNodeAlgorithm)).getBottomPartSize(polygon));
                this.bottomSize.setMinimum(30);
                if (fmcNodeAlgorithm instanceof UPolygonAlgorithm) {
                    this.shapeStyle.select(2);
                    this.leftSize.setEnabled(true);
                    this.leftSize.setMinimum(30);
                    this.leftSize.setSelection(((UPolygonAlgorithm)((Object)fmcNodeAlgorithm)).getLeftPartSize(polygon));
                }
            } else if (this.helper.isStorage((PictogramElement)shape)) {
                this.shapeStyle.select(0);
            } else if (this.helper.isAgent((PictogramElement)shape)) {
                this.shapeStyle.select(0);
                if (this.isHumanAgent != null) {
                    this.isHumanAgent.setEnabled(true);
                    this.isHumanAgent.setSelection(this.helper.isHumanAgent((PictogramElement)shape));
                }
            } else if (this.isHumanAgent != null) {
                this.isHumanAgent.setEnabled(false);
            }
            if (fmcNodeAlgorithmParent != null && this.isMultiInstance != null) {
                this.isMultiInstance.setSelection(fmcNodeAlgorithmParent.isMultipleInstances(shape));
            }
        } else if (fmcNodeAlgorithmParent != null && shape.getGraphicsAlgorithm() instanceof Polygon) {
            Polygon polygon = (Polygon)shape.getGraphicsAlgorithm();
            if (fmcNodeAlgorithmParent instanceof LPolygonAlgorithm) {
                this.bottomSize.setEnabled(true);
                this.rightSize.setEnabled(true);
                this.rightSize.setMinimum(30);
                this.rightSize.setSelection(((LPolygonAlgorithm)((Object)fmcNodeAlgorithmParent)).getRightPartSize(polygon));
                this.bottomSize.setSelection(((LPolygonAlgorithm)((Object)fmcNodeAlgorithmParent)).getBottomPartSize(polygon));
                this.angleSize.setEnabled(true);
                this.angleSize.setEnabled(true);
                this.angleSize.setSelection(((PolygonAlgorithm)((Object)fmcNodeAlgorithmParent)).getAngle((GraphicsAlgorithm)polygon));
            }
            if (fmcNodeAlgorithmParent instanceof UPolygonAlgorithm) {
                this.leftSize.setEnabled(true);
                this.leftSize.setMinimum(30);
                this.leftSize.setSelection(((UPolygonAlgorithm)((Object)fmcNodeAlgorithmParent)).getLeftPartSize(polygon));
            }
        }
    }

    private void refreshShape(Shape shape) {
        GraphicsAlgorithm graphicsAlgorithm;
        this.setControlsDisabled();
        if (!(shape instanceof Diagram)) {
            if (this.width != null) {
                this.width.setEnabled(true);
            }
            if (this.height != null) {
                this.height.setEnabled(true);
            }
            if (this.xLocation != null) {
                this.xLocation.setEnabled(true);
            }
            if (this.yLocation != null) {
                this.yLocation.setEnabled(true);
            }
        }
        if (this.helper.isFMCNode((PictogramElement)shape)) {
            this.refreshFMCNode((ContainerShape)shape);
        }
        if ((graphicsAlgorithm = shape.getGraphicsAlgorithm()) != null) {
            this.width.setSelection(graphicsAlgorithm.getWidth());
            this.height.setSelection(graphicsAlgorithm.getHeight());
            this.xLocation.setSelection(graphicsAlgorithm.getX());
            this.yLocation.setSelection(graphicsAlgorithm.getY());
        }
        if (this.isMultiInstance != null) {
            boolean isMultiInstanceVisible = this.helper.isAgent(super.getSingleInput()) || this.helper.isStorage(super.getSingleInput());
            this.isMultiInstance.setEnabled(isMultiInstanceVisible);
        }
    }

    public void refresh() {
        if (!(this.isDisposed() || this.previouslySelectedPicto != null && this.previouslySelectedPicto == this.getSingleInput())) {
            PictogramElement el = this.getSingleInput();
            if (el != null && el instanceof Shape) {
                this.refreshShape((Shape)el);
            } else {
                this.setControlsDisabled();
            }
            this.previouslySelectedPicto = el;
            ScrolledComposite tabbedPropertyComposite = this.findTabbedPropertyComposite(this.comp);
            if (tabbedPropertyComposite != null) {
                int cols = tabbedPropertyComposite.getSize().x / 150 * 2;
                cols = cols < 2 ? 2 : cols;
                this.comp.setLayout((Layout)new GridLayout(cols > 8 ? 8 : cols, false));
                this.comp.layout();
            }
        }
    }

    private void setControlsDisabled() {
        this.disableStandardSizeControls();
        this.disableSpecialSizeControls();
        if (this.shapeStyle != null) {
            this.shapeStyle.setEnabled(false);
        }
        if (this.isHumanAgent != null) {
            this.isHumanAgent.setEnabled(false);
        }
        if (this.isMultiInstance != null) {
            this.isMultiInstance.setEnabled(false);
        }
    }

    private void disableSpecialSizeControls() {
        if (this.bottomSize != null) {
            this.bottomSize.setEnabled(false);
        }
        if (this.leftSize != null) {
            this.leftSize.setEnabled(false);
        }
        if (this.rightSize != null) {
            this.rightSize.setEnabled(false);
        }
    }

    private void disableStandardSizeControls() {
        if (this.angleSize != null) {
            this.angleSize.setEnabled(false);
        }
        if (this.width != null) {
            this.width.setEnabled(false);
        }
        if (this.height != null) {
            this.height.setEnabled(false);
        }
        if (this.xLocation != null) {
            this.xLocation.setEnabled(false);
        }
        if (this.yLocation != null) {
            this.yLocation.setEnabled(false);
        }
    }
}

