/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.features.update;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.Comment;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CommentUpdateMetaFeature
extends AbstractUpdateFeature {
    public CommentUpdateMetaFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return context.getPictogramElement() instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        EObject bo = FMCUtil.getBO((PictogramElement)context.getPictogramElement());
        if (bo instanceof Comment) {
            Comment comment = (Comment)bo;
            ContainerShape container = (ContainerShape)context.getPictogramElement();
            return this.updateNeeded(container, comment);
        }
        return Reason.createFalseReason();
    }

    protected IReason updateNeeded(ContainerShape container, Comment comment) {
        AbstractText text = this.findText(container);
        if (text == null) {
            return Reason.createFalseReason();
        }
        if (!this.equalsText(text, comment)) {
            return Reason.createTrueReason((String)"The text is not in synch with domain model");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Comment comment = (Comment)FMCUtil.getBO((PictogramElement)container);
        this.updateText(context, comment);
        return true;
    }

    protected boolean equalsText(AbstractText text, Comment comment) {
        return text == null && comment.getContent() == null || text != null && text.getValue().equals(comment.getContent());
    }

    protected void updateText(IUpdateContext context, Comment comment) {
        AbstractText text = this.findText((ContainerShape)context.getPictogramElement());
        if (text != null) {
            String commentText = comment.getContent();
            text.setValue(commentText == null ? "" : commentText);
        }
    }

    protected AbstractText findText(ContainerShape container) {
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        for (GraphicsAlgorithm gaChild : ga.getGraphicsAlgorithmChildren()) {
            if (!(gaChild instanceof AbstractText)) continue;
            return (AbstractText)gaChild;
        }
        return null;
    }
}

