/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.FMCNodeAlgorithmFactory;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddPictogramElementFeature;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class AnchorAddFeature
extends AbstractAddPictogramElementFeature {
    private FMCNodeAlgorithmFactory factory = FMCNodeAlgorithmFactory.getInstance();

    public AnchorAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public boolean canAdd(IAddContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        return !(targetContainer instanceof Diagram) && targetContainer != null && targetContainer.isActive();
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        double relativeWidth = (double)context.getX() / (double)targetContainer.getGraphicsAlgorithm().getWidth();
        double relativeHeight = (double)context.getY() / (double)targetContainer.getGraphicsAlgorithm().getHeight();
        BoxRelativeAnchor boxAnchor = this.factory.getHumanAgent().createBoxAnchor((Shape)targetContainer, relativeWidth, relativeHeight, 8, 8);
        boxAnchor.getGraphicsAlgorithm().setFilled(Boolean.valueOf(true));
        boxAnchor.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(true));
        return null;
    }
}

