/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AbstractNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RectangleAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RotatableNode;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;

public abstract class AbstractRectangleAlgorithm
extends AbstractNode
implements RectangleAlgorithm,
RotatableNode {
    @Override
    public void relocateText(GraphicsAlgorithm graphicsAlgorithm) {
        MultiText text = this.getText(graphicsAlgorithm);
        if (text != null) {
            int multipleOffset = 0;
            if (this.isMultipleInstances(this.getContainerShape(graphicsAlgorithm))) {
                multipleOffset = 5;
            }
            int x = this.textMargin;
            int width = graphicsAlgorithm.getWidth() - 2 * this.textMargin - multipleOffset;
            int y = this.textMargin + multipleOffset;
            int height = graphicsAlgorithm.getHeight() - 2 * this.textMargin - multipleOffset;
            this.ga.setLocationAndSize((GraphicsAlgorithm)text, x, y, width, height);
        }
    }

    @Override
    public int getAngle(GraphicsAlgorithm graphicsAlgorithm) {
        return 0;
    }

    @Override
    public boolean isFlipped(GraphicsAlgorithm graphicsAlgorithm) {
        return false;
    }

    @Override
    public void rotate90Right(GraphicsAlgorithm graphicsAlgorithm) {
        this.translateForRotation(graphicsAlgorithm);
        this.doRotate(graphicsAlgorithm);
        this.relocateText(graphicsAlgorithm);
        for (GraphicsAlgorithm algorithm : graphicsAlgorithm.getGraphicsAlgorithmChildren()) {
            this.doRotate(algorithm);
        }
    }

    @Override
    public void flipHorizontally(GraphicsAlgorithm graphicsAlgorithm) {
    }

    @Override
    public void flipVertically(GraphicsAlgorithm graphicsAlgorithm) {
    }

    protected void translateForRotation(GraphicsAlgorithm graphicsAlgorithm) {
        graphicsAlgorithm.setX(graphicsAlgorithm.getX() + (graphicsAlgorithm.getWidth() - graphicsAlgorithm.getHeight()) / 2);
        graphicsAlgorithm.setY(graphicsAlgorithm.getY() - (graphicsAlgorithm.getWidth() - graphicsAlgorithm.getHeight()) / 2);
    }

    protected void doRotate(GraphicsAlgorithm graphicsAlgorithm) {
        int width = graphicsAlgorithm.getWidth();
        graphicsAlgorithm.setWidth(graphicsAlgorithm.getHeight());
        graphicsAlgorithm.setHeight(width);
    }
}

