/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class PaintFormatCustomFeature
extends FMCCustomFeature {
    private boolean formatCopied = false;
    private Color background;
    private Color foreground;
    private Color fontColor;
    private Font font;
    private Integer textAngle;
    private Style style;
    private Double transparency;

    public PaintFormatCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pictogramElementArray = context.getPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pictogramElement = pictogramElementArray[n2];
            if (!this.isFormatCopied()) {
                this.copyFormat(pictogramElement);
            } else {
                this.pasteFormat(pictogramElement);
            }
            ++n2;
        }
        boolean bl = this.formatCopied = !this.formatCopied;
        if (!this.isFormatCopied()) {
            this.background = null;
            this.foreground = null;
            this.style = null;
            this.font = null;
            this.fontColor = null;
            this.transparency = null;
            this.textAngle = null;
        }
    }

    public String getName() {
        return "FormatPainter";
    }

    public String getImageId() {
        return "org.eclipse.fmc.FormatPainter";
    }

    private void copyFormat(PictogramElement element) {
        AbstractText text;
        GraphicsAlgorithm graphicsAlgorithm = element.getGraphicsAlgorithm();
        this.background = graphicsAlgorithm.getBackground();
        this.foreground = graphicsAlgorithm.getForeground();
        this.transparency = graphicsAlgorithm.getTransparency();
        this.style = graphicsAlgorithm.getStyle();
        if (element instanceof ContainerShape && (text = this.getText((ContainerShape)element)) != null) {
            this.font = text.getFont();
            this.fontColor = text.getForeground();
            this.textAngle = text.getAngle();
        }
    }

    private void pasteFormat(PictogramElement element) {
        this.pasteFormat(element, element.getGraphicsAlgorithm());
        for (GraphicsAlgorithm graphicsAlgorithm : element.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
            this.pasteFormat(element, graphicsAlgorithm);
        }
    }

    private void pasteFormat(PictogramElement element, GraphicsAlgorithm graphicsAlgorithm) {
        graphicsAlgorithm.setBackground(this.background);
        graphicsAlgorithm.setForeground(this.foreground);
        graphicsAlgorithm.setTransparency(this.transparency);
        graphicsAlgorithm.setStyle(this.style);
        if (element instanceof ContainerShape) {
            AbstractText text = this.getText((ContainerShape)element);
            if (text != null) {
                text.setFont(this.font);
                text.setForeground(this.fontColor);
                text.setAngle(this.textAngle);
            }
            if (this.style != null && text.getFont() == null) {
                text.setFont(this.style.getFont());
            }
        }
    }

    private AbstractText getText(ContainerShape shape) {
        for (Shape child : shape.getChildren()) {
            if (!(child.getGraphicsAlgorithm() instanceof AbstractText)) continue;
            return (AbstractText)child.getGraphicsAlgorithm();
        }
        return null;
    }

    public boolean canExecute(ICustomContext context) {
        return this.formatCopied && context.getPictogramElements().length > 0 || context.getPictogramElements().length == 1;
    }

    public boolean isFormatCopied() {
        return this.formatCopied;
    }

    public boolean hasDoneChanges() {
        return !this.isFormatCopied();
    }

    public boolean canUndo(IContext context) {
        return !this.isFormatCopied();
    }
}

