/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.model;

import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public final class SimpleFMCTypeChecker
implements FMCTypeChecker {
    private static FMCTypeChecker helper;

    public static FMCTypeChecker getInstance() {
        if (helper == null) {
            helper = new SimpleFMCTypeChecker();
        }
        return helper;
    }

    @Override
    public boolean isFMCNode(PictogramElement element) {
        return this.isType(element, FMCType.Agent, FMCType.HumanAgent, FMCType.Storage, FMCType.StructureVariance);
    }

    @Override
    public boolean isFMCConnection(PictogramElement element) {
        return this.isChannelType(element) || this.isAccessType(element);
    }

    @Override
    public boolean isAgent(PictogramElement element) {
        return this.isType(element, FMCType.Agent, FMCType.HumanAgent);
    }

    @Override
    public boolean isHumanAgent(PictogramElement element) {
        return this.isType(element, FMCType.HumanAgent);
    }

    @Override
    public boolean isStorage(PictogramElement element) {
        return this.isType(element, FMCType.Storage);
    }

    @Override
    public boolean isStructureVariance(PictogramElement element) {
        return this.isType(element, FMCType.StructureVariance);
    }

    @Override
    public boolean isCommunicationChannel(PictogramElement element) {
        return this.isType(element, FMCType.BidirectionalCommChannel, FMCType.UnidirectionalCommChannel, FMCType.ReqRespCommChannel);
    }

    @Override
    public boolean isChannelType(PictogramElement element) {
        return this.isType(element, this.getChannelTypes());
    }

    @Override
    public boolean isAccessType(PictogramElement element) {
        return this.isType(element, FMCType.UnidirectionalAccess, FMCType.BidirectionalAccess, FMCType.ModifyAccess);
    }

    @Override
    public boolean isModifyAccess(PictogramElement element) {
        return this.isType(element, FMCType.ModifyAccess);
    }

    @Override
    public boolean isChannelType(Object obj) {
        FMCType[] fMCTypeArray = this.getChannelTypes();
        int n = fMCTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FMCType chan = fMCTypeArray[n2];
            if (((Object)((Object)chan)).equals(obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private FMCType[] getChannelTypes() {
        return new FMCType[]{FMCType.BidirectionalCommChannel, FMCType.UnidirectionalCommChannel, FMCType.ReqRespCommChannel};
    }

    @Override
    public boolean isReqRespCommunicationChannel(Object obj) {
        return obj == FMCType.ReqRespCommChannel;
    }

    @Override
    public boolean isUnidirectionalCommunicationChannel(Object obj) {
        return obj == FMCType.UnidirectionalCommChannel;
    }

    @Override
    public boolean isReqRespCommunicationChannel(Connection con) {
        return this.isType((PictogramElement)con, FMCType.ReqRespCommChannel);
    }

    private boolean isType(PictogramElement element, FMCType ... types) {
        if (element == null) {
            return false;
        }
        FMCType objectType = FMCUtil.getIndependentObject(element);
        if (objectType != null) {
            FMCType[] fMCTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                FMCType type = fMCTypeArray[n2];
                if (objectType == type) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isBrace(PictogramElement element) {
        return this.isType(element, FMCType.Brace);
    }

    @Override
    public boolean isAreaBorder(PictogramElement element) {
        return this.isType(element, FMCType.AreaBorder);
    }

    @Override
    public boolean isDots(PictogramElement element) {
        return this.isType(element, FMCType.DotsShape, FMCType.Dots);
    }

    @Override
    public boolean isTextComment(PictogramElement element) {
        return this.isType(element, FMCType.Text);
    }

    @Override
    public boolean isComment(PictogramElement element) {
        return this.isTextComment(element) || this.isDots(element) || this.isAreaBorder(element) || this.isBrace(element) || this.isCommonFeatureArea(element) || this.isImage(element);
    }

    @Override
    public boolean isCommonFeatureArea(PictogramElement element) {
        return this.isType(element, FMCType.CommonFeatureArea);
    }

    @Override
    public boolean isImage(PictogramElement element) {
        return this.isType(element, FMCType.Image);
    }
}

