/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.features.add.ConnectionAddFeature;
import org.eclipse.fmc.blockdiagram.editor.model.ConnectionStyle;
import org.eclipse.fmc.blockdiagram.editor.model.FMCType;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.CurvedConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AccessAddFeature
extends ConnectionAddFeature {
    public AccessAddFeature(IFeatureProvider fp, ConnectionStyle style) {
        super(fp, style);
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        IGaService ga = Graphiti.getGaService();
        IPeService pe = Graphiti.getPeService();
        IAddConnectionContext cContext = (IAddConnectionContext)context;
        Connection con = super.createConnection();
        Polyline line = ga.createPolyline((GraphicsAlgorithmContainer)con);
        con.setStart(cContext.getSourceAnchor());
        con.setEnd(cContext.getTargetAnchor());
        line.setForeground(this.manageColor(0, 0, 0));
        if (context.getNewObject() == FMCType.UnidirectionalAccess) {
            AccessAddFeature.createArrowDecorator(this.getDiagram(), con, true);
        } else if (context.getNewObject() == FMCType.ModifyAccess) {
            CompositeConnection compCon = (CompositeConnection)con;
            CurvedConnection curved1 = pe.createCurvedConnection(new double[]{0.5, 50.0}, this.getDiagram());
            CurvedConnection curved2 = pe.createCurvedConnection(new double[]{0.5, -50.0}, this.getDiagram());
            compCon.getChildren().add((Object)curved1);
            compCon.getChildren().add((Object)curved2);
            ga.createPolyline((GraphicsAlgorithmContainer)curved1);
            ga.createPolyline((GraphicsAlgorithmContainer)curved2);
            AccessAddFeature.createArrowDecorator(this.getDiagram(), (Connection)curved1, true);
            AccessAddFeature.createArrowDecorator(this.getDiagram(), (Connection)curved2, false);
            line.setLineVisible(Boolean.valueOf(false));
        } else {
            this.addDomainModelContent(context, con, line);
        }
        this.link((PictogramElement)con, context.getNewObject());
        return con;
    }

    protected void addDomainModelContent(IAddContext context, Connection con, Polyline line) {
    }
}

