/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RectangleAgentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeCreateService;

public class HumanAgentAlgorithm
extends RectangleAgentAlgorithm {
    public void removeHumanFigure(PictogramElement element) {
        if (element instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)element;
            for (Shape shape : new ArrayList(container.getChildren())) {
                if (!(shape instanceof ContainerShape) || shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() != 5) continue;
                container.getChildren().remove((Object)shape);
                break;
            }
        }
    }

    public boolean hasHumanFigure(PictogramElement element) {
        if (element instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)element;
            for (Shape shape : new ArrayList(container.getChildren())) {
                if (!(shape instanceof ContainerShape) || shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() != 5) continue;
                return true;
            }
        }
        return false;
    }

    public ContainerShape getHumanFigure(PictogramElement element) {
        if (element instanceof ContainerShape) {
            ContainerShape container = (ContainerShape)element;
            for (Shape shape : new ArrayList(container.getChildren())) {
                if (!(shape instanceof ContainerShape) || shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() != 5) continue;
                return (ContainerShape)shape;
            }
        }
        return null;
    }

    public void addHumanFigure(Diagram diag, ContainerShape container, int width) {
        int headSize;
        int startPointX = width / 2 - 12;
        IPeCreateService pe = Graphiti.getPeCreateService();
        Color black = this.ga.manageColor(diag, 0, 0, 0);
        ContainerShape figure = pe.createContainerShape(container, true);
        int headX = 6;
        int bodyX = headSize = 10;
        int bodyY = headSize - 1;
        int bodySize = 18;
        int lArmX = bodyX + 1;
        int rArmX = bodyX - 1;
        int armsY = 18;
        int armEndX = 13;
        int armEndY = 9;
        int legY = headSize * 2 + bodySize - 2;
        int rLegX = headSize * 2 + 1;
        int centerOfLegsX = headSize;
        int centerOfLegsY = -headSize - 1;
        Rectangle invRec = this.ga.createInvisibleRectangle((PictogramElement)figure);
        this.ga.setLocationAndSize((GraphicsAlgorithm)invRec, startPointX, 10, 25, bodySize + 2 * headSize);
        Ellipse head = this.ga.createEllipse((GraphicsAlgorithmContainer)invRec);
        head.setFilled(Boolean.valueOf(false));
        head.setForeground(black);
        head.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        this.ga.setLocationAndSize((GraphicsAlgorithm)head, headX, 0, headSize, headSize);
        int[] nArray = new int[4];
        nArray[2] = -armEndX;
        nArray[3] = -armEndY;
        Polyline leftArm = this.ga.createPolyline((GraphicsAlgorithmContainer)invRec, nArray);
        leftArm.setForeground(black);
        leftArm.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        this.ga.setLocation((GraphicsAlgorithm)leftArm, lArmX, armsY);
        int[] nArray2 = new int[4];
        nArray2[2] = armEndX;
        nArray2[3] = -armEndY;
        Polyline rightArm = this.ga.createPolyline((GraphicsAlgorithmContainer)invRec, nArray2);
        rightArm.setForeground(black);
        rightArm.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        this.ga.setLocation((GraphicsAlgorithm)rightArm, rArmX, armsY);
        int[] nArray3 = new int[4];
        nArray3[3] = bodySize;
        Polyline body = this.ga.createPolyline((GraphicsAlgorithmContainer)invRec, nArray3);
        body.setForeground(black);
        body.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        this.ga.setLocation((GraphicsAlgorithm)body, bodyX, bodyY);
        int[] nArray4 = new int[6];
        nArray4[2] = centerOfLegsX;
        nArray4[3] = centerOfLegsY;
        nArray4[4] = rLegX;
        Polyline legs = this.ga.createPolyline((GraphicsAlgorithmContainer)invRec, nArray4);
        legs.setForeground(black);
        legs.setParentGraphicsAlgorithm((GraphicsAlgorithm)invRec);
        this.ga.setLocation((GraphicsAlgorithm)legs, 0, legY);
    }

    @Override
    public GraphicsAlgorithm createGraphics(Diagram diag, GraphicsAlgorithmContainer container, int x, int y, int width, int height) {
        GraphicsAlgorithm rectangle = super.createGraphics(diag, container, x, y, width, height);
        if (container instanceof ContainerShape) {
            this.addHumanFigure(diag, (ContainerShape)container, width);
        }
        return rectangle;
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        super.resize(algorithm, x, y, width, height);
        ContainerShape container = this.getContainerShape(algorithm);
        this.removeHumanFigure((PictogramElement)container);
        this.addHumanFigure(FMCUtil.getActiveEditor().getDiagramTypeProvider().getDiagram(), container, width);
    }

    @Override
    public EList<Shape> getContainedShapes(ContainerShape cs) {
        BasicEList results = new BasicEList();
        ContainerShape humanFigureShape = this.getHumanFigure((PictogramElement)cs);
        if (humanFigureShape != null) {
            for (Shape shape : super.getContainedShapes(cs)) {
                if (shape.equals(humanFigureShape)) continue;
                results.add((Object)shape);
            }
        }
        return results;
    }
}

