/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.java.sdk.ui.internal.wizard.page;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.Activator;
import org.eclipse.emf.facet.query.java.sdk.ui.internal.Messages;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SelectJavaClassWizardPage
extends WizardPage {
    private String result;
    private Text text;

    public SelectJavaClassWizardPage() {
        super("SelectJavaClass");
        this.setTitle(Messages.SelectJavaClassWizardPage_SelectAJavaClass);
        this.setDescription(Messages.SelectJavaClassWizardPage_SeclectAJavaClassLongDescription);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Button dialogBtn = new Button(composite, 8);
        dialogBtn.setText("Open the class selection wizard...");
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SelectJavaClassWizardPage.this.openSelectionDialog();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        dialogBtn.addSelectionListener(listener);
        this.text = new Text(composite, 2048);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    protected void openSelectionDialog() {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = new Shell(display);
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
                    dialog.open();
                    boolean cancelled = dialog.getReturnCode() == 1;
                    String dilaogResult = null;
                    if (!cancelled && dialog.getResult()[0] instanceof IType) {
                        IType type = (IType)dialog.getResult()[0];
                        dilaogResult = type.getFullyQualifiedName();
                    }
                    SelectJavaClassWizardPage.this.dialogClosed(dilaogResult, cancelled);
                }
                catch (JavaModelException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    SelectJavaClassWizardPage.this.dialogClosed(null, true);
                }
            }
        });
    }

    protected void dialogClosed(Object dialogResult, boolean cancelled) {
        if (cancelled) {
            this.getPreviousPage();
        } else if (dialogResult != null && dialogResult.toString().length() > 0) {
            this.result = dialogResult.toString();
            this.text.setText(dialogResult.toString());
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public String getResult() {
        return this.result;
    }
}

