/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.confluence;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDVarSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerSettings;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerBddBasedCheck;
import org.eclipse.escet.cif.controllercheck.checks.confluence.ConfluenceCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.confluence.EventPairData;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ConfluenceCheck
extends ControllerCheckerBddBasedCheck<ConfluenceCheckConclusion> {
    private static final boolean DEBUG_GLOBAL = false;
    private static final boolean DEBUG_INDENPENCE = false;
    private static final boolean DEBUG_REVERSIBLE = false;
    private static final boolean DEBUG_UPDATE_EQUIVALENCE = false;
    public static final String PROPERTY_NAME = "confluence";

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    @Override
    protected CifBddSettings createCifBddSettings(ControllerCheckerSettings checkerSettings) {
        CifBddSettings settings = super.createCifBddSettings(checkerSettings);
        settings.setBddNumberOfExtraVarDomains(2);
        return settings;
    }

    @Override
    public ConfluenceCheckConclusion performCheck(CifBddSpec cifBddSpec) {
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput out = cifBddSpec.settings.getNormalOutput();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        List controllableEvents = Lists.set2list((Set)cifBddSpec.controllables);
        if (controllableEvents.isEmpty()) {
            dbg.line("No controllable events. Confluence trivially holds.");
            return new ConfluenceCheckConclusion(List.of());
        }
        if (controllableEvents.size() == 1) {
            dbg.line("One controllable event. Confluence trivially holds.");
            return new ConfluenceCheckConclusion(List.of());
        }
        BDD zeroToOldVarRelations = this.createZeroToOldVarsRelations(cifBddSpec);
        termination.throwIfRequested();
        Map<Event, CifBddEdge> eventToEdge = cifBddSpec.eventEdges.entrySet().stream().collect(Collectors.toMap(e -> (Event)e.getKey(), e -> (CifBddEdge)Lists.single((List)((List)e.getValue()))));
        List mutualExclusives = Lists.list();
        List updateEquivalents = Lists.list();
        List independents = Lists.list();
        List skippables = Lists.list();
        List reversibles = Lists.list();
        List cannotProves = Lists.list();
        int i = 0;
        while (i < controllableEvents.size()) {
            Event event1 = (Event)controllableEvents.get(i);
            String evt1Name = CifTextUtils.getAbsName((PositionObject)event1);
            CifBddEdge edge1 = eventToEdge.get(event1);
            int j = i + 1;
            while (j < controllableEvents.size()) {
                Event event2 = (Event)controllableEvents.get(j);
                String evt2Name = CifTextUtils.getAbsName((PositionObject)event2);
                CifBddEdge edge2 = eventToEdge.get(event2);
                EventPairData eventPairData = new EventPairData(cifBddSpec, event1, event2, edge1, edge2, evt1Name, evt2Name, zeroToOldVarRelations);
                termination.throwIfRequested();
                boolean isMutualExclusive = this.checkMutualExclusive(eventPairData, dbg, termination);
                if (isMutualExclusive) {
                    mutualExclusives.add(this.makeSortedPair(eventPairData.evt1Name, eventPairData.evt2Name));
                    eventPairData.free();
                } else {
                    termination.throwIfRequested();
                    boolean isUpdateEquivalent = this.checkUpdateEquivalent(eventPairData, dbg, termination);
                    if (isUpdateEquivalent) {
                        updateEquivalents.add(this.makeSortedPair(eventPairData.evt1Name, eventPairData.evt2Name));
                        eventPairData.free();
                    } else {
                        termination.throwIfRequested();
                        boolean isIndependent = this.checkIndependent(eventPairData, dbg, termination);
                        if (isIndependent) {
                            independents.add(this.makeSortedPair(eventPairData.evt1Name, eventPairData.evt2Name));
                            eventPairData.free();
                        } else {
                            termination.throwIfRequested();
                            boolean isSkippable = this.checkSkippable(eventPairData, dbg, termination);
                            if (isSkippable) {
                                skippables.add(this.makeSortedPair(eventPairData.evt1Name, eventPairData.evt2Name));
                                eventPairData.free();
                            } else {
                                termination.throwIfRequested();
                                boolean isReversible = this.checkReversible(eventPairData, eventToEdge, dbg, termination);
                                if (isReversible) {
                                    reversibles.add(this.makeSortedPair(eventPairData.evt1Name, eventPairData.evt2Name));
                                    eventPairData.free();
                                } else {
                                    termination.throwIfRequested();
                                    eventPairData.free();
                                    cannotProves.add(this.makeSortedPair(evt1Name, evt2Name));
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        termination.throwIfRequested();
        zeroToOldVarRelations.free();
        boolean needEmptyLine = false;
        needEmptyLine = this.dumpMatches(mutualExclusives, "Mutual exclusive event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(updateEquivalents, "Update equivalent event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(independents, "Independent event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(skippables, "Skippable event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(reversibles, "Reversible event pairs", out, needEmptyLine);
        if (mutualExclusives.isEmpty() && updateEquivalents.isEmpty() && independents.isEmpty() && skippables.isEmpty() && reversibles.isEmpty()) {
            dbg.line("No proven pairs.");
        }
        dbg.line();
        if (cannotProves.isEmpty()) {
            dbg.line("All pairs proven. Confluence holds.");
        } else {
            dbg.line("Some pairs unproven. Confluence may not hold.");
        }
        return new ConfluenceCheckConclusion(cannotProves);
    }

    private BDD createZeroToOldVarsRelations(CifBddSpec cifBddSpec) {
        Termination termination = cifBddSpec.settings.getTermination();
        BDD relations = cifBddSpec.factory.one();
        for (CifBddVariable cifBddVar : Lists.reverse(Arrays.asList(cifBddSpec.variables))) {
            BDD relation = cifBddVar.domain.buildEquals(cifBddVar.domainsExtra[0]);
            termination.throwIfRequested();
            relations = relations.andWith(relation);
            termination.throwIfRequested();
        }
        return relations;
    }

    private boolean checkMutualExclusive(EventPairData eventPairData, DebugNormalOutput dbg, Termination termination) {
        BDD commonEnabledGuards = eventPairData.getCommonEnabledGuardsNoZero();
        termination.throwIfRequested();
        boolean isMutualExclusive = commonEnabledGuards.isZero();
        if (isMutualExclusive) {
            // empty if block
        }
        return isMutualExclusive;
    }

    private boolean checkUpdateEquivalent(EventPairData eventPairData, DebugNormalOutput dbg, Termination termination) {
        BDD commonEnabledZeroStates = eventPairData.getCommonEnabledZeroStates(termination);
        termination.throwIfRequested();
        BDD event1Done = eventPairData.getEvent1Done(termination);
        termination.throwIfRequested();
        BDD event2Done = eventPairData.getEvent2Done(termination);
        termination.throwIfRequested();
        boolean isUpdateEquivalent = !event1Done.isZero() && event1Done.equals((Object)event2Done) && this.allStatesCovered(commonEnabledZeroStates, event1Done, eventPairData.varSetOld, termination);
        termination.throwIfRequested();
        if (isUpdateEquivalent) {
            // empty if block
        }
        return isUpdateEquivalent;
    }

    private boolean checkIndependent(EventPairData eventPairData, DebugNormalOutput dbg, Termination termination) {
        BDD commonEnabledZeroStates = eventPairData.getCommonEnabledZeroStates(termination);
        termination.throwIfRequested();
        BDD event12Done = eventPairData.getEvent12Done(termination);
        termination.throwIfRequested();
        BDD event21Done = eventPairData.getEvent21Done(termination);
        termination.throwIfRequested();
        termination.throwIfRequested();
        boolean isIndependent = !event12Done.isZero() && event12Done.equals((Object)event21Done) && this.allStatesCovered(commonEnabledZeroStates, event12Done, eventPairData.varSetOld, termination);
        termination.throwIfRequested();
        if (isIndependent) {
            // empty if block
        }
        return isIndependent;
    }

    private boolean checkSkippable(EventPairData eventPairData, DebugNormalOutput dbg, Termination termination) {
        boolean isSkippable = false;
        BDD commonEnabledZeroStates = eventPairData.getCommonEnabledZeroStates(termination);
        termination.throwIfRequested();
        if (!isSkippable) {
            BDD event1Done = eventPairData.getEvent1Done(termination);
            termination.throwIfRequested();
            BDD event21Done = eventPairData.getEvent21Done(termination);
            termination.throwIfRequested();
            isSkippable = !event21Done.isZero() && event1Done.equals((Object)event21Done) && this.allStatesCovered(commonEnabledZeroStates, event1Done, eventPairData.varSetOld, termination);
            termination.throwIfRequested();
        }
        if (!isSkippable) {
            BDD event2Done = eventPairData.getEvent2Done(termination);
            termination.throwIfRequested();
            BDD event12Done = eventPairData.getEvent12Done(termination);
            termination.throwIfRequested();
            isSkippable = !event12Done.isZero() && event2Done.equals((Object)event12Done) && this.allStatesCovered(commonEnabledZeroStates, event2Done, eventPairData.varSetOld, termination);
            termination.throwIfRequested();
        }
        if (isSkippable) {
            // empty if block
        }
        return isSkippable;
    }

    private boolean checkReversible(EventPairData eventPairData, Map<Event, CifBddEdge> eventToEdge, DebugNormalOutput dbg, Termination termination) {
        BDD commonEnabledZeroStates = eventPairData.getCommonEnabledZeroStates(termination);
        termination.throwIfRequested();
        for (Map.Entry<Event, CifBddEdge> entry : eventToEdge.entrySet()) {
            Event event3 = entry.getKey();
            if (event3 == eventPairData.event1 || event3 == eventPairData.event2) continue;
            termination.throwIfRequested();
            String evt3Name = CifTextUtils.getAbsName((PositionObject)event3);
            CifBddEdge edge3 = entry.getValue();
            BDD event21Done = eventPairData.getEvent21Done(termination);
            termination.throwIfRequested();
            if (!event21Done.isZero()) {
                BDD event1Done = eventPairData.getEvent1Done(termination);
                termination.throwIfRequested();
                BDD event21Enabled3 = event21Done.and(edge3.guard);
                termination.throwIfRequested();
                BDD event213Done = event21Enabled3.isZero() ? eventPairData.factory.zero() : edge3.apply(event21Enabled3.id(), CifBddEdgeApplyDirection.FORWARD, null);
                termination.throwIfRequested();
                event21Enabled3.free();
                boolean isReversible = !event213Done.isZero() && event213Done.equals((Object)event1Done) && this.allStatesCovered(commonEnabledZeroStates, event1Done, eventPairData.varSetOld, termination);
                termination.throwIfRequested();
                if (isReversible) {
                    // empty if block
                }
                event213Done.free();
                if (isReversible) {
                    return true;
                }
            }
            BDD event12Done = eventPairData.getEvent12Done(termination);
            termination.throwIfRequested();
            if (event12Done.isZero()) continue;
            BDD event2Done = eventPairData.getEvent2Done(termination);
            termination.throwIfRequested();
            BDD event12Enabled3 = event12Done.and(edge3.guard);
            termination.throwIfRequested();
            BDD event123Done = event12Enabled3.isZero() ? eventPairData.factory.zero() : edge3.apply(event12Enabled3.id(), CifBddEdgeApplyDirection.FORWARD, null);
            termination.throwIfRequested();
            event12Enabled3.free();
            boolean isReversible = !event123Done.isZero() && event123Done.equals((Object)event2Done) && this.allStatesCovered(commonEnabledZeroStates, event2Done, eventPairData.varSetOld, termination);
            termination.throwIfRequested();
            if (isReversible) {
                // empty if block
            }
            event123Done.free();
            if (!isReversible) continue;
            return true;
        }
        return false;
    }

    private boolean allStatesCovered(BDD commonEnabledZeroStates, BDD resultStates, BDDVarSet varSetOld, Termination termination) {
        BDD zeroResultStates = resultStates.exist(varSetOld);
        termination.throwIfRequested();
        boolean result = commonEnabledZeroStates.equals((Object)zeroResultStates);
        zeroResultStates.free();
        return result;
    }

    private Pair<String, String> makeSortedPair(String evt1Name, String evt2Name) {
        if (Strings.SORTER.compare(evt1Name, evt2Name) < 0) {
            return new Pair((Object)evt1Name, (Object)evt2Name);
        }
        return new Pair((Object)evt2Name, (Object)evt1Name);
    }

    private boolean dumpMatches(List<Pair<String, String>> pairs, String reasonText, DebugNormalOutput out, boolean needEmptyLine) {
        if (pairs.isEmpty()) {
            return needEmptyLine;
        }
        pairs.sort(Comparator.comparing(p -> (String)p.left, Strings.SORTER).thenComparing(p -> (String)p.right, Strings.SORTER));
        if (needEmptyLine) {
            out.line();
        }
        out.line(reasonText + ":");
        out.inc();
        out.line(pairs.stream().map(Pair::toString).collect(Collectors.joining(", ")));
        out.dec();
        return true;
    }
}

