/*
 * Decompiled with CFR 0.152.
 */
package xpt.navigator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorPath;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorPathSegment;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorReferenceType;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;
import xpt.Common_qvto;
import xpt.Externalizer;
import xpt.editor.VisualIDRegistry;
import xpt.navigator.AbstractNavigatorItem;
import xpt.navigator.NavigatorGroup;
import xpt.navigator.NavigatorItem;
import xpt.navigator.Utils_qvto;

@Singleton
public class NavigatorContentProvider {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private NavigatorGroup navigatorGroup;
    @Inject
    private AbstractNavigatorItem abstractNavigatorItem;
    @Inject
    private NavigatorItem xptNavigatorItem;

    public CharSequence className(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _contentProviderClassName = it.getContentProviderClassName();
        _builder.append((Object)_contentProviderClassName, "");
        return _builder;
    }

    public CharSequence packageName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    public CharSequence NavigatorContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" implements org.eclipse.ui.navigator.ICommonContentProvider {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _constructor = this.constructor(it);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _iContentProvider = this.iContentProvider(it);
        _builder.append((Object)_iContentProvider, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _iStructuredContentProvider = this.iStructuredContentProvider(it);
        _builder.append((Object)_iStructuredContentProvider, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _iMementoAware = this.iMementoAware(it);
        _builder.append((Object)_iMementoAware, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t   ");
        _builder.newLine();
        _builder.append((Object)"\t   ");
        CharSequence _iCommonContentProvider = this.iCommonContentProvider(it);
        _builder.append((Object)_iCommonContentProvider, "\t   ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t   ");
        _builder.newLine();
        _builder.append((Object)"\t   ");
        CharSequence _iTreeContentProvider = this.iTreeContentProvider(it);
        _builder.append((Object)_iTreeContentProvider, "\t   ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t   ");
        _builder.newLine();
        _builder.append((Object)"\t   ");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t   ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static final Object[] EMPTY_ARRAY = new Object[0];");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.jface.viewers.Viewer myViewer;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain myEditingDomain;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.emf.workspace.util.WorkspaceSynchronizer myWorkspaceSynchronizer;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private Runnable myViewerRefreshRunnable;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"@SuppressWarnings({ \"unchecked\", \"serial\", \"rawtypes\" })");
        _builder.newLine();
        _builder.append((Object)"public ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _initCommonAttributes = this.initCommonAttributes(it);
        _builder.append((Object)_initCommonAttributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence initCommonAttributes(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = ");
        CharSequence _createEditingDomain = this.createEditingDomain(it);
        _builder.append((Object)_createEditingDomain, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"myEditingDomain = (org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain) editingDomain;");
        _builder.newLine();
        _builder.append((Object)"myEditingDomain.setResourceToReadOnlyMap(new java.util.HashMap() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Object get(Object key) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!containsKey(key)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"put(key, Boolean.TRUE);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return super.get(key);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"myViewerRefreshRunnable = new Runnable() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void run() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (myViewer != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"myViewer.refresh();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"myWorkspaceSynchronizer = new org.eclipse.emf.workspace.util.WorkspaceSynchronizer(editingDomain, new org.eclipse.emf.workspace.util.WorkspaceSynchronizer.Delegate() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void dispose() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean handleResourceChanged(final org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _processChanges = this.processChanges(it);
        _builder.append((Object)_processChanges, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean handleResourceDeleted(org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _processChanges_1 = this.processChanges(it);
        _builder.append((Object)_processChanges_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean handleResourceMoved(org.eclipse.emf.ecore.resource.Resource resource, final org.eclipse.emf.common.util.URI newURI) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _processChanges_2 = this.processChanges(it);
        _builder.append((Object)_processChanges_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"});");
        _builder.newLine();
        return _builder;
    }

    public CharSequence processChanges(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"unloadAllResources();");
        _builder.newLine();
        _builder.append((Object)"asyncRefresh();");
        _builder.newLine();
        _builder.append((Object)"return true;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _dispose = this.dispose(it);
        _builder.append((Object)_dispose, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _inputChanged = this.inputChanged(it);
        _builder.append((Object)_inputChanged, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void unloadAllResources() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.emf.ecore.resource.Resource nextResource : myEditingDomain.getResourceSet().getResources()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"nextResource.unload();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void asyncRefresh() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (myViewer != null && !myViewer.getControl().isDisposed()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"myViewer.getControl().getDisplay().asyncExec(myViewerRefreshRunnable);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dispose(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public void dispose() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"myWorkspaceSynchronizer.dispose();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"myWorkspaceSynchronizer = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"myViewerRefreshRunnable = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"myViewer = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"unloadAllResources();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"((org.eclipse.emf.transaction.TransactionalEditingDomain) myEditingDomain).dispose();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"myEditingDomain = null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence inputChanged(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public void inputChanged(org.eclipse.jface.viewers.Viewer viewer, Object oldInput, Object newInput) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"myViewer = viewer;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iStructuredContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public Object[] getElements(Object inputElement) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return getChildren(inputElement);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iMementoAware(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public void restoreState(org.eclipse.ui.IMemento aMemento) {");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public void saveState(org.eclipse.ui.IMemento aMemento) {");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iCommonContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public void init(org.eclipse.ui.navigator.ICommonContentExtensionSite aConfig) {");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence iTreeContentProvider(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _children = this.getChildren(it);
        _builder.append((Object)_children, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _parent = this.getParent(it);
        _builder.append((Object)_parent, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _hasChildren = this.hasChildren(it);
        _builder.append((Object)_hasChildren, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public Object[] getChildren(Object parentElement) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (parentElement instanceof org.eclipse.core.resources.IFile) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _fileChildren = this.getFileChildren(it);
        _builder.append((Object)_fileChildren, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t \t");
        _builder.append((Object)"} ");
        _builder.newLine();
        _builder.append((Object)"\t\t \t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t \t");
        _builder.append((Object)"if (parentElement instanceof ");
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t\t \t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _groupChildren = this.getGroupChildren(it);
        _builder.append((Object)_groupChildren, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"} ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (parentElement instanceof ");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _itemChildren = this.getItemChildren(it);
        _builder.append((Object)_itemChildren, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        boolean _generateShortcutIcon = _diagram.generateShortcutIcon();
        if (_generateShortcutIcon) {
            _builder.append((Object)"\t");
            CharSequence _adaptableChildren = this.getAdaptableChildren(it);
            _builder.append((Object)_adaptableChildren, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        CharSequence _otherChildren = this.getOtherChildren(it);
        _builder.append((Object)_otherChildren, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        CharSequence _viewChildren = this.getViewChildren(it);
        _builder.append((Object)_viewChildren, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _utilityMethods = this.utilityMethods(it);
        _builder.append((Object)_utilityMethods, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getParent(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public Object getParent(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (element instanceof ");
        CharSequence _qualifiedClassName = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t   \t");
        CharSequence _qualifiedClassName_1 = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t   \t");
        _builder.append((Object)" abstractNavigatorItem = (");
        CharSequence _qualifiedClassName_2 = this.abstractNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t   \t");
        _builder.append((Object)") element;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return abstractNavigatorItem.getParent();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence hasChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public boolean hasChildren(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return element instanceof org.eclipse.core.resources.IFile || getChildren(element).length > 0;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getFileChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenNavigatorChildReference> references = this._utils_qvto.getChildReferencesFrom(it, null);
        _builder.newLineIfNotEmpty();
        CharSequence _fileResource = this.getFileResource(it);
        _builder.append((Object)_fileResource, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"java.util.ArrayList<");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> result = new java.util.ArrayList<");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "");
        _builder.append((Object)">();");
        _builder.newLineIfNotEmpty();
        Set<String> _groupNames = this._utils_qvto.getGroupNames(references);
        for (String string : _groupNames) {
            CharSequence _initGroupVariables = this.initGroupVariables(string, it, references, "file", null);
            _builder.append((Object)_initGroupVariables, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"java.util.ArrayList<org.eclipse.gmf.runtime.notation.View> topViews = new java.util.ArrayList<org.eclipse.gmf.runtime.notation.View>(resource.getContents().size());");
        _builder.newLine();
        _builder.append((Object)"for (org.eclipse.emf.ecore.EObject o : resource.getContents()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (o instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"topViews.add((org.eclipse.gmf.runtime.notation.View) o);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        for (GenNavigatorChildReference ref : references) {
            CharSequence _addNavigatorItemsPrefix = this.addNavigatorItemsPrefix(ref);
            _builder.append((Object)_addNavigatorItemsPrefix, "");
            _builder.append((Object)"selectViewsByType(topViews, ");
            GenCommonBase _child = ref.getChild();
            CharSequence _childViewType = this.getChildViewType(_child);
            _builder.append((Object)_childViewType, "");
            _builder.append((Object)")");
            CharSequence _addNavigatorItemsSuffix = this.addNavigatorItemsSuffix(ref, "file", false);
            _builder.append((Object)_addNavigatorItemsSuffix, "");
            _builder.newLineIfNotEmpty();
        }
        Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(references);
        for (String string : _groupNames_1) {
            CharSequence _addGroups = this.addGroups(string, references);
            _builder.append((Object)_addGroups, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"return result.toArray();");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getFileResource(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.core.resources.IFile file = (org.eclipse.core.resources.IFile) parentElement;");
        _builder.newLine();
        _builder.append((Object)"org.eclipse.emf.common.util.URI fileURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(file.getFullPath().toString(), true);");
        _builder.newLine();
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource resource = myEditingDomain.getResourceSet().getResource(fileURI, true);");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getGroupChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)" group = (");
        CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "");
        _builder.append((Object)") parentElement;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"return group.getChildren();");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getItemChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)" navigatorItem = (");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "");
        _builder.append((Object)") parentElement;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if (navigatorItem.isLeaf() || !isOwnView(navigatorItem.getView())) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return EMPTY_ARRAY;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"return getViewChildren(navigatorItem.getView(), parentElement);");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getAdaptableChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Due to plugin.xml restrictions this code will be called only for views representing");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* shortcuts to this diagram elements created on other diagrams. ");
        _builder.newLine();
        _builder.append((Object)"*/ ");
        _builder.newLine();
        _builder.append((Object)"if (parentElement instanceof org.eclipse.core.runtime.IAdaptable) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) ((org.eclipse.core.runtime.IAdaptable) parentElement).getAdapter(org.eclipse.gmf.runtime.notation.View.class);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (view != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return getViewChildren(view, parentElement);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getOtherChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"return EMPTY_ARRAY;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getViewChildren(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private Object[] getViewChildren(org.eclipse.gmf.runtime.notation.View view, Object parentElement) {");
        _builder.newLine();
        _builder.append((Object)"   \t");
        _builder.append((Object)"switch (");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(_diagram);
        _builder.append((Object)_visualIDMethodCall, "   \t");
        _builder.append((Object)"(view)) {");
        _builder.newLineIfNotEmpty();
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase node : _navigatorContainerNodes) {
            _builder.append((Object)"   \t\t");
            CharSequence _caseNavigatorNode = this.caseNavigatorNode(node, it);
            _builder.append((Object)_caseNavigatorNode, "   \t\t");
            _builder.append((Object)"\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return EMPTY_ARRAY;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence utilityMethods(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> getLinksSourceByType(java.util.Collection<org.eclipse.gmf.runtime.notation.Edge> edges, String type) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.gmf.runtime.notation.View> result = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.Edge nextEdge : edges) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View nextEdgeSource = nextEdge.getSource();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (type.equals(nextEdgeSource.getType()) && isOwnView(nextEdgeSource)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"result.add(nextEdgeSource);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> getLinksTargetByType(java.util.Collection<org.eclipse.gmf.runtime.notation.Edge> edges, String type) {");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.gmf.runtime.notation.View> result = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.Edge nextEdge : edges) {");
        _builder.newLine();
        _builder.append((Object)" \t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View nextEdgeTarget = nextEdge.getTarget();");
        _builder.newLine();
        _builder.append((Object)" \t\t");
        _builder.append((Object)"if (type.equals(nextEdgeTarget.getType()) && isOwnView(nextEdgeTarget)) {");
        _builder.newLine();
        _builder.append((Object)" \t\t\t");
        _builder.append((Object)"result.add(nextEdgeTarget);");
        _builder.newLine();
        _builder.append((Object)" \t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> getOutgoingLinksByType(java.util.Collection<? extends org.eclipse.gmf.runtime.notation.View> nodes, String type) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.gmf.runtime.notation.View> result = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.View nextNode : nodes) {");
        _builder.newLine();
        _builder.append((Object)"\t \t");
        _builder.append((Object)"result.addAll(selectViewsByType(nextNode.getSourceEdges(), type));");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> getIncomingLinksByType(java.util.Collection<? extends org.eclipse.gmf.runtime.notation.View> nodes, String type) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.gmf.runtime.notation.View> result = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.View nextNode : nodes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"result.addAll(selectViewsByType(nextNode.getTargetEdges(), type));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_4, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> getChildrenByType(java.util.Collection<? extends org.eclipse.gmf.runtime.notation.View> nodes, String type) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.gmf.runtime.notation.View> result = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.View nextNode : nodes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"result.addAll(selectViewsByType(nextNode.getChildren(), type));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_5, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> getDiagramLinksByType(java.util.Collection<org.eclipse.gmf.runtime.notation.Diagram> diagrams, String type) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.ArrayList<org.eclipse.gmf.runtime.notation.View> result = new java.util.ArrayList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.Diagram nextDiagram : diagrams) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"result.addAll(selectViewsByType(nextDiagram.getEdges(), type));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// TODO refactor as static method");
        _builder.newLine();
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_6, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<org.eclipse.gmf.runtime.notation.View> selectViewsByType(java.util.Collection<org.eclipse.gmf.runtime.notation.View> views, String type) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.ArrayList<org.eclipse.gmf.runtime.notation.View> result = new java.util.ArrayList<org.eclipse.gmf.runtime.notation.View>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.View nextView : views) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (type.equals(nextView.getType()) && isOwnView(nextView)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"result.add(nextView);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_7, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private boolean isOwnView(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        CharSequence _modelID = VisualIDRegistry.modelID(_diagram);
        _builder.append((Object)_modelID, "\t");
        _builder.append((Object)".equals(");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenDiagram _diagram_1 = _editorGen_1.getDiagram();
        CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(_diagram_1);
        _builder.append((Object)_modelIDMethodCall, "\t");
        _builder.append((Object)"(view));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment_8, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private java.util.Collection<");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)"> createNavigatorItems(java.util.Collection<org.eclipse.gmf.runtime.notation.View> views, Object parent, boolean isLeafs) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.ArrayList<");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append((Object)"> result = new java.util.ArrayList<");
        CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append((Object)">(views.size());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (org.eclipse.gmf.runtime.notation.View nextView : views) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"result.add(new ");
        CharSequence _qualifiedClassName_3 = this.xptNavigatorItem.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_3, "\t\t");
        _builder.append((Object)"(nextView, parent, isLeafs));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        CharSequence _foreignShortcuts = this.getForeignShortcuts(it);
        _builder.append((Object)_foreignShortcuts, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getForeignShortcuts(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenDiagram _diagram = _editorGen.getDiagram();
        boolean _generateCreateShortcutAction = _diagram.generateCreateShortcutAction();
        if (!_generateCreateShortcutAction) {
            _and = false;
        } else {
            GenEditorGenerator _editorGen_1 = it.getEditorGen();
            GenDiagram _diagram_1 = _editorGen_1.getDiagram();
            Iterable<GenNavigatorChildReference> _childReferencesFrom = this._utils_qvto.getChildReferencesFrom(it, (GenCommonBase)_diagram_1);
            boolean _notEmpty = this._common_qvto.notEmpty(_childReferencesFrom);
            boolean bl = _and = _generateCreateShortcutAction && _notEmpty;
        }
        if (_and) {
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"private java.util.Collection<");
            CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append((Object)"> getForeignShortcuts(org.eclipse.gmf.runtime.notation.Diagram diagram, Object parent) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"java.util.LinkedList<org.eclipse.gmf.runtime.notation.View> result = new java.util.LinkedList<org.eclipse.gmf.runtime.notation.View>();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"for (java.util.Iterator<org.eclipse.gmf.runtime.notation.View> it = diagram.getChildren().iterator(); it.hasNext();) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"org.eclipse.gmf.runtime.notation.View nextView = it.next();");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"if (!isOwnView(nextView) && nextView.getEAnnotation(\"Shortcut\") != null) { ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"result.add(nextView);");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return createNavigatorItems(result, parent, false);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence createEditingDomain(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory.INSTANCE.createEditingDomain()");
        return _builder;
    }

    public CharSequence initGroupVariables(String groupName, GenNavigator navigator, Iterable<GenNavigatorChildReference> references, String parentVarName, GenCommonBase contextElement) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.navigatorGroup.qualifiedClassName(navigator);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)" ");
        String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)groupName);
        _builder.append((Object)_validJavaIdentifier, "");
        _builder.append((Object)" = new ");
        CharSequence _qualifiedClassName_1 = this.navigatorGroup.qualifiedClassName(navigator);
        _builder.append((Object)_qualifiedClassName_1, "");
        _builder.append((Object)"(");
        _builder.newLineIfNotEmpty();
        GenEditorGenerator _editorGen = navigator.getEditorGen();
        String _i18nKeyForGroup = this.i18nKeyForGroup(groupName, contextElement);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen, _i18nKeyForGroup);
        _builder.append((Object)_accessorCall, "");
        _builder.append((Object)",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\"");
        GenNavigatorChildReference _navigatorReference = this._utils_qvto.getNavigatorReference(groupName, references);
        String _groupIcon = _navigatorReference.getGroupIcon();
        _builder.append((Object)_groupIcon, "");
        _builder.append((Object)"\", ");
        _builder.append((Object)parentVarName, "");
        _builder.append((Object)"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public String i18nKeyForGroup(String groupName, GenCommonBase contextElement) {
        String _uniqueIdentifier;
        String _xifexpression = null;
        boolean _notEquals = !Objects.equal(null, (Object)contextElement);
        _xifexpression = _notEquals ? (_uniqueIdentifier = contextElement.getUniqueIdentifier()) : "File";
        String _plus = "NavigatorGroupName." + _xifexpression;
        String _plus_1 = String.valueOf(_plus) + ".";
        String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)groupName);
        return String.valueOf(_plus_1) + _validJavaIdentifier;
    }

    public CharSequence addNavigatorItemsPrefix(GenNavigatorChildReference it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isInsideGroup = it.isInsideGroup();
        if (_isInsideGroup) {
            String _groupName = it.getGroupName();
            String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)_groupName);
            _builder.append((Object)_validJavaIdentifier, "");
            _builder.append((Object)".addChildren(");
        } else {
            _builder.append((Object)"result.addAll(");
        }
        _builder.append((Object)"createNavigatorItems(");
        return _builder;
    }

    public CharSequence addNavigatorItemsSuffix(GenNavigatorChildReference it, String parentVarName, boolean isLeaf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)", ");
        boolean _isInsideGroup = it.isInsideGroup();
        if (_isInsideGroup) {
            String _groupName = it.getGroupName();
            String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)_groupName);
            _builder.append((Object)_validJavaIdentifier, "");
        } else {
            _builder.append((Object)parentVarName, "");
        }
        _builder.append((Object)", ");
        _builder.append((Object)isLeaf, "");
        _builder.append((Object)"));");
        return _builder;
    }

    public CharSequence addGroups(String groupName, Iterable<GenNavigatorChildReference> references) {
        StringConcatenation _builder = new StringConcatenation();
        GenNavigatorChildReference ref = this._utils_qvto.getNavigatorReference(groupName, references);
        _builder.newLineIfNotEmpty();
        boolean _isHideIfEmpty = ref.isHideIfEmpty();
        if (_isHideIfEmpty) {
            _builder.append((Object)"if (!");
            String _validJavaIdentifier = CodeGenUtil.validJavaIdentifier((String)groupName);
            _builder.append((Object)_validJavaIdentifier, "");
            _builder.append((Object)".isEmpty()) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"result.add(");
            String _validJavaIdentifier_1 = CodeGenUtil.validJavaIdentifier((String)groupName);
            _builder.append((Object)_validJavaIdentifier_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"result.add(");
            String _validJavaIdentifier_2 = CodeGenUtil.validJavaIdentifier((String)groupName);
            _builder.append((Object)_validJavaIdentifier_2, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _getChildViewType(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "");
        return _builder;
    }

    protected CharSequence _getChildViewType(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
        _builder.append((Object)_typeMethodCall, "");
        return _builder;
    }

    public CharSequence caseNavigatorNode(GenCommonBase it, GenNavigator navigator) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"case ");
        CharSequence _visualID = VisualIDRegistry.visualID(it);
        _builder.append((Object)_visualID, "\t");
        _builder.append((Object)": {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.LinkedList<");
        CharSequence _qualifiedClassName = this.abstractNavigatorItem.qualifiedClassName(navigator);
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append((Object)"> result = new java.util.LinkedList<");
        CharSequence _qualifiedClassName_1 = this.abstractNavigatorItem.qualifiedClassName(navigator);
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append((Object)">(); ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _addForeignShortcuts = this.addForeignShortcuts(it);
        _builder.append((Object)_addForeignShortcuts, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        CharSequence _nailedDownVariable = this.nailedDownVariable(it, "sv", "view");
        _builder.append((Object)_nailedDownVariable, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        Iterable<GenNavigatorChildReference> references = this._utils_qvto.getChildReferencesFrom(navigator, it);
        _builder.newLineIfNotEmpty();
        Set<String> _groupNames = this._utils_qvto.getGroupNames(references);
        for (String groupName : _groupNames) {
            _builder.append((Object)"\t\t");
            CharSequence _initGroupVariables = this.initGroupVariables(groupName, navigator, references, "parentElement", it);
            _builder.append((Object)_initGroupVariables, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        boolean _and = false;
        boolean _notEmpty = this._common_qvto.notEmpty(references);
        if (!_notEmpty) {
            _and = false;
        } else {
            Functions.Function1<GenNavigatorChildReference, EList<GenNavigatorPath>> _function = new Functions.Function1<GenNavigatorChildReference, EList<GenNavigatorPath>>(){

                public EList<GenNavigatorPath> apply(GenNavigatorChildReference r) {
                    EList _findConnectionPaths = r.findConnectionPaths();
                    return _findConnectionPaths;
                }
            };
            Iterable _map = IterableExtensions.map(references, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            boolean _notEmpty_1 = this._common_qvto.notEmpty(_flatten);
            boolean bl = _and = _notEmpty && _notEmpty_1;
        }
        if (_and) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"java.util.Collection<org.eclipse.gmf.runtime.notation.View> connectedViews;");
            _builder.newLine();
            for (GenNavigatorChildReference reference : references) {
                EList _findConnectionPaths = reference.findConnectionPaths();
                for (GenNavigatorPath path : _findConnectionPaths) {
                    EList _segments = path.getSegments();
                    boolean _notEmpty_2 = this._common_qvto.notEmpty(_segments);
                    if (_notEmpty_2) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"connectedViews = ");
                        EList _segments_1 = path.getSegments();
                        GenNavigatorPathSegment _head = (GenNavigatorPathSegment)IterableExtensions.head((Iterable)_segments_1);
                        GenCommonBase _from = _head.getFrom();
                        GenNavigatorReferenceType _referenceType = reference.getReferenceType();
                        EList _segments_2 = path.getSegments();
                        GenNavigatorPathSegment _head_1 = (GenNavigatorPathSegment)IterableExtensions.head((Iterable)_segments_2);
                        CharSequence _childrenMethodName = this.childrenMethodName(_from, _referenceType, _head_1);
                        _builder.append((Object)_childrenMethodName, "\t\t\t");
                        _builder.append((Object)"(java.util.Collections.singleton(sv), ");
                        EList _segments_3 = path.getSegments();
                        GenNavigatorPathSegment _head_2 = (GenNavigatorPathSegment)IterableExtensions.head((Iterable)_segments_3);
                        GenCommonBase _to = _head_2.getTo();
                        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(_to);
                        _builder.append((Object)_typeMethodCall, "\t\t\t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        EList _segments_4 = path.getSegments();
                        Iterable _drop = IterableExtensions.drop((Iterable)_segments_4, (int)1);
                        for (GenNavigatorPathSegment segment : _drop) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"connectedViews = ");
                            GenCommonBase _from_1 = segment.getFrom();
                            GenNavigatorReferenceType _referenceType_1 = reference.getReferenceType();
                            CharSequence _childrenMethodName_1 = this.childrenMethodName(_from_1, _referenceType_1, segment);
                            _builder.append((Object)_childrenMethodName_1, "\t\t\t");
                            _builder.append((Object)"(connectedViews, ");
                            GenCommonBase _to_1 = segment.getTo();
                            CharSequence _typeMethodCall_1 = this.xptVisualIDRegistry.typeMethodCall(_to_1);
                            _builder.append((Object)_typeMethodCall_1, "\t\t\t");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append((Object)"\t\t");
                    CharSequence _addNavigatorItemsPrefix = this.addNavigatorItemsPrefix(reference);
                    _builder.append((Object)_addNavigatorItemsPrefix, "\t\t");
                    _builder.append((Object)"connectedViews");
                    GenNavigatorReferenceType _referenceType_2 = reference.getReferenceType();
                    boolean _notEquals = !Objects.equal((Object)_referenceType_2, (Object)GenNavigatorReferenceType.CHILDREN_LITERAL);
                    CharSequence _addNavigatorItemsSuffix = this.addNavigatorItemsSuffix(reference, "parentElement", _notEquals);
                    _builder.append((Object)_addNavigatorItemsSuffix, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(references);
        for (String groupName_1 : _groupNames_1) {
            _builder.append((Object)"\t\t");
            CharSequence _addGroups = this.addGroups(groupName_1, references);
            _builder.append((Object)_addGroups, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return result.toArray();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenCommonBase it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenLink it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.Edge ");
        _builder.append((Object)varName, "");
        _builder.append((Object)" = (org.eclipse.gmf.runtime.notation.Edge) ");
        _builder.append((Object)expressionToCast, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenNode it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.Node ");
        _builder.append((Object)varName, "");
        _builder.append((Object)" = (org.eclipse.gmf.runtime.notation.Node) ");
        _builder.append((Object)expressionToCast, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _nailedDownVariable(GenDiagram it, String varName, String expressionToCast) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.Diagram ");
        _builder.append((Object)varName, "");
        _builder.append((Object)" = (org.eclipse.gmf.runtime.notation.Diagram) ");
        _builder.append((Object)expressionToCast, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _addForeignShortcuts(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _generateCreateShortcutAction = it.generateCreateShortcutAction();
        if (_generateCreateShortcutAction) {
            _builder.append((Object)"result.addAll(getForeignShortcuts((org.eclipse.gmf.runtime.notation.Diagram) view, parentElement));");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _addForeignShortcuts(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _childrenMethodName(GenLink it, GenNavigatorReferenceType referenceType, GenNavigatorPathSegment segment) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal((Object)referenceType, (Object)GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        if (_equals) {
            _builder.append((Object)"getLinksTargetByType");
        } else {
            _builder.append((Object)"getLinksSourceByType");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _childrenMethodName(GenCommonBase it, GenNavigatorReferenceType referenceType, GenNavigatorPathSegment segment) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equal((Object)referenceType, (Object)GenNavigatorReferenceType.OUT_TARGET_LITERAL);
        if (_equals) {
            _builder.append((Object)"getOutgoingLinksByType");
        } else {
            boolean _equals_1 = Objects.equal((Object)referenceType, (Object)GenNavigatorReferenceType.IN_SOURCE_LITERAL);
            if (_equals_1) {
                _builder.append((Object)"getIncomingLinksByType");
            } else {
                boolean _and = false;
                GenCommonBase _from = segment.getFrom();
                boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(_from, GenDiagram.class);
                if (!_oclIsKindOf) {
                    _and = false;
                } else {
                    GenCommonBase _to = segment.getTo();
                    boolean _oclIsKindOf_1 = this._common_qvto.oclIsKindOf(_to, GenLink.class);
                    boolean bl = _and = _oclIsKindOf && _oclIsKindOf_1;
                }
                if (_and) {
                    _builder.append((Object)"getDiagramLinksByType");
                } else {
                    _builder.append((Object)"getChildrenByType");
                }
            }
        }
        return _builder;
    }

    public CharSequence additions(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenNavigatorChildReference> _childReferencesFrom = this._utils_qvto.getChildReferencesFrom(it, null);
        Set<String> _groupNames = this._utils_qvto.getGroupNames(_childReferencesFrom);
        for (String groupName : _groupNames) {
            CharSequence _internal_i18nAccessors = this.internal_i18nAccessors(groupName, null);
            _builder.append((Object)_internal_i18nAccessors, "");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase contextElement : _navigatorContainerNodes) {
            Iterable<GenNavigatorChildReference> _childReferencesFrom_1 = this._utils_qvto.getChildReferencesFrom(it, contextElement);
            Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(_childReferencesFrom_1);
            for (String groupName_1 : _groupNames_1) {
                CharSequence _internal_i18nAccessors_1 = this.internal_i18nAccessors(groupName_1, contextElement);
                _builder.append((Object)_internal_i18nAccessors_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Localization
    public CharSequence internal_i18nAccessors(String groupName, GenCommonBase contextElement) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal(null, (Object)groupName);
        if (_notEquals) {
            String _i18nKeyForGroup = this.i18nKeyForGroup(groupName, contextElement);
            CharSequence _accessorField = this.xptExternalizer.accessorField(_i18nKeyForGroup);
            _builder.append((Object)_accessorField, "");
        }
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenNavigator it) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<GenNavigatorChildReference> _childReferencesFrom = this._utils_qvto.getChildReferencesFrom(it, null);
        Set<String> _groupNames = this._utils_qvto.getGroupNames(_childReferencesFrom);
        for (String groupName : _groupNames) {
            CharSequence _internal_i18nValues = this.internal_i18nValues(groupName, null);
            _builder.append((Object)_internal_i18nValues, "");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenCommonBase> _navigatorContainerNodes = this._utils_qvto.getNavigatorContainerNodes(it);
        for (GenCommonBase contextElement : _navigatorContainerNodes) {
            Iterable<GenNavigatorChildReference> _childReferencesFrom_1 = this._utils_qvto.getChildReferencesFrom(it, contextElement);
            Set<String> _groupNames_1 = this._utils_qvto.getGroupNames(_childReferencesFrom_1);
            for (String groupName_1 : _groupNames_1) {
                CharSequence _internal_i18nValues_1 = this.internal_i18nValues(groupName_1, contextElement);
                _builder.append((Object)_internal_i18nValues_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Localization
    public CharSequence internal_i18nValues(String groupName, GenCommonBase contextElement) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal(null, (Object)groupName);
        if (_notEquals) {
            String _i18nKeyForGroup = this.i18nKeyForGroup(groupName, contextElement);
            CharSequence _messageEntry = this.xptExternalizer.messageEntry(_i18nKeyForGroup, groupName);
            _builder.append((Object)_messageEntry, "");
        }
        return _builder;
    }

    public CharSequence getChildViewType(GenCommonBase it) {
        if (it instanceof GenDiagram) {
            return this._getChildViewType((GenDiagram)it);
        }
        if (it != null) {
            return this._getChildViewType(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence nailedDownVariable(GenCommonBase it, String varName, String expressionToCast) {
        if (it instanceof GenNode) {
            return this._nailedDownVariable((GenNode)it, varName, expressionToCast);
        }
        if (it instanceof GenDiagram) {
            return this._nailedDownVariable((GenDiagram)it, varName, expressionToCast);
        }
        if (it instanceof GenLink) {
            return this._nailedDownVariable((GenLink)it, varName, expressionToCast);
        }
        if (it != null) {
            return this._nailedDownVariable(it, varName, expressionToCast);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, varName, expressionToCast).toString());
    }

    public CharSequence addForeignShortcuts(GenCommonBase it) {
        if (it instanceof GenDiagram) {
            return this._addForeignShortcuts((GenDiagram)it);
        }
        if (it != null) {
            return this._addForeignShortcuts(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence childrenMethodName(GenCommonBase it, GenNavigatorReferenceType referenceType, GenNavigatorPathSegment segment) {
        if (it instanceof GenLink) {
            return this._childrenMethodName((GenLink)it, referenceType, segment);
        }
        if (it != null) {
            return this._childrenMethodName(it, referenceType, segment);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, referenceType, segment).toString());
    }
}

