/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.shex.ShexException;

public enum StrLengthKind {
    LENGTH("Length"),
    MINLENGTH("MinLength"),
    MAXLENGTH("MaxLength");

    private final String label;

    private StrLengthKind(String string2) {
        this.label = string2;
    }

    public static StrLengthKind create(String strlength) {
        switch (strlength.toLowerCase()) {
            case "length": {
                return LENGTH;
            }
            case "minlength": {
                return MINLENGTH;
            }
            case "maxlength": {
                return MAXLENGTH;
            }
        }
        throw new ShexException("StrLengthKind not recognized: '" + strlength + "'");
    }

    public String label() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }
}

