/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.expr.RegexJava;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class PatternConstraint
extends ConstraintTerm {
    private final Pattern pattern;
    private final String patternString;
    private final String flagsStr;

    public PatternConstraint(String pattern, String flagsStr) {
        this.flagsStr = flagsStr;
        int flags = RegexJava.makeMask(flagsStr);
        this.patternString = flagsStr != null && flagsStr.contains("q") ? Pattern.quote(pattern) : pattern;
        this.pattern = Pattern.compile(pattern, flags);
    }

    public String getPattern() {
        return this.patternString;
    }

    public String getFlagsStr() {
        return this.flagsStr;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (n.isBlank()) {
            String msg = this.toString() + ": Blank node: " + ShLib.displayStr(n);
            return new ReportItem(msg, n);
        }
        String str2 = NodeFunctions.str(n);
        boolean b = this.pattern.matcher(str2).find();
        if (b) {
            return null;
        }
        String msg = this.toString() + ": Does not match: '" + str2 + "'";
        return new ReportItem(msg, n);
    }

    @Override
    public Node getComponent() {
        return SHACL.PatternConstraintComponent;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compactQuotedString(out, "pattern", this.patternString);
        if (this.flagsStr != null) {
            out.print(" ");
            CompactOut.compactQuotedString(out, "flags", this.flagsStr);
        }
    }

    public String toString() {
        if (this.flagsStr != null) {
            return "Pattern[" + this.patternString + "(" + this.flagsStr + ")]";
        }
        return "Pattern[" + this.patternString + "]";
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternConstraint)) {
            return false;
        }
        PatternConstraint other = (PatternConstraint)obj;
        return Objects.equals(this.patternString, other.patternString);
    }
}

