/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.controller.RevertCommitController;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class UIRevertCommitController
extends AbstractEMFStoreUIController {
    private final ProjectSpace projectSpace;
    private final PrimaryVersionSpec versionSpec;

    public UIRevertCommitController(Shell shell, ProjectSpace projectSpace, PrimaryVersionSpec versionSpec) {
        super(shell);
        this.projectSpace = projectSpace;
        this.versionSpec = versionSpec;
    }

    public void revertCommit() {
        MessageDialog dialog = new MessageDialog(null, "Confirmation", null, "Do you really want to revert changes of this version on project " + this.projectSpace.getProjectName(), 3, new String[]{"Yes", "No"}, 0);
        int result = dialog.open();
        if (result == 0) {
            try {
                new RevertCommitController(this.projectSpace, this.versionSpec).execute();
            }
            catch (EmfStoreException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error occurred while revert the commit: " + e.getMessage()));
            }
        }
    }
}

