/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.MEClassLabelProvider;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.util.DialogHandler;
import org.eclipse.emf.ecp.common.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.common.utilities.ActionHelper;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.ReferenceAction;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewReferenceAction
extends ReferenceAction {
    private static final String DIALOG_MESSAGE = "Select a model element type to be created:";
    private final ECPModelelementContext modelElementContext;

    public NewReferenceAction(EObject modelElement, EReference eReference, IItemPropertyDescriptor descriptor, ECPModelelementContext modelElementContext) {
        this.modelElement = modelElement;
        this.eReference = eReference;
        this.modelElementContext = modelElementContext;
        EObject obj = null;
        if (!eReference.getEReferenceType().isAbstract()) {
            obj = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create(eReference.getEReferenceType());
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Image image = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory).getImage((Object)obj);
        adapterFactory.dispose();
        ImageDescriptor addOverlay = Activator.getImageDescriptor((String)"icons/add_overlay.png");
        OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, addOverlay, 2);
        this.setImageDescriptor((ImageDescriptor)imageDescriptor);
        String attribute = descriptor.getDisplayName((Object)eReference);
        if (attribute.endsWith("ies")) {
            attribute = String.valueOf(attribute.substring(0, attribute.length() - 3)) + "y";
        } else if (attribute.endsWith("s")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        this.setToolTipText("Create and link new " + attribute);
    }

    public void run() {
        if (this.eReference.isContainer()) {
            DialogHandler.showErrorDialog((String)"Operation not permitted for container references!");
            return;
        }
        new NewReferenceCommand(this.modelElement).run(true);
    }

    private boolean isMultiReference() {
        return this.eReference.getUpperBound() != 1 && this.eReference.getUpperBound() != 0;
    }

    private final class NewReferenceCommand
    extends ECPCommand {
        public NewReferenceCommand(EObject eObject) {
            super(eObject);
        }

        protected void doRun() {
            if (!NewReferenceAction.this.checkMultiplicity(false)) {
                return;
            }
            EClass clazz = NewReferenceAction.this.eReference.getEReferenceType();
            EClass newClass = null;
            Set subclasses = NewReferenceAction.this.modelElementContext.getMetaModelElementContext().getAllSubEClasses(clazz, false);
            if (subclasses.size() == 1) {
                newClass = (EClass)subclasses.iterator().next();
            } else {
                ElementListSelectionDialog dlg = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new MEClassLabelProvider());
                dlg.setMessage(NewReferenceAction.DIALOG_MESSAGE);
                dlg.setElements(subclasses.toArray());
                dlg.setTitle("Select Element type");
                dlg.setBlockOnOpen(true);
                if (dlg.open() != 0) {
                    return;
                }
                Object result = dlg.getFirstResult();
                if (result instanceof EClass) {
                    newClass = (EClass)result;
                }
            }
            EPackage ePackage = newClass.getEPackage();
            EObject newMEInstance = ePackage.getEFactoryInstance().create(newClass);
            if (!NewReferenceAction.this.eReference.isContainer()) {
                EObject parent = NewReferenceAction.this.modelElement.eContainer();
                while (parent != null && newMEInstance.eContainer() == null) {
                    EReference reference = NewReferenceAction.this.modelElementContext.getMetaModelElementContext().getPossibleContainingReference(newMEInstance, parent);
                    if (reference != null && reference.isMany()) {
                        Object object = parent.eGet((EStructuralFeature)reference);
                        EList eList = (EList)object;
                        eList.add((Object)newMEInstance);
                    }
                    parent = parent.eContainer();
                }
                if (newMEInstance.eContainer() == null) {
                    throw new RuntimeException("No matching container for model element found");
                }
            }
            Object object = NewReferenceAction.this.modelElement.eGet((EStructuralFeature)NewReferenceAction.this.eReference);
            if (NewReferenceAction.this.isMultiReference()) {
                EList eList = (EList)object;
                eList.add((Object)newMEInstance);
            } else {
                NewReferenceAction.this.modelElement.eSet((EStructuralFeature)NewReferenceAction.this.eReference, (Object)newMEInstance);
            }
            ActionHelper.openModelElement((EObject)newMEInstance, (String)((Object)((Object)this)).getClass().getName());
        }
    }
}

