/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.util;

import org.eclipse.emf.emfstore.client.model.PostWorkspaceInitiator;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.observers.LoginObserver;
import org.eclipse.emf.emfstore.client.model.observers.LogoutObserver;
import org.eclipse.emf.emfstore.client.model.observers.ShareObserver;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;

public class ProjectListUpdater
implements PostWorkspaceInitiator,
ShareObserver,
LoginObserver,
LogoutObserver {
    private Workspace workspace;

    public void workspaceInitComplete(Workspace currentWorkspace) {
        this.workspace = currentWorkspace;
        WorkspaceManager.getObserverBus().register((IObserver)this);
    }

    public void loginCompleted(Usersession session) {
        try {
            this.update(session);
        }
        catch (EmfStoreException e) {
            WorkspaceUtil.logException("Couldn't project infos upon loginCompleted.", (Exception)((Object)e));
        }
        this.updateACUser(session);
    }

    public void shareDone(ProjectSpace projectSpace) {
        try {
            this.update(projectSpace.getUsersession());
        }
        catch (EmfStoreException e) {
            WorkspaceUtil.logException("Couldn't project infos upon shareDone.", (Exception)((Object)e));
        }
    }

    private void updateACUser(Usersession session) {
        try {
            this.workspace.updateACUser(session);
        }
        catch (EmfStoreException e) {
            WorkspaceUtil.logException("Couldn't update ACUser.", (Exception)((Object)e));
        }
    }

    private void update(Usersession session) throws EmfStoreException {
        this.workspace.updateProjectInfos(session);
    }

    public void logoutCompleted(Usersession session) {
        ServerInfo serverInfo = session.getServerInfo();
        if (serverInfo != null) {
            serverInfo.getProjectInfos().clear();
        }
    }
}

