/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.client.model.importexport.ExportImportDataUnits;
import org.eclipse.emf.emfstore.client.model.importexport.IExportImportController;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProjectHistoryController
extends ServerCall<Void>
implements IExportImportController {
    private ProjectHistory projectHistory;

    @Override
    public String getLabel() {
        return "Importing project history";
    }

    @Override
    public String[] getFilteredNames() {
        return new String[]{"EMFStore Project History Files (*" + ExportImportDataUnits.History.getExtension() + ")", "All Files (*.*)"};
    }

    @Override
    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.History.getExtension(), "*.*"};
    }

    @Override
    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.importProjectHistoryPath";
    }

    @Override
    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !(directContents.get(0) instanceof ProjectHistory)) {
            throw new IOException("File is corrupt, does not contain a ProjectHistory.");
        }
        this.projectHistory = (ProjectHistory)directContents.get(0);
        resource.getContents().remove((Object)this.projectHistory);
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public boolean isExport() {
        return false;
    }

    @Override
    protected Void run() throws EmfStoreException {
        WorkspaceManager.getInstance().getConnectionManager().importProjectHistoryToServer(this.getUsersession().getSessionId(), this.projectHistory);
        return null;
    }
}

