/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.connectionmanager;

import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.AbstractSessionProvider;
import org.eclipse.emf.emfstore.client.model.connectionmanager.BasicSessionProvider;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.server.exceptions.UnknownSessionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager {
    private AbstractSessionProvider provider;

    public void execute(ServerCall<?> serverCall) throws EmfStoreException {
        Usersession usersession = this.getSessionProvider().provideUsersession(serverCall);
        this.loginUsersession(usersession, false);
        this.executeCall(serverCall, usersession, true);
    }

    private void loginUsersession(Usersession usersession, boolean forceLogin) throws EmfStoreException {
        if (usersession == null) {
            throw new RuntimeException("Ouch.");
        }
        if (!this.isLoggedIn(usersession) || forceLogin) {
            if (usersession.getUsername() != null && !usersession.getUsername().equals("") && usersession.getPassword() != null) {
                try {
                    usersession.logIn();
                    return;
                }
                catch (EmfStoreException emfStoreException) {
                    // empty catch block
                }
            }
            this.getSessionProvider().login(usersession);
        }
    }

    private boolean isLoggedIn(Usersession usersession) {
        ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
        return usersession.isLoggedIn() && connectionManager.isLoggedIn(usersession.getSessionId());
    }

    private void executeCall(ServerCall<?> serverCall, Usersession usersession, boolean retry) throws EmfStoreException {
        try {
            serverCall.run(usersession.getSessionId());
        }
        catch (EmfStoreException e) {
            if (retry && (e instanceof SessionTimedOutException || e instanceof UnknownSessionException)) {
                this.loginUsersession(usersession, true);
                this.executeCall(serverCall, usersession, false);
            }
            throw e;
        }
    }

    private AbstractSessionProvider getSessionProvider() {
        if (this.provider == null) {
            this.provider = (AbstractSessionProvider)new ExtensionPoint("org.eclipse.emf.emfstore.client.sessionprovider").getClass("class", AbstractSessionProvider.class);
        }
        if (this.provider == null) {
            this.provider = new BasicSessionProvider();
        }
        return this.provider;
    }
}

